set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6510781';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      '4002',
      0,
      1,
      NULL,
      NULL,
      ' 1- 5-1984',
      56.107711,
      NULL,
      4,
      1.970188,
      1.219169,
      ' 2-28-1974',
      39.944200,
      2.017769,
      2,
      120.579502,
      2.535784,
      ' 9-28-1976',
      ' 7- 2-1997',
      ' 3-27-1990',
      1,
      0,
      NULL,
      1.962705,
      0,
      0.076089,
      3,
      1.135354,
      NULL,
      NULL,
      NULL,
      3.908982,
      0,
      NULL,
      14,
      1.258534,
      NULL,
      5,
      NULL,
      3.197217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      6.128655,
      NULL,
      1,
      0,
      0.998022,
      1.262848,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.024549,
      0.055407,
      1.832153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003852,
      NULL,
      0.523768,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.034215,
      NULL,
      1.454247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576688,
      1,
      0.498519,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1.190350,
      0.683379,
      0.845693,
      1.167589,
      0.132669,
      1.229339,
      NULL,
      0,
      0,
      0,
      NULL,
      1.312595,
      NULL,
      0.404795,
      NULL,
      0,
      0.590108,
      0,
      1.127033,
      NULL,
      4,
      1.700491,
      0,
      0,
      5.519724,
      NULL,
      2.989033,
      4,
      6,
      0,
      NULL,
      8.039551,
      NULL,
      0,
      2.203179,
      0,
      4,
      4.102446,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.991518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.799538,
      0.852930,
      1.372554,
      0.937421,
      1.195265,
      1.907058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.735687,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.869489,
      3.209668,
      NULL,
      1.450016,
      0,
      NULL,
      NULL,
      NULL,
      0.792333,
      1.574482,
      1.139637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      57,
      2,
      1.570832,
      NULL,
      NULL,
      NULL,
      NULL,
      0.004427,
      3.959613,
      2,
      1,
      1,
      1,
      1.726106,
      2,
      0,
      3,
      1.321471,
      2,
      2.436137,
      1.111836,
      0,
      5.292877,
      0.359942,
      1,
      2,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1.333975,
      NULL,
      1,
      0.739408,
      4,
      0.620830,
      6.129812,
      3.581691,
      NULL,
      5,
      8.940146,
      0.270623,
      2,
      0,
      0,
      3.242224,
      2,
      1.241867,
      59,
      2.042015,
      2,
      NULL,
      95.117121,
      8,
      NULL,
      3,
      3,
      3,
      '40040',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.471554,
      31,
      78.008004,
      8,
      NULL,
      24,
      8.560615,
      1,
      1,
      2,
      3,
      NULL,
      0.777926,
      NULL,
      NULL,
      0.706923,
      2,
      0.684240,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.138453,
      NULL,
      NULL,
      4.764065,
      0.445079,
      NULL,
      1.479657,
      2,
      NULL,
      2,
      NULL,
      1,
      2,
      NULL,
      3,
      3,
      1.550276,
      1.188652,
      1.600422,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.028250,
      3,
      NULL,
      NULL,
      1.361217,
      2,
      1.326422,
      NULL,
      0.866066,
      NULL,
      NULL,
      1,
      1.099211,
      1,
      NULL,
      NULL,
      1.145778,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.624679,
      NULL,
      NULL,
      6.961443,
      5,
      2.738385,
      NULL,
      0.932608,
      1,
      1,
      0.206813,
      1.684636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      6.215882,
      1.465618,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.618479,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771596,
      NULL,
      NULL,
      0.777731,
      NULL,
      NULL,
      0,
      3.733037,
      1.249061,
      3,
      0,
      0,
      2.459092,
      3,
      1.845826,
      NULL,
      3.681736,
      0.674094,
      0,
      3,
      NULL,
      2,
      1.957620,
      2,
      2,
      0,
      2.215447,
      2,
      3,
      NULL,
      3,
      4.308872,
      0,
      0.571317,
      5,
      0,
      1,
      3,
      4,
      0,
      3,
      1,
      1.508158,
      3.339476,
      2.635809,
      4,
      0,
      1.137412,
      69,
      15,
      NULL,
      2,
      0,
      NULL,
      1.181629,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3.203013,
      NULL,
      1.749954,
      1,
      0,
      0,
      0.572843,
      0,
      0,
      NULL,
      0,
      NULL,
      1.993896,
      1.067105,
      NULL,
      0,
      0.506419,
      1.593515,
      0,
      0.351867,
      1,
      3.178816,
      0.510377,
      2,
      3.224350,
      NULL,
      0,
      1.848993,
      3,
      3,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.035422,
      NULL,
      3.211838,
      4.352997,
      67.512981,
      196,
      26.026797,
      NULL,
      3.087364,
      1,
      3,
      3.112081,
      2.578156,
      1.177538,
      2,
      2.433417,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      1.479525,
      0.691277,
      3.337407,
      3,
      0.418078,
      NULL,
      3,
      0.448286,
      1.125342,
      2,
      3,
      NULL,
      0.191243,
      NULL,
      0.364870,
      0,
      NULL,
      3,
      NULL,
      1,
      3,
      0.316995,
      NULL,
      0.456537,
      0,
      1,
      NULL,
      2,
      NULL,
      2.546765,
      0,
      2,
      3,
      0.633218,
      0,
      2.500920,
      3.269741,
      NULL,
      3.957644,
      1,
      2.716538,
      0.565496,
      1.013441,
      1,
      1.295108,
      3.698591,
      4,
      4,
      8.407924,
      0.526278,
      0,
      0.590828,
      NULL,
      NULL,
      NULL,
      0,
      84,
      7,
      NULL,
      19,
      1,
      2,
      NULL,
      1.825171,
      1,
      NULL,
      NULL,
      NULL,
      91,
      8,
      1.246525,
      NULL,
      NULL,
      1,
      NULL,
      0,
      88.695050,
      NULL,
      0.592886,
      1,
      1,
      1,
      1.928462,
      0.401706,
      NULL,
      0,
      1.485947,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.079581,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.570379,
      4.758566,
      0.015103,
      2,
      5.296493,
      NULL,
      NULL,
      6.980701,
      2.873282,
      3,
      3,
      0.514552,
      1.035076,
      3,
      2.450160,
      2,
      0,
      NULL,
      0,
      2.875936,
      2.746202,
      2.975913,
      0.046987,
      2.561597,
      2,
      2,
      1,
      1.070680,
      1,
      2,
      0,
      2,
      NULL,
      0.558741,
      1,
      0,
      0,
      1,
      0,
      2,
      0.913274,
      1.132903,
      0.576646,
      0,
      NULL,
      0.742341,
      3,
      1.478248,
      2.747294,
      2.164133,
      1.552127,
      NULL,
      0,
      0.677220,
      0,
      NULL,
      1.575657,
      1,
      0,
      1,
      1.030618,
      NULL,
      1.900347,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.397665,
      NULL,
      1.968562,
      NULL,
      1,
      NULL,
      1.531310,
      2.487698,
      2,
      0,
      1.923130,
      3.270201,
      2.504771,
      3.036404,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.399034,
      0,
      NULL,
      3.022481,
      0.445490,
      0,
      1,
      3,
      2,
      1.656589,
      NULL,
      0.037075,
      1.536803,
      1,
      0.579523,
      0.286238,
      6.778057,
      1,
      0.888595,
      1.877495,
      1.433765,
      3.727482,
      1,
      0.442761,
      NULL,
      0,
      2.355260,
      0.859025,
      NULL,
      NULL,
      NULL,
      NULL,
      8.600485,
      4.550561,
      2.814983,
      3,
      '20021',
      '',
      '',
      0.393175,
      '',
      '',
      NULL,
      0.138434,
      '',
      '',
      '');
commit;
end;
/


