set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '4141122',
      0,
      1.219571,
      5,
      3,
      '1044',
      1,
      NULL,
      NULL,
      NULL,
      ' 3-21-1988',
      15.538017,
      NULL,
      1.203118,
      3,
      1.500210,
      ' 6-16-1984',
      48,
      2,
      294,
      49,
      2,
      NULL,
      ' 7- 0-1987',
      ' 4-16-1990',
      2,
      1.813682,
      NULL,
      0.868585,
      1,
      NULL,
      NULL,
      0.829740,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      7,
      5,
      NULL,
      0.666273,
      1.876608,
      8.079952,
      3.623092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507380,
      NULL,
      1,
      2,
      1,
      0.133940,
      0,
      1.772037,
      1,
      2.932620,
      0,
      6.597905,
      5,
      2,
      NULL,
      0.803752,
      1.036100,
      0.023654,
      5.579481,
      0.767353,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      7,
      4,
      2,
      0,
      1.398900,
      NULL,
      NULL,
      3.277397,
      1.956638,
      NULL,
      1,
      2.918971,
      3.399193,
      0.120777,
      0.214204,
      3,
      1.305153,
      0,
      1.460706,
      1,
      3.778205,
      NULL,
      0,
      1.211079,
      1.846146,
      0.653612,
      NULL,
      NULL,
      1.202365,
      NULL,
      NULL,
      NULL,
      1.518299,
      1.631440,
      1.954463,
      0.788706,
      NULL,
      1.991832,
      1,
      NULL,
      1,
      1,
      1.057570,
      0.951257,
      1,
      0.229546,
      0,
      NULL,
      0.348691,
      NULL,
      NULL,
      1.332611,
      7.979377,
      3.110143,
      0.415090,
      NULL,
      1.956051,
      4,
      NULL,
      1.312672,
      1.783029,
      2,
      NULL,
      NULL,
      1.712718,
      NULL,
      2.773681,
      NULL,
      4.024601,
      5.087714,
      9,
      2,
      5.800194,
      8,
      NULL,
      3,
      NULL,
      NULL,
      1.395374,
      '10- 0-1974',
      7.051154,
      ' 1- 2-1979',
      22,
      3.300911,
      1,
      NULL,
      3.277056,
      0.869708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364158,
      1,
      1,
      NULL,
      NULL,
      0.702941,
      0.188757,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875141,
      0,
      NULL,
      NULL,
      0.918710,
      1,
      1,
      0,
      4,
      0,
      1.714478,
      1.848427,
      3,
      0.318570,
      1,
      1,
      NULL,
      NULL,
      3.778791,
      0.073720,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420669,
      NULL,
      0.565320,
      1,
      0.171830,
      0,
      NULL,
      0.882858,
      35.680643,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.729734,
      NULL,
      NULL,
      2.908038,
      4,
      2,
      0,
      0,
      0.135711,
      0,
      3,
      0,
      6.772140,
      1,
      NULL,
      0,
      2.672622,
      1.241994,
      1,
      1,
      0.555669,
      0.710011,
      NULL,
      0.499692,
      1,
      0.010513,
      13,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      4,
      5,
      1.416396,
      1.531111,
      0.817166,
      0.264331,
      NULL,
      3,
      16.390647,
      3,
      3,
      NULL,
      10,
      50.076749,
      26.321338,
      0.770056,
      3,
      2.293050,
      '23214',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.173392,
      1.944765,
      0,
      NULL,
      NULL,
      0.180197,
      NULL,
      NULL,
      0.924231,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.937993,
      NULL,
      2,
      1,
      0.040825,
      0.662424,
      NULL,
      1,
      1.237629,
      NULL,
      1.319890,
      1,
      0,
      0,
      1,
      1.759997,
      1,
      NULL,
      NULL,
      2.210993,
      1.869098,
      0,
      NULL,
      1.499695,
      NULL,
      0.678011,
      NULL,
      1.574266,
      NULL,
      1,
      NULL,
      1.619485,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.553452,
      NULL,
      1.056006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840862,
      1,
      NULL,
      1.438614,
      NULL,
      0.423921,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.448840,
      NULL,
      1.755500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505266,
      1,
      NULL,
      1.339367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.016907,
      1.613590,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.810312,
      2,
      2.447890,
      1,
      1.773101,
      2.227512,
      3,
      0.137179,
      2.071734,
      NULL,
      0.162194,
      0.156884,
      NULL,
      NULL,
      NULL,
      1.529531,
      NULL,
      0.445993,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.740459,
      3.940402,
      NULL,
      2,
      2.938540,
      NULL,
      NULL,
      1.996235,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.416017,
      NULL,
      0.012710,
      0,
      NULL,
      NULL,
      0.644293,
      NULL,
      NULL,
      0,
      0.481733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.255287,
      NULL,
      0.968925,
      3,
      5,
      1.154696,
      NULL,
      NULL,
      NULL,
      108,
      0,
      3,
      0,
      '41234',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


