set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9734610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24',
      '43',
      12,
      NULL,
      '3243144',
      0,
      NULL,
      5,
      2,
      '3304',
      0,
      1.534495,
      NULL,
      NULL,
      ' 4-19-1985',
      40,
      47,
      NULL,
      NULL,
      1.046893,
      ' 8- 8-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 4-16-1987',
      1.480303,
      1,
      2,
      0,
      0,
      1.070065,
      0,
      3.218695,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.373984,
      NULL,
      1,
      NULL,
      1.415390,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.913988,
      0,
      NULL,
      2,
      1.963849,
      11,
      NULL,
      NULL,
      0,
      1.821029,
      0.405997,
      11,
      0,
      NULL,
      0.623192,
      NULL,
      1,
      NULL,
      1.025345,
      3.163044,
      0,
      NULL,
      0.847847,
      NULL,
      NULL,
      0.011620,
      NULL,
      NULL,
      0,
      0.158047,
      0.974295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907206,
      1.533296,
      0.884592,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.880557,
      1.648071,
      NULL,
      NULL,
      1.674640,
      0,
      1.300171,
      5.930325,
      0,
      0.836268,
      1,
      1,
      1.124646,
      1.219909,
      1.454537,
      NULL,
      0.869968,
      NULL,
      NULL,
      9.467070,
      6,
      3,
      0.907247,
      0,
      8,
      9.922859,
      2,
      2,
      NULL,
      NULL,
      1,
      9.056025,
      0,
      0.424675,
      9.717107,
      NULL,
      NULL,
      3,
      10.459526,
      6,
      1,
      2.268485,
      5.311797,
      5,
      1.092523,
      NULL,
      ' 6-16-1980',
      515,
      ' 7-16-1998',
      0,
      2,
      1,
      1.985917,
      7.714212,
      0.581973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.144756,
      0,
      3.099879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.911012,
      3.475747,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0.454350,
      1,
      0.197191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.870930,
      1.393309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.927296,
      1.259971,
      2.384975,
      0.756692,
      0,
      0.416890,
      0.644901,
      0,
      NULL,
      1.012914,
      NULL,
      NULL,
      NULL,
      2,
      0.613279,
      3.673842,
      3.346877,
      NULL,
      1.745030,
      2,
      3.030355,
      NULL,
      0,
      1,
      NULL,
      0,
      0.076125,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.856619,
      0.444007,
      0.370717,
      1,
      NULL,
      NULL,
      0.389120,
      0,
      1,
      2.631721,
      0,
      8,
      0.841835,
      0,
      11.930802,
      NULL,
      1.476147,
      4,
      2.853917,
      5.237329,
      2.682327,
      NULL,
      0.964521,
      36.604293,
      2,
      1.705898,
      44,
      NULL,
      46.711643,
      14,
      NULL,
      5.291923,
      NULL,
      '04222',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.312982,
      '',
      '',
      '',
      NULL,
      25,
      11.550757,
      6,
      3,
      42.105697,
      1.774200,
      NULL,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.592765,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.557790,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.434629,
      NULL,
      NULL,
      0.883201,
      NULL,
      NULL,
      3.899274,
      1.069661,
      1,
      1.205223,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.347777,
      NULL,
      NULL,
      0.115732,
      NULL,
      NULL,
      1.492731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.500085,
      NULL,
      NULL,
      0.483469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770954,
      NULL,
      NULL,
      2,
      1.519277,
      1.561447,
      1,
      NULL,
      0,
      1.080088,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2.134464,
      1.540297,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      0.444048,
      NULL,
      NULL,
      1.811264,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.088506,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      3,
      5.677441,
      NULL,
      0.561495,
      NULL,
      5,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2.211661,
      3,
      0,
      2,
      2,
      7,
      NULL,
      2.534241,
      0.271127,
      NULL,
      NULL,
      1,
      0,
      1.239704,
      NULL,
      1.383089,
      0,
      1,
      1.505928,
      0.336913,
      9.418491,
      2.891166,
      NULL,
      2.262931,
      1.587409,
      1.104592,
      NULL,
      1.292590,
      3.167399,
      0,
      1.397820,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.668235,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.607001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.949795,
      1,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      2.384559,
      5.944100,
      NULL,
      NULL,
      1.692546,
      0.272282,
      NULL,
      NULL,
      1,
      0.825191,
      NULL,
      NULL,
      2,
      3.384791,
      NULL,
      NULL,
      0.377631,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.979759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974656,
      NULL,
      NULL,
      NULL,
      1.462905,
      0.707519,
      NULL,
      NULL,
      3.013225,
      1.864386,
      NULL,
      NULL,
      0,
      0.201807,
      NULL,
      NULL,
      1.129730,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.104248,
      NULL,
      NULL,
      4.666276,
      6,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.216522,
      1.010661,
      2.158928,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.782080,
      0.174032,
      0.110435,
      0,
      NULL,
      NULL,
      0.819500,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.204758,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.427600,
      NULL,
      1.755395,
      0,
      0.353635,
      NULL,
      1,
      1,
      0.437724,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.650650,
      4,
      NULL,
      5,
      3.221870,
      3,
      3.638359,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      1.244835,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.674078,
      1,
      2.274199,
      1.744352,
      0.818181,
      3,
      2.392754,
      0.064297,
      1.279869,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      2.985588,
      2,
      0.800257,
      1.340986,
      1.640588,
      2,
      2.591411,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.178775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216864,
      NULL,
      1.192023,
      1,
      0.262699,
      0,
      1,
      NULL,
      2.054692,
      NULL,
      NULL,
      1.994236,
      69.969376,
      16,
      2,
      2.228122,
      3,
      '22413',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


