set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '0310133',
      2.202268,
      1.864909,
      6,
      NULL,
      '3011',
      2.938759,
      1.029415,
      NULL,
      NULL,
      NULL,
      55.101419,
      NULL,
      4,
      0.699202,
      1,
      '10-11-2003',
      6.872195,
      NULL,
      NULL,
      194,
      3,
      ' 2- 2-2003',
      NULL,
      ' 8- 8-1974',
      NULL,
      2,
      2,
      1.412254,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      4,
      0.432611,
      2.143309,
      7,
      20,
      1.921724,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.713538,
      1.216966,
      0,
      0,
      3.243500,
      NULL,
      NULL,
      0.949115,
      2.800816,
      NULL,
      1,
      1,
      1,
      NULL,
      2,
      0,
      0,
      0.083200,
      2.884490,
      0,
      3.903727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.337695,
      NULL,
      1.960662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.008320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800265,
      1,
      1.675739,
      0.392394,
      NULL,
      NULL,
      0,
      0,
      0.693495,
      NULL,
      2.833555,
      NULL,
      NULL,
      1.121170,
      1,
      1.858594,
      1.743316,
      NULL,
      0.391177,
      NULL,
      1,
      NULL,
      2.843752,
      4.329041,
      3.397475,
      1,
      4,
      NULL,
      0,
      3,
      3.336673,
      0,
      7,
      2,
      3.023236,
      2.735055,
      6,
      4.750715,
      0.118119,
      4.152211,
      8,
      NULL,
      NULL,
      3.798755,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.976264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896773,
      1,
      4,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.308385,
      NULL,
      0.412475,
      3,
      3.345698,
      NULL,
      0,
      0,
      2,
      2,
      3.869891,
      2,
      1,
      0.332730,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.711383,
      2,
      4.406683,
      9,
      7,
      3,
      0,
      1.044018,
      2,
      6.917613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386105,
      2.344339,
      0.118465,
      0.608172,
      0.734990,
      1,
      0,
      3,
      0.485815,
      2,
      1.511863,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.003400,
      0,
      3,
      2.568615,
      0.308271,
      NULL,
      2.265745,
      0.588912,
      2.520546,
      0,
      NULL,
      1.036085,
      2.638261,
      NULL,
      1.737332,
      0,
      0.940161,
      1,
      1.023018,
      NULL,
      1,
      NULL,
      0,
      0.821625,
      0,
      0,
      1.487939,
      14,
      0.716704,
      1,
      7.102591,
      7,
      1.250771,
      4.378264,
      2,
      4,
      0.514409,
      3,
      7.753447,
      3.109739,
      3,
      2.865723,
      14.096146,
      3,
      1.757239,
      NULL,
      8,
      7.063879,
      115,
      5.804115,
      3.231212,
      3.811831,
      '01030',
      NULL,
      '',
      1.639272,
      '',
      '',
      NULL,
      0.800818,
      NULL,
      NULL,
      '',
      3,
      18,
      35.351086,
      1.507851,
      3,
      15,
      1,
      1.045518,
      3,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.957179,
      NULL,
      NULL,
      1.332124,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.685660,
      NULL,
      NULL,
      4.332763,
      NULL,
      3.612433,
      0,
      1.310253,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.005052,
      NULL,
      0,
      1,
      1.333518,
      0,
      0,
      1.415795,
      NULL,
      NULL,
      NULL,
      0.834467,
      1.125586,
      1.516703,
      2,
      1.578025,
      0,
      NULL,
      1,
      1,
      1,
      0,
      3,
      1.252992,
      0.979533,
      1.919502,
      0,
      NULL,
      0.192246,
      0,
      NULL,
      NULL,
      NULL,
      1.158885,
      NULL,
      NULL,
      NULL,
      3.328012,
      NULL,
      0,
      1.785878,
      NULL,
      NULL,
      NULL,
      NULL,
      3.198836,
      0.319670,
      0.207237,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.674476,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      2,
      1.320395,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.254921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.322963,
      NULL,
      0.615709,
      2.540615,
      4,
      1,
      7.889369,
      1,
      1.578084,
      0,
      NULL,
      NULL,
      2.912664,
      NULL,
      2.695437,
      3,
      3.559007,
      2,
      2.282353,
      NULL,
      NULL,
      1,
      2.561174,
      1,
      0.989083,
      2,
      NULL,
      2.745165,
      1,
      3,
      3.338964,
      3,
      NULL,
      NULL,
      0,
      2.091799,
      6.918449,
      NULL,
      2.064495,
      1,
      3.226945,
      3,
      1,
      1.381777,
      1,
      0.541494,
      0,
      1,
      1.421481,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.012338,
      NULL,
      NULL,
      1.670240,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.313130,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.008662,
      0,
      1.426322,
      3,
      NULL,
      NULL,
      NULL,
      4,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820753,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.499770,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.236331,
      NULL,
      NULL,
      NULL,
      0.254970,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.798328,
      NULL,
      NULL,
      NULL,
      1.610365,
      NULL,
      NULL,
      1,
      3.274321,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.727590,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.805311,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      6,
      1,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0.140912,
      1,
      1,
      1.938941,
      1.936704,
      0,
      NULL,
      0.784299,
      0.188930,
      1,
      NULL,
      0,
      0.057263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.790429,
      2.035311,
      6,
      4.386041,
      3.031142,
      1,
      0.314304,
      1.429470,
      1,
      2,
      3.987438,
      1.914878,
      1.080902,
      1.304236,
      0,
      0,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1.959234,
      NULL,
      1.666065,
      NULL,
      1,
      0.584887,
      0,
      2,
      NULL,
      1,
      1,
      3.896837,
      NULL,
      0,
      1.833917,
      NULL,
      1.469009,
      1.065382,
      0.057843,
      2,
      0.053628,
      NULL,
      0.216722,
      3.837666,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.849113,
      1.294132,
      2,
      1,
      1,
      NULL,
      3,
      0,
      0,
      1,
      2.605194,
      0,
      1.517529,
      1.411263,
      1.603258,
      3,
      0.867859,
      3,
      1,
      1.401531,
      1,
      1,
      1,
      NULL,
      1,
      7.049087,
      1.694447,
      NULL,
      1.791221,
      1,
      3,
      1.920096,
      1.977971,
      0.064024,
      5,
      2.616863,
      7,
      NULL,
      NULL,
      NULL,
      65,
      25,
      0.445515,
      NULL,
      6,
      '30103',
      NULL,
      '43344',
      1.460773,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


