set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636027';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      '32',
      25,
      34.072176,
      '2401010',
      NULL,
      NULL,
      2,
      0,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      ' 6- 5-1990',
      NULL,
      NULL,
      NULL,
      1,
      1,
      ' 5-16-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '11-12-1980',
      ' 4-16-1996',
      ' 3- 6-1996',
      3.973716,
      3.516587,
      0,
      0.376056,
      1,
      1,
      7,
      NULL,
      NULL,
      147.116898,
      0.846143,
      9,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      4.229472,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.905824,
      0,
      1,
      0.262717,
      0.977625,
      1.342567,
      NULL,
      0.893352,
      1,
      0.518074,
      0.536301,
      NULL,
      0.362874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593013,
      0,
      1.614009,
      0.529957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362239,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666288,
      0,
      0.677135,
      1.490945,
      0,
      NULL,
      0.717390,
      1,
      0.846816,
      1,
      1,
      0.651203,
      0.541450,
      NULL,
      1,
      1,
      0.459204,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.351556,
      NULL,
      0,
      1,
      1.860375,
      1.025264,
      1.034124,
      0,
      0.077365,
      0.032181,
      1,
      0.481755,
      3.364540,
      NULL,
      NULL,
      0.105577,
      NULL,
      9.758132,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.295915,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.036981,
      0,
      NULL,
      1,
      1.465956,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.450096,
      NULL,
      1.615394,
      1.091968,
      NULL,
      NULL,
      0.925447,
      NULL,
      6,
      3.918928,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.852977,
      0.701450,
      2.249743,
      2.616396,
      1,
      3.867517,
      NULL,
      NULL,
      3,
      1.547426,
      0,
      1.514651,
      1,
      2.477716,
      0.719552,
      1.138094,
      NULL,
      1.162618,
      0,
      1.901399,
      1.697471,
      1.898056,
      0,
      0.827864,
      0.847772,
      1,
      0.053648,
      0,
      1.732302,
      11,
      1.868939,
      5.244320,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0.442728,
      1,
      1.944480,
      3.874234,
      37,
      NULL,
      NULL,
      27,
      NULL,
      5.469144,
      NULL,
      2.940287,
      5.028348,
      3,
      '23322',
      '',
      '',
      0,
      '',
      '',
      NULL,
      2,
      '32101',
      '1114',
      '',
      2.263247,
      43.750158,
      NULL,
      NULL,
      NULL,
      74.194037,
      10,
      2.052366,
      2.315754,
      2.597305,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.249446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518345,
      NULL,
      0.777524,
      NULL,
      0,
      3,
      0.001903,
      0.655384,
      0.375732,
      0.088209,
      1.103519,
      NULL,
      1.223358,
      1.767718,
      2,
      0,
      NULL,
      2.536992,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.221053,
      NULL,
      NULL,
      NULL,
      1.423096,
      0.726123,
      1.844315,
      NULL,
      NULL,
      NULL,
      1.677581,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.108325,
      1,
      3.577512,
      0,
      1.127320,
      1,
      1,
      1.636462,
      0,
      0.805814,
      3,
      1,
      1.142796,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.128792,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.680652,
      1,
      1,
      NULL,
      0.700223,
      2.331519,
      2,
      1.271469,
      0,
      NULL,
      NULL,
      8,
      0,
      1.772342,
      2.595922,
      1,
      1,
      3.552146,
      1.294918,
      1.320654,
      5,
      NULL,
      1.799054,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088732,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.761871,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.872869,
      NULL,
      NULL,
      1.064832,
      NULL,
      NULL,
      1,
      2.327496,
      1,
      3.163852,
      1.697775,
      0,
      3,
      0.126831,
      1,
      6,
      NULL,
      3,
      NULL,
      3,
      1,
      2,
      0,
      2.940183,
      3,
      1.471181,
      NULL,
      2.933809,
      2,
      1.167621,
      7,
      1.696126,
      1,
      0,
      NULL,
      NULL,
      3.449679,
      0.689446,
      0.039941,
      0.930783,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.874687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.694377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.922464,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3.608612,
      2.031232,
      1.781807,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.706556,
      NULL,
      NULL,
      3.925149,
      NULL,
      NULL,
      NULL,
      0.385693,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793636,
      NULL,
      NULL,
      1.584141,
      NULL,
      NULL,
      NULL,
      0.816630,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.386401,
      NULL,
      NULL,
      NULL,
      0.116392,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0.216642,
      NULL,
      NULL,
      2,
      0.506444,
      NULL,
      NULL,
      2,
      2.609138,
      3,
      3,
      3,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.601709,
      NULL,
      NULL,
      3,
      1.677915,
      111.054260,
      3,
      1.407947,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256881,
      1429.925766,
      75260.549435,
      1.323599,
      2,
      NULL,
      0.932538,
      0.279665,
      2,
      0.266307,
      2.966077,
      0.401630,
      3,
      1.648365,
      3,
      NULL,
      2,
      1.356323,
      1.684489,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.282737,
      NULL,
      0,
      NULL,
      2.512532,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2.680549,
      0.799502,
      0,
      NULL,
      1.136145,
      NULL,
      NULL,
      NULL,
      1.023051,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.801574,
      NULL,
      3,
      NULL,
      1.601682,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.151033,
      NULL,
      0,
      NULL,
      0.588959,
      0.587061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610903,
      NULL,
      0.429387,
      1.791739,
      1.772525,
      3.226826,
      0.029571,
      NULL,
      1.948982,
      2.440253,
      3,
      NULL,
      1,
      1.193073,
      0.823063,
      NULL,
      0.353556,
      0,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.293136,
      0.462036,
      NULL,
      0.152054,
      3,
      NULL,
      0.609815,
      NULL,
      0,
      NULL,
      0,
      0.456295,
      0,
      0.989526,
      1,
      2,
      NULL,
      1.606757,
      2.054151,
      0.349865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.679755,
      NULL,
      0.969284,
      NULL,
      0,
      NULL,
      0.444073,
      NULL,
      0.887825,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.340304,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.892153,
      NULL,
      NULL,
      NULL,
      43,
      1,
      NULL,
      0.438830,
      NULL,
      1.309328,
      NULL,
      1,
      NULL,
      5,
      1,
      3.397334,
      0.444582,
      NULL,
      NULL,
      130.763864,
      16.770632,
      5,
      3.926663,
      0,
      '32200',
      NULL,
      '',
      0.365405,
      '',
      '',
      '',
      3.499038,
      '02102',
      '0244',
      '');
commit;
end;
/


