set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '3100410',
      3.095330,
      NULL,
      5,
      1,
      '3100',
      1.962175,
      1.932057,
      NULL,
      NULL,
      ' 4-19-1991',
      NULL,
      NULL,
      5,
      3,
      0,
      ' 6- 1-1998',
      24.761209,
      0,
      NULL,
      45,
      1.622448,
      '10-21-1990',
      NULL,
      NULL,
      2.496669,
      3.387597,
      3.593257,
      2,
      0.833904,
      3.547083,
      3,
      0,
      1,
      NULL,
      NULL,
      12,
      NULL,
      25,
      6.819240,
      5,
      2,
      1,
      9,
      NULL,
      NULL,
      NULL,
      1,
      0.331529,
      1.863689,
      NULL,
      0.878841,
      1,
      1.857044,
      2.570805,
      0,
      4,
      0.936372,
      2.185959,
      3.834368,
      0.332378,
      0.371407,
      0,
      2,
      NULL,
      0,
      2.899816,
      5.641997,
      0,
      1.187851,
      1,
      0,
      NULL,
      0,
      5.187850,
      1.838264,
      3.901772,
      0.439600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.701371,
      0,
      1.796117,
      2.326787,
      3,
      0,
      3,
      1.188881,
      3.254701,
      NULL,
      0.940861,
      3.217065,
      NULL,
      NULL,
      0.125054,
      0,
      1.465998,
      0.874169,
      1.736204,
      0,
      0.742530,
      0,
      6.308219,
      0.072818,
      0,
      0,
      1,
      NULL,
      NULL,
      1.361832,
      NULL,
      NULL,
      0,
      3,
      3.766287,
      0.141032,
      1.286009,
      1,
      4.687507,
      NULL,
      1,
      3,
      4,
      4,
      NULL,
      5,
      NULL,
      0.988094,
      0,
      1,
      0,
      NULL,
      0.831295,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      1.991278,
      0,
      3,
      8.614943,
      NULL,
      NULL,
      5.593213,
      0.577201,
      7,
      9.231670,
      NULL,
      2.649246,
      NULL,
      7,
      2,
      9,
      9,
      6.026723,
      0,
      1,
      2.042080,
      '11-26-2003',
      155.057240,
      NULL,
      NULL,
      1.594777,
      1.987792,
      1.380421,
      2.592573,
      0.900127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.479658,
      NULL,
      1,
      0.572489,
      0,
      1.348379,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471958,
      NULL,
      NULL,
      2.930025,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.461706,
      4,
      4,
      3.611950,
      5,
      4,
      3,
      2,
      NULL,
      0.755591,
      NULL,
      0.713300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.396598,
      NULL,
      1,
      NULL,
      0.372061,
      0,
      1,
      0,
      31,
      3.980796,
      0.345911,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794102,
      2.369025,
      3,
      3,
      2.079687,
      0.575122,
      3,
      1,
      2,
      1.554663,
      2.815149,
      3,
      3,
      0.933643,
      0,
      1.154063,
      0,
      1.125874,
      2.240001,
      1.025762,
      1,
      1.930431,
      0,
      NULL,
      NULL,
      0.391099,
      0.943585,
      0.372549,
      1.440985,
      0,
      1,
      5.373509,
      3.750006,
      NULL,
      3,
      1,
      4,
      NULL,
      0,
      4,
      3.935175,
      3.669052,
      NULL,
      31,
      3.556596,
      0.106480,
      NULL,
      44,
      NULL,
      32,
      5.119599,
      3,
      NULL,
      '14420',
      NULL,
      '24221',
      2,
      '1203',
      '',
      NULL,
      1,
      NULL,
      NULL,
      '',
      3,
      3.774690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166873,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2.902292,
      1.093015,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.395395,
      2.061347,
      1,
      NULL,
      NULL,
      1.231835,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.576174,
      NULL,
      NULL,
      0.121517,
      NULL,
      NULL,
      2.884536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.316360,
      1.070098,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.485429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.445612,
      3.761679,
      0.776028,
      NULL,
      NULL,
      0.049307,
      NULL,
      NULL,
      NULL,
      3.197852,
      4.654633,
      1,
      2,
      1.322492,
      0.366805,
      1,
      1.265580,
      5.106306,
      2.845684,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0,
      5.018804,
      1,
      2.446861,
      NULL,
      4,
      1,
      NULL,
      NULL,
      0.043561,
      NULL,
      1,
      1,
      1,
      2.606257,
      3,
      0.679696,
      NULL,
      7,
      5,
      5,
      NULL,
      0,
      0.699817,
      1,
      0.756745,
      NULL,
      2.192757,
      1.962922,
      NULL,
      0,
      2.909022,
      1.291445,
      4.265439,
      NULL,
      7,
      4.574048,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      1.595414,
      1.229387,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.146000,
      1,
      0,
      0.548554,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083297,
      0.954227,
      5,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.622473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      81.378912,
      15,
      1.501187,
      3,
      1,
      0.411806,
      1,
      0.848945,
      0,
      0,
      0,
      2.917438,
      0,
      NULL,
      1.351626,
      1,
      1.633670,
      0.214377,
      1.084647,
      NULL,
      NULL,
      0.373258,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.622147,
      NULL,
      NULL,
      NULL,
      NULL,
      24.815896,
      5,
      0.747895,
      1.342614,
      NULL,
      NULL,
      1.039794,
      NULL,
      0,
      NULL,
      0.959501,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.856412,
      NULL,
      1,
      NULL,
      0.935750,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.717923,
      NULL,
      1.312467,
      1.984495,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318761,
      0.561697,
      NULL,
      3.285561,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.912922,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453719,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545540,
      3,
      NULL,
      1,
      NULL,
      2.715830,
      NULL,
      145.681064,
      NULL,
      2.392767,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.062211,
      24,
      12.052400,
      0,
      NULL,
      NULL,
      NULL,
      3.874089,
      2.031894,
      1,
      3.250994,
      1,
      NULL,
      1.133201,
      2.227245,
      4,
      1.049302,
      1.818559,
      0,
      1,
      1.783654,
      NULL,
      1,
      3.734472,
      NULL,
      NULL,
      1,
      NULL,
      0.507616,
      1,
      NULL,
      2.234433,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.535039,
      NULL,
      1,
      1.333151,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.129519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684146,
      NULL,
      1,
      NULL,
      1,
      5.409111,
      5.623003,
      1,
      NULL,
      1,
      72,
      74.838313,
      2.608136,
      4.638715,
      2.555366,
      '11221',
      '01343',
      NULL,
      2,
      '4014',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


