set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7626303';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '1423323',
      0,
      NULL,
      2,
      0,
      '2131',
      0,
      1,
      3,
      NULL,
      ' 2-15-1982',
      33,
      NULL,
      5.606095,
      3.268296,
      1.659220,
      ' 6-21-1981',
      NULL,
      4,
      281.255837,
      80.949288,
      NULL,
      NULL,
      NULL,
      ' 9-28-2002',
      3.538031,
      0.438452,
      1.896869,
      0,
      0.824644,
      0,
      4.781611,
      0,
      1,
      1413.990017,
      5.590624,
      5.547157,
      5.482499,
      NULL,
      29.293984,
      0.674278,
      12.401253,
      0.220980,
      1.886485,
      9.865046,
      1,
      4.457627,
      0.296495,
      1.128795,
      1.365114,
      0.369600,
      0,
      1.605576,
      1.639358,
      1.330112,
      NULL,
      3,
      2,
      3,
      3,
      NULL,
      0.319985,
      1,
      3.005593,
      1.823042,
      NULL,
      NULL,
      1.442355,
      1.865237,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      2.021232,
      0.607247,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0.472456,
      NULL,
      0,
      0.600944,
      1.442904,
      1,
      1,
      1.708795,
      1.647483,
      0,
      1.613887,
      NULL,
      0.088472,
      3,
      0,
      NULL,
      0,
      NULL,
      1,
      0.652912,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732071,
      NULL,
      1,
      NULL,
      1,
      NULL,
      7,
      0,
      1.347853,
      0.246597,
      1,
      1,
      1.790966,
      3,
      0.098452,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      6,
      1,
      1.543545,
      NULL,
      2.890854,
      NULL,
      4.729260,
      NULL,
      2,
      1.807273,
      5.195727,
      5.877594,
      NULL,
      1,
      6.965248,
      8,
      5.201601,
      5.608235,
      1,
      4.232105,
      3.019307,
      9.902255,
      0.382724,
      0.225581,
      1,
      NULL,
      ' 8-24-1976',
      NULL,
      ' 9-10-2000',
      150,
      2,
      NULL,
      0,
      0.858240,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.555753,
      NULL,
      NULL,
      NULL,
      2.913945,
      NULL,
      1,
      1.107077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947180,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.277882,
      3.400667,
      NULL,
      1.327911,
      0.851532,
      1.231117,
      3.509625,
      NULL,
      3,
      NULL,
      0.963632,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.932533,
      NULL,
      1,
      2,
      0.232483,
      NULL,
      0,
      NULL,
      0,
      0.887557,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      1,
      1.676820,
      0,
      NULL,
      0.675634,
      2.307232,
      1.987804,
      0.025304,
      2.978410,
      NULL,
      1.586333,
      1,
      1.342821,
      1.271157,
      1.701868,
      NULL,
      1,
      3,
      0.196296,
      0,
      0.304323,
      NULL,
      0,
      1,
      0.822724,
      0,
      1.983510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '43120',
      '',
      '',
      0.772261,
      '',
      '',
      '',
      0.110778,
      '',
      '',
      '',
      NULL,
      23.834976,
      NULL,
      39.435875,
      3,
      2,
      1.600740,
      1205,
      2,
      2,
      3,
      1.822725,
      0.158498,
      2,
      0.377815,
      0.724672,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211518,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      2.905772,
      1.123416,
      0,
      1,
      0.745959,
      0.615230,
      0,
      0,
      2,
      1.908400,
      0.818006,
      1,
      1.745067,
      1.879438,
      3.739568,
      1,
      0,
      6,
      5,
      2.401417,
      3.788978,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.857796,
      3,
      2,
      0.908624,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.983603,
      NULL,
      NULL,
      0,
      1.618136,
      0,
      1.586186,
      3.079908,
      1.242233,
      1.025259,
      NULL,
      0,
      NULL,
      0,
      0.928736,
      NULL,
      NULL,
      0,
      NULL,
      1.512887,
      NULL,
      NULL,
      2,
      1,
      0.308966,
      3.452819,
      NULL,
      0,
      3,
      1.822362,
      3,
      NULL,
      1.504781,
      NULL,
      NULL,
      NULL,
      0.278753,
      NULL,
      2.614052,
      NULL,
      0,
      NULL,
      NULL,
      3.944872,
      19.300815,
      0,
      NULL,
      3.180984,
      1.942076,
      0,
      NULL,
      NULL,
      4,
      0.611037,
      0.411241,
      NULL,
      1.750491,
      NULL,
      0.053972,
      1,
      2,
      NULL,
      2,
      4.272418,
      0.730902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.052981,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.006085,
      2.247733,
      0,
      4,
      7,
      5.660801,
      0,
      1.578179,
      3.462619,
      5.763741,
      2.979201,
      1,
      0,
      3,
      1,
      0,
      3.935832,
      3.051118,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.297791,
      0.665520,
      NULL,
      3,
      1.570015,
      NULL,
      NULL,
      3.114165,
      1,
      NULL,
      3.331033,
      NULL,
      3.317663,
      6,
      0,
      3.215389,
      NULL,
      4,
      0,
      0.556466,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      3.855627,
      NULL,
      NULL,
      4.761370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.271702,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.147799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.789697,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.326932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.532731,
      0.827762,
      0.495943,
      3.819340,
      0.163267,
      1,
      NULL,
      5.804986,
      2.910975,
      NULL,
      NULL,
      189,
      849,
      NULL,
      NULL,
      2.997778,
      0,
      NULL,
      NULL,
      1,
      0.337562,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.815002,
      NULL,
      NULL,
      1.354651,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.952355,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1.508949,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      196.593843,
      0,
      0.543866,
      0.409501,
      NULL,
      3,
      1856.654406,
      832.787294,
      NULL,
      NULL,
      974.498229,
      1,
      NULL,
      NULL,
      2,
      568,
      1486,
      0,
      1887,
      NULL,
      0.159813,
      NULL,
      NULL,
      2,
      6,
      NULL,
      16401,
      16,
      0.190984,
      1,
      1,
      0,
      1,
      1.055151,
      0,
      0.078326,
      0.045712,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1.040286,
      NULL,
      1.989091,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.737019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.722914,
      4.655207,
      5.771691,
      1.245215,
      1,
      3.060344,
      3.537536,
      1,
      0,
      1.746925,
      2.476787,
      NULL,
      1,
      NULL,
      NULL,
      2.643841,
      1,
      NULL,
      3.643677,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.253907,
      0,
      NULL,
      1,
      2.891518,
      NULL,
      1.401692,
      1,
      NULL,
      1.971624,
      3,
      NULL,
      NULL,
      3.221502,
      NULL,
      1.261149,
      0.409047,
      NULL,
      1,
      0.449256,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617824,
      NULL,
      0,
      NULL,
      0.871875,
      NULL,
      1.480232,
      NULL,
      2,
      0.734330,
      1.162366,
      NULL,
      8.572949,
      32,
      5,
      1,
      0,
      '32324',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL);
commit;
end;
/


