set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8901642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24',
      '32',
      2,
      19,
      NULL,
      1.803110,
      0.714036,
      NULL,
      0,
      '2344',
      0,
      0,
      NULL,
      NULL,
      ' 2- 7-1978',
      16.025768,
      NULL,
      NULL,
      0.956822,
      NULL,
      ' 2-15-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      1.757684,
      ' 9-17-1985',
      NULL,
      ' 0-25-1976',
      0.897811,
      3,
      1.157533,
      NULL,
      2,
      1.046012,
      0.834538,
      3,
      NULL,
      NULL,
      NULL,
      4,
      5.081234,
      NULL,
      NULL,
      NULL,
      NULL,
      9.863637,
      5.618910,
      NULL,
      1.154690,
      5,
      1,
      0,
      1.446561,
      0.267213,
      1,
      3,
      0.681655,
      NULL,
      1,
      NULL,
      2.196002,
      0,
      NULL,
      1.763879,
      1,
      1.000967,
      1,
      NULL,
      NULL,
      2,
      4,
      5.997069,
      1,
      2.197261,
      7.578498,
      NULL,
      1.323308,
      1,
      0.884938,
      5,
      0.663896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.388171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.667667,
      0.832900,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.648159,
      1.515567,
      4,
      2.124460,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.848967,
      NULL,
      2,
      1,
      0,
      0,
      1,
      0.423840,
      NULL,
      1.334817,
      1.175829,
      3.062330,
      0.936795,
      0.396928,
      9.798850,
      9.080276,
      NULL,
      NULL,
      0,
      3,
      1.186794,
      NULL,
      3.381008,
      NULL,
      NULL,
      7,
      5,
      NULL,
      2,
      2.455738,
      2.471991,
      6.773989,
      6.986981,
      NULL,
      0.356062,
      1.984023,
      1,
      NULL,
      585,
      ' 7-23-1978',
      3,
      NULL,
      1.450255,
      0,
      1.155635,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.010002,
      NULL,
      1,
      1,
      0.417280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8,
      1.873051,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.726549,
      7,
      1,
      5,
      3,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.017280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0.601154,
      0,
      58.932230,
      1.793787,
      0.996104,
      NULL,
      NULL,
      NULL,
      3.666406,
      NULL,
      1,
      1.921314,
      1,
      3.118631,
      NULL,
      NULL,
      2.790162,
      2,
      0,
      NULL,
      0,
      0.588989,
      3,
      1.245901,
      NULL,
      1,
      0.148749,
      0.706349,
      0.854456,
      0.615771,
      1.069088,
      0.963917,
      1.010240,
      0,
      1.537835,
      0,
      0,
      1.034187,
      NULL,
      1.528617,
      11.538052,
      NULL,
      5.679348,
      NULL,
      3.397986,
      1.705873,
      NULL,
      1.120737,
      7,
      2,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.663421,
      63,
      2.483309,
      4.414464,
      0,
      '40004',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.293534,
      NULL,
      NULL,
      NULL,
      2,
      35.858540,
      121,
      17.388255,
      3,
      23.606519,
      7.041659,
      1,
      0,
      0.436596,
      0,
      2.366684,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.972005,
      NULL,
      NULL,
      1.270122,
      NULL,
      NULL,
      2,
      0.918332,
      NULL,
      0.526713,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.535341,
      NULL,
      NULL,
      0.916021,
      NULL,
      NULL,
      7.459934,
      0.625986,
      NULL,
      0.954037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.182865,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.703528,
      NULL,
      NULL,
      0.533413,
      NULL,
      NULL,
      1.035400,
      NULL,
      NULL,
      1.334342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.780150,
      NULL,
      1.530133,
      3.901406,
      0,
      0,
      1.499037,
      NULL,
      NULL,
      9,
      3,
      3.716485,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.650839,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.074318,
      NULL,
      NULL,
      1.303461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128152,
      NULL,
      NULL,
      0.060827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.481524,
      NULL,
      NULL,
      4,
      0,
      0.563551,
      1.634226,
      NULL,
      NULL,
      0.357310,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2.515094,
      3,
      0.277377,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.749588,
      0.523284,
      3.541323,
      2.724650,
      0,
      1,
      1.407509,
      2,
      1,
      0,
      0.451504,
      7.099168,
      0.948045,
      1,
      1,
      0.436854,
      1,
      3.215596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.386278,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.889045,
      NULL,
      NULL,
      4.214993,
      NULL,
      NULL,
      0,
      2,
      0.446195,
      1.689418,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      1,
      465,
      NULL,
      NULL,
      1.558782,
      1,
      NULL,
      NULL,
      3,
      1.990777,
      NULL,
      NULL,
      0.099275,
      0.738004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.002033,
      1.020745,
      NULL,
      NULL,
      3.722318,
      NULL,
      NULL,
      NULL,
      2.590771,
      2.719186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.804662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678041,
      3.539694,
      NULL,
      NULL,
      3.824751,
      2.176256,
      NULL,
      1.043780,
      NULL,
      3.080562,
      1.607731,
      NULL,
      NULL,
      1.998001,
      1.166075,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.093561,
      0.934031,
      1.251129,
      NULL,
      NULL,
      NULL,
      71.533791,
      0.213732,
      1.199720,
      1.729507,
      0,
      0.091043,
      0,
      1,
      0,
      NULL,
      1.520304,
      1,
      0,
      0,
      NULL,
      0.502494,
      0,
      0.186969,
      NULL,
      0.622110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.366043,
      1,
      0.993014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.332561,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.399364,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.238719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609113,
      0.944105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0,
      0.008964,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335405,
      NULL,
      4.035712,
      4,
      1.804901,
      1.538175,
      1.367382,
      3.578980,
      NULL,
      3,
      NULL,
      2,
      0,
      0.862921,
      0,
      1.690208,
      1.319494,
      0,
      1.250769,
      1,
      0,
      1.306248,
      0.974845,
      NULL,
      NULL,
      1.482369,
      0.854863,
      1,
      0,
      3.815893,
      2,
      0.132007,
      NULL,
      1.223549,
      0,
      3.753434,
      2.960682,
      2,
      3.854384,
      3.997243,
      0,
      0.831280,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.540838,
      0,
      1,
      3.028149,
      0,
      3.108189,
      3,
      0.455296,
      0,
      3,
      0,
      3.816280,
      NULL,
      NULL,
      0.257614,
      3.956694,
      0.200285,
      NULL,
      0,
      0.264094,
      1.288909,
      1.352857,
      0,
      0.158028,
      1.932858,
      15,
      1,
      NULL,
      1,
      0.101069,
      0,
      1.689089,
      1,
      0.254634,
      3.471260,
      5.262939,
      3,
      2,
      0.953432,
      NULL,
      65.585097,
      70.190709,
      1.084107,
      2.231875,
      NULL,
      '01422',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


