set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3210420',
      NULL,
      0.537650,
      5,
      NULL,
      '2201',
      3.549375,
      0.713466,
      NULL,
      NULL,
      '11-22-1974',
      28,
      NULL,
      NULL,
      3.740127,
      1.567135,
      ' 2- 4-1984',
      27,
      2.955420,
      239,
      NULL,
      1,
      NULL,
      NULL,
      ' 9-12-1985',
      NULL,
      1.930035,
      NULL,
      0.901605,
      0.577888,
      1,
      1.454290,
      2,
      NULL,
      NULL,
      NULL,
      8,
      1,
      30.798779,
      15.692627,
      2,
      9,
      2.479757,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1.557032,
      1,
      1,
      3,
      4,
      4.343627,
      1,
      1,
      0,
      0,
      0.242017,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.655211,
      1.930500,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      0.612092,
      0.076753,
      1.691536,
      0,
      0.520116,
      1,
      0.136958,
      0.658075,
      NULL,
      0,
      0.733713,
      1.003178,
      NULL,
      NULL,
      9.995208,
      4,
      1.607698,
      1,
      0.960927,
      7.128306,
      3.677364,
      4.964381,
      NULL,
      1.161265,
      NULL,
      NULL,
      3,
      NULL,
      0.443859,
      NULL,
      0.209251,
      0.972061,
      4,
      0,
      NULL,
      0,
      NULL,
      0,
      0.399976,
      1.495179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.305951,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      0,
      0.720071,
      0,
      2.534936,
      0.689124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.654240,
      NULL,
      0.865232,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.297404,
      1.720246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.138346,
      0.267761,
      NULL,
      0.731176,
      0.852408,
      1.783175,
      NULL,
      NULL,
      0.365024,
      NULL,
      NULL,
      NULL,
      3,
      1.645951,
      3,
      2.715112,
      2,
      3,
      1,
      2.823393,
      2.441033,
      NULL,
      3,
      NULL,
      1,
      3.662364,
      0,
      3,
      1.926600,
      NULL,
      0,
      0.234436,
      0.311378,
      1.418210,
      NULL,
      1.704672,
      1.558106,
      1.864615,
      0.757489,
      NULL,
      0,
      2.397543,
      5.633967,
      NULL,
      5.816833,
      NULL,
      NULL,
      7.421657,
      11.002818,
      1.776556,
      3,
      0,
      6,
      1.631071,
      3,
      3.522385,
      33,
      0.976570,
      1.980871,
      30,
      NULL,
      NULL,
      NULL,
      2.469033,
      0,
      NULL,
      '40322',
      '',
      '',
      1,
      '',
      '',
      '',
      1.358054,
      NULL,
      NULL,
      '',
      1.453015,
      33,
      11,
      NULL,
      NULL,
      25,
      NULL,
      1.984327,
      2.246751,
      0.634518,
      NULL,
      NULL,
      1.945763,
      NULL,
      NULL,
      1.775799,
      NULL,
      NULL,
      0.425234,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.495436,
      NULL,
      NULL,
      0.127891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.408700,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.184667,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830693,
      NULL,
      NULL,
      0.193101,
      NULL,
      NULL,
      0.661661,
      NULL,
      NULL,
      1.198128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.343295,
      1.374513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      4,
      NULL,
      2.055248,
      1,
      1.770449,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203340,
      NULL,
      NULL,
      1.648027,
      NULL,
      NULL,
      0.784686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      1,
      3.798937,
      0,
      3,
      8,
      1,
      4.064010,
      NULL,
      NULL,
      1,
      6,
      NULL,
      3.027398,
      0,
      NULL,
      NULL,
      0,
      0,
      1.953567,
      1,
      0,
      3,
      1.246399,
      1,
      4,
      2.707674,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.414403,
      2.381262,
      0,
      3,
      3,
      1,
      7,
      7,
      0.545330,
      9.031362,
      1.787881,
      0.421645,
      2,
      2.545767,
      2.661133,
      1.988756,
      1.397803,
      1.921219,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.317261,
      0,
      3,
      1.374762,
      NULL,
      NULL,
      1.166710,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.905395,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.637698,
      NULL,
      NULL,
      NULL,
      0.655802,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.372692,
      1.876874,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      2.984299,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.668775,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      10.520111,
      0.115649,
      1.336691,
      NULL,
      1.765754,
      1.074042,
      NULL,
      NULL,
      1.281266,
      NULL,
      NULL,
      0.312885,
      NULL,
      NULL,
      1.957783,
      NULL,
      NULL,
      0.567398,
      NULL,
      NULL,
      24,
      1.031485,
      0,
      NULL,
      0,
      NULL,
      1,
      0.357916,
      NULL,
      0.299089,
      0,
      1,
      1.958014,
      NULL,
      0.665816,
      0,
      NULL,
      1.365018,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.553338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.886874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.159867,
      NULL,
      1.351058,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.629279,
      2,
      2.286752,
      NULL,
      0.146451,
      2.854736,
      1,
      NULL,
      NULL,
      3.216480,
      2,
      NULL,
      0,
      NULL,
      0.148782,
      0.977258,
      0.121297,
      NULL,
      NULL,
      1,
      0.258338,
      1,
      NULL,
      1.443471,
      0.940219,
      1,
      0,
      NULL,
      NULL,
      1.251152,
      0.869661,
      3.289577,
      2.437246,
      0.899694,
      2,
      2.752123,
      1,
      2,
      3.291133,
      0,
      0,
      0.575387,
      0,
      1,
      0,
      NULL,
      2.096284,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.694071,
      0.358459,
      0.228991,
      0,
      NULL,
      3.939369,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      6.782314,
      2,
      0.030579,
      3,
      '10232',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.626247,
      '',
      '',
      '');
commit;
end;
/


