set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9795808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4,
      5,
      NULL,
      2,
      3.272245,
      0,
      NULL,
      3.570713,
      '022',
      '41324043',
      28.191188,
      10.533446,
      '4322312',
      1.281688,
      NULL,
      1,
      2,
      '1130',
      0.356946,
      1,
      NULL,
      NULL,
      ' 7-18-1987',
      18,
      26.587810,
      NULL,
      3,
      0.734827,
      ' 7-27-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '11-23-1999',
      '10- 8-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      0.921532,
      0.175981,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.319594,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3,
      4.048812,
      1,
      1,
      0,
      0.034201,
      4.971043,
      9.570538,
      NULL,
      9.792274,
      1,
      2,
      5,
      NULL,
      7.899416,
      0.390937,
      NULL,
      3,
      1.887513,
      0.556616,
      1.747979,
      NULL,
      NULL,
      1.217797,
      NULL,
      NULL,
      1,
      NULL,
      4.371135,
      0.744589,
      0.663793,
      1.806656,
      NULL,
      0.772068,
      0,
      1.491260,
      0.592051,
      NULL,
      1,
      1.948754,
      0.648054,
      NULL,
      NULL,
      NULL,
      1.237935,
      0,
      1,
      0,
      0.505418,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265685,
      NULL,
      NULL,
      1,
      0,
      4.928083,
      NULL,
      1.017008,
      NULL,
      0,
      0,
      0.100475,
      1,
      0.592070,
      0.773156,
      0.931694,
      0.838609,
      0.906121,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.030208,
      3.739995,
      NULL,
      1.468837,
      4.860934,
      NULL,
      0.641411,
      1.582459,
      NULL,
      0.314928,
      NULL,
      5.187465,
      0.363757,
      NULL,
      4,
      9,
      8,
      1.122490,
      6.444275,
      1,
      1.897637,
      1.291323,
      4,
      2,
      2,
      NULL,
      ' 9-17-1976',
      109,
      NULL,
      NULL,
      0.796150,
      0,
      0.615350,
      1.339780,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.130702,
      1.075844,
      NULL,
      0.977113,
      NULL,
      3.103037,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      1.254144,
      2,
      0.730570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.090417,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.931401,
      1.593936,
      3.777281,
      1,
      3.177434,
      1.709135,
      NULL,
      NULL,
      NULL,
      0.289844,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.536719,
      1.181308,
      0.901853,
      1.940218,
      0.031505,
      1.228994,
      NULL,
      15,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.823412,
      NULL,
      0.261196,
      1,
      0,
      NULL,
      1.759701,
      2.540863,
      1.653559,
      1.878768,
      1.483791,
      0.779055,
      3,
      NULL,
      1.760510,
      1,
      1,
      1,
      1,
      0,
      0.315833,
      1,
      1.205565,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      8.719799,
      2,
      3.638056,
      NULL,
      0.550552,
      1.500651,
      1.920999,
      NULL,
      4,
      2,
      NULL,
      2,
      16.520829,
      NULL,
      NULL,
      NULL,
      NULL,
      24.838361,
      77.246923,
      2,
      1,
      0,
      NULL,
      '',
      '',
      0.717121,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      3.331985,
      41,
      4,
      3,
      NULL,
      9.004434,
      2.965690,
      NULL,
      0.239823,
      NULL,
      NULL,
      0.222018,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.014380,
      2.591859,
      NULL,
      0.829276,
      0.898792,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      2.241800,
      3.058862,
      1,
      NULL,
      2.098648,
      3,
      2.490246,
      2,
      2.633975,
      0.701694,
      2.404155,
      NULL,
      1,
      2.299959,
      1.710950,
      NULL,
      1,
      1.454604,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.442841,
      2.625126,
      2,
      0.949651,
      1,
      3.622894,
      NULL,
      0,
      1,
      1.956953,
      NULL,
      3,
      1,
      NULL,
      0,
      0,
      0,
      3.750479,
      3,
      1,
      0.388148,
      1.866444,
      0,
      NULL,
      NULL,
      NULL,
      0.561718,
      NULL,
      NULL,
      1,
      3.650266,
      1.726619,
      4,
      NULL,
      6.764614,
      0,
      0.301629,
      2.733046,
      1.523003,
      NULL,
      1.978111,
      NULL,
      NULL,
      NULL,
      1.500267,
      NULL,
      NULL,
      0.570420,
      NULL,
      NULL,
      2,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.013294,
      1.426049,
      1,
      NULL,
      1.945478,
      1.161820,
      1,
      NULL,
      NULL,
      0.014914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.593610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.457069,
      0,
      4,
      2,
      0,
      2,
      3.611967,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.269258,
      NULL,
      2,
      1,
      0,
      0.471146,
      NULL,
      0.997600,
      NULL,
      2,
      0.545091,
      0,
      1,
      3.379108,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.819987,
      0.990363,
      5.567049,
      2.912481,
      NULL,
      5,
      NULL,
      4,
      3.767782,
      NULL,
      1.908492,
      2,
      3.833461,
      2.166748,
      0.312227,
      1,
      2.017147,
      7.839145,
      NULL,
      1,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.572526,
      NULL,
      NULL,
      2.030694,
      NULL,
      1.628192,
      0,
      NULL,
      1.347566,
      NULL,
      NULL,
      3.177489,
      2.658082,
      NULL,
      2,
      2,
      NULL,
      1.451869,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      13.647480,
      NULL,
      0.908580,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      3.089840,
      1.900114,
      NULL,
      NULL,
      6.710501,
      NULL,
      NULL,
      NULL,
      70,
      NULL,
      NULL,
      NULL,
      3.176221,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431312,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.935033,
      NULL,
      NULL,
      NULL,
      0.142416,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      65.439274,
      36,
      NULL,
      45.651211,
      3,
      0,
      NULL,
      NULL,
      1,
      2,
      2.022107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.596201,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1.410067,
      0.674953,
      NULL,
      1,
      1,
      1.323858,
      1.959692,
      1,
      1.969547,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.747158,
      0.181018,
      1.260770,
      2.331798,
      1,
      NULL,
      5,
      1,
      2,
      1.564081,
      1,
      1,
      NULL,
      1.550923,
      1.562525,
      NULL,
      0.475937,
      0,
      NULL,
      1.291637,
      0.089851,
      NULL,
      1.026411,
      NULL,
      NULL,
      1,
      0.082207,
      NULL,
      0.516152,
      0.473785,
      NULL,
      0.678948,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.245056,
      NULL,
      0.579651,
      NULL,
      NULL,
      0.136555,
      0,
      1.687722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      4.283408,
      2.283022,
      1.712779,
      NULL,
      NULL,
      1.545601,
      86,
      1.913901,
      1,
      3,
      '32431',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


