set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9413327';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '2031141',
      NULL,
      1,
      2,
      NULL,
      '0311',
      NULL,
      0.858547,
      NULL,
      NULL,
      NULL,
      23.350340,
      NULL,
      3,
      1.550335,
      0,
      '10-18-1977',
      34,
      NULL,
      242,
      NULL,
      1.059636,
      ' 9-13-1993',
      ' 8- 8-1995',
      '11-26-1996',
      1,
      3.949358,
      1,
      0.861661,
      1.345842,
      1.244112,
      3,
      0.289306,
      1,
      22,
      3.755567,
      10.411214,
      NULL,
      NULL,
      23,
      7,
      6,
      NULL,
      3.814240,
      8,
      1.409654,
      NULL,
      1.240229,
      NULL,
      0,
      0,
      0.472539,
      1,
      1,
      112.313734,
      1.450660,
      NULL,
      10,
      11.836155,
      0,
      2.986511,
      1.719019,
      1,
      6.716965,
      NULL,
      NULL,
      4,
      NULL,
      5,
      0,
      1.572684,
      0,
      9.661528,
      0,
      NULL,
      3.008201,
      3.755863,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.328588,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384554,
      1,
      3.010541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.305069,
      0,
      1,
      7.458698,
      1,
      1,
      0.097203,
      NULL,
      NULL,
      NULL,
      3.779577,
      1.280718,
      NULL,
      0.365850,
      NULL,
      1.131465,
      NULL,
      0,
      0,
      3,
      0,
      0,
      NULL,
      5.166268,
      0.180684,
      0.983406,
      NULL,
      0.431735,
      NULL,
      NULL,
      NULL,
      1,
      3,
      5.655358,
      0,
      0,
      1.656358,
      NULL,
      7.934206,
      6,
      9,
      0,
      1,
      NULL,
      1.352560,
      ' 2-22-1979',
      106,
      ' 0-10-1998',
      3,
      1.998924,
      0,
      0,
      2.674376,
      1.143157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.890915,
      1.426596,
      1,
      3,
      1,
      1,
      NULL,
      1.976481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      106,
      2.398077,
      1.656291,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625947,
      1,
      6.059346,
      1,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.805923,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.174945,
      NULL,
      1,
      0,
      NULL,
      14.298160,
      2.160889,
      1,
      NULL,
      NULL,
      NULL,
      3.406200,
      0,
      NULL,
      3.459704,
      1,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1,
      NULL,
      3.995172,
      NULL,
      12.626482,
      2.812774,
      84,
      161,
      142,
      0,
      186,
      170,
      NULL,
      NULL,
      1.764164,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      11,
      0,
      7.198559,
      8.483735,
      2.831591,
      5.841255,
      3.525821,
      1.776378,
      5.289514,
      NULL,
      1,
      3.398396,
      0.600382,
      NULL,
      10,
      0,
      0,
      NULL,
      46,
      66,
      77.222804,
      2.651581,
      0,
      3.194284,
      '21434',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0.619819,
      '',
      '',
      '',
      1,
      NULL,
      12,
      30.649335,
      1.434826,
      27.777694,
      3.496161,
      NULL,
      1,
      3.366455,
      NULL,
      2,
      0.225812,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      1.416862,
      3.675763,
      1.812744,
      0,
      1.164572,
      NULL,
      NULL,
      1,
      3,
      0,
      1.997902,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1.097390,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.173261,
      NULL,
      NULL,
      3,
      1,
      3,
      0.723625,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416455,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.680809,
      NULL,
      NULL,
      0.398109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452870,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708385,
      NULL,
      NULL,
      1.257000,
      NULL,
      NULL,
      1.577737,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.352747,
      NULL,
      NULL,
      1.506713,
      3,
      4,
      1,
      NULL,
      NULL,
      0.745484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021909,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.905407,
      3.770969,
      1.818015,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.132664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.987726,
      2,
      3.351045,
      2,
      0.533407,
      0.480323,
      7.590771,
      5,
      3,
      2,
      3,
      NULL,
      1,
      1.944032,
      2.613073,
      1.369964,
      2,
      NULL,
      0.352134,
      1,
      0.027359,
      9.713247,
      8,
      9.586404,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1.359602,
      0,
      NULL,
      1.870725,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.727933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.880427,
      NULL,
      NULL,
      0.122295,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.920920,
      1.706590,
      NULL,
      1.567769,
      3.434417,
      0.194721,
      NULL,
      NULL,
      5.397248,
      2.984563,
      NULL,
      NULL,
      3.037997,
      24,
      NULL,
      NULL,
      3.300902,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.693930,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.007847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256926,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.418808,
      3.871180,
      NULL,
      NULL,
      NULL,
      3.159796,
      NULL,
      NULL,
      0.764200,
      0.104523,
      NULL,
      NULL,
      0.135754,
      NULL,
      NULL,
      NULL,
      1.467202,
      2,
      NULL,
      NULL,
      2.979716,
      NULL,
      NULL,
      NULL,
      2,
      1.836863,
      2.439131,
      2.905321,
      NULL,
      NULL,
      7.457984,
      0,
      3,
      NULL,
      0.874026,
      NULL,
      NULL,
      0.971704,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      1,
      3,
      0.189131,
      0.734288,
      0,
      0,
      NULL,
      0.009890,
      0,
      0,
      1.175456,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.811588,
      NULL,
      3,
      NULL,
      3.991182,
      NULL,
      94,
      NULL,
      0.569592,
      NULL,
      NULL,
      0.226906,
      NULL,
      2.093152,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.849132,
      NULL,
      1.242189,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.389931,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.419379,
      NULL,
      1.238382,
      NULL,
      NULL,
      0.185647,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.294776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.986831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      1.836021,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1.820638,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.401865,
      0.803805,
      4,
      0,
      3,
      1.320212,
      NULL,
      4.662110,
      2.117719,
      3,
      3.662536,
      0,
      1.652161,
      0,
      NULL,
      NULL,
      2.975445,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1.837003,
      NULL,
      0.945017,
      1,
      2,
      3,
      NULL,
      0.648075,
      1.266983,
      1.465474,
      0,
      NULL,
      0.180553,
      1,
      0.119893,
      NULL,
      3,
      3,
      0,
      NULL,
      1,
      0.346368,
      0,
      0.409477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.777524,
      1,
      NULL,
      NULL,
      1,
      NULL,
      4.141325,
      0.822973,
      0,
      NULL,
      NULL,
      59,
      57,
      2,
      3,
      1,
      NULL,
      NULL,
      '',
      1.316409,
      NULL,
      '',
      '',
      1.276012,
      '',
      '',
      '');
commit;
end;
/


