set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      3.825329,
      1,
      6,
      2,
      '2222',
      NULL,
      0.543468,
      NULL,
      NULL,
      ' 8- 9-1978',
      NULL,
      NULL,
      4,
      1.702999,
      0.296747,
      ' 2- 3-1984',
      NULL,
      4,
      248.549621,
      95.759579,
      1.816594,
      NULL,
      '10-19-1975',
      NULL,
      3.333973,
      3,
      1,
      3,
      NULL,
      NULL,
      0,
      3.752585,
      NULL,
      NULL,
      NULL,
      NULL,
      7.867007,
      NULL,
      1,
      4,
      18,
      5,
      NULL,
      4.792943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082417,
      NULL,
      1.130449,
      0.042661,
      2.159973,
      NULL,
      NULL,
      NULL,
      1.651188,
      1,
      5.533697,
      NULL,
      3.998545,
      1.826784,
      NULL,
      0,
      5.711522,
      1.471153,
      1,
      0.185726,
      0,
      1,
      NULL,
      NULL,
      0.083601,
      NULL,
      NULL,
      7.622103,
      0,
      0,
      1.277080,
      NULL,
      0,
      0,
      0,
      NULL,
      2.011784,
      1.808039,
      NULL,
      2,
      0.943174,
      NULL,
      1.286262,
      0,
      1,
      0,
      1.989303,
      1,
      NULL,
      2.964381,
      0,
      2.238792,
      0,
      1,
      NULL,
      NULL,
      0.321901,
      NULL,
      NULL,
      0,
      0.640438,
      NULL,
      0,
      1,
      NULL,
      0.858112,
      1,
      0,
      1.730215,
      1.161123,
      NULL,
      NULL,
      1.069649,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1.243431,
      1.256350,
      1,
      0.310077,
      0,
      NULL,
      3.789863,
      NULL,
      1.482388,
      1,
      NULL,
      NULL,
      0,
      1.406966,
      NULL,
      4.221948,
      0,
      NULL,
      7.964512,
      2.661579,
      4.525133,
      2,
      0,
      NULL,
      5,
      3,
      ' 0-24-2003',
      166,
      ' 1-29-1980',
      5.543092,
      3,
      0,
      0,
      NULL,
      1.358911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.502564,
      NULL,
      0,
      0.871639,
      1.120733,
      0.742658,
      0.140934,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.281514,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      2,
      NULL,
      NULL,
      1,
      0,
      6.711654,
      2,
      0.195878,
      3,
      NULL,
      0.916148,
      0,
      2,
      1,
      0,
      0.863337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.963202,
      1.748914,
      1.109737,
      0.482366,
      0,
      1.520605,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.033568,
      1,
      NULL,
      2.152240,
      1.066867,
      1.140888,
      2,
      3.317279,
      1.574202,
      1,
      0,
      2.820125,
      17,
      0,
      0.955932,
      1.477892,
      0,
      1.731646,
      1.456747,
      1,
      1,
      1.816808,
      0,
      1.342402,
      1,
      1.624491,
      1.607772,
      4,
      NULL,
      2,
      NULL,
      7,
      NULL,
      8,
      NULL,
      5,
      0,
      1,
      1.458504,
      1.462266,
      1.927434,
      28,
      0.972014,
      2.492071,
      NULL,
      33.429700,
      35.439560,
      37.557140,
      0.690012,
      4,
      0.612970,
      '13341',
      '',
      NULL,
      0.504558,
      '',
      '',
      NULL,
      0.491328,
      '',
      '',
      '',
      0,
      40,
      3.660198,
      NULL,
      1,
      36.979163,
      NULL,
      1,
      0.038048,
      NULL,
      2,
      2.585716,
      1.992233,
      NULL,
      NULL,
      3,
      NULL,
      0.401580,
      1.077338,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810400,
      NULL,
      NULL,
      0,
      9.841205,
      1.363298,
      0.555501,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.987502,
      0,
      1.750118,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      1.185431,
      1,
      0.727086,
      1,
      0.275498,
      0.843156,
      0.959675,
      3.455306,
      0.358407,
      1.047858,
      3.950776,
      1,
      NULL,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.692006,
      NULL,
      NULL,
      5.986410,
      4,
      5.771453,
      NULL,
      0.800516,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.841844,
      NULL,
      NULL,
      0,
      2,
      1,
      1.329169,
      NULL,
      NULL,
      NULL,
      2.750299,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.491912,
      NULL,
      NULL,
      1.832147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248485,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.918853,
      NULL,
      NULL,
      1.278401,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.271874,
      1,
      2.286727,
      1.441291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065587,
      NULL,
      0.224978,
      3.473560,
      1,
      NULL,
      0.856010,
      NULL,
      5.542826,
      2,
      3,
      3.165434,
      1.439254,
      3.041707,
      2,
      0.415359,
      NULL,
      3.480388,
      3,
      1,
      2.865273,
      NULL,
      8,
      0,
      0,
      1,
      3,
      2,
      2,
      2,
      1,
      0.380533,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.118733,
      NULL,
      NULL,
      0.938661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.831284,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.973158,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.553870,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007062,
      NULL,
      NULL,
      1.689134,
      NULL,
      NULL,
      0.367524,
      NULL,
      NULL,
      0.554931,
      NULL,
      NULL,
      NULL,
      1.133256,
      0.237968,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.256887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.227220,
      NULL,
      NULL,
      NULL,
      0.870667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.917591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.856525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.889681,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.328135,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      4.840117,
      1,
      19,
      0,
      1.844354,
      NULL,
      NULL,
      1.690726,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.312501,
      NULL,
      1.368795,
      0.876097,
      4.883132,
      NULL,
      NULL,
      1.355609,
      1.526078,
      1.865392,
      1.841281,
      0.290786,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.629207,
      1.500822,
      1,
      1.551013,
      1.322357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101426,
      1.537491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.267361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.461742,
      NULL,
      1,
      NULL,
      1.001713,
      NULL,
      NULL,
      NULL,
      1,
      2.122670,
      3,
      NULL,
      0.460299,
      0.294900,
      1.859329,
      NULL,
      NULL,
      0.235385,
      0.448263,
      0,
      1.551048,
      0.629446,
      NULL,
      0,
      1.839048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      10.430342,
      0,
      2,
      3,
      0.785566,
      1.819817,
      1.145224,
      3.597100,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.826134,
      NULL,
      1,
      1,
      NULL,
      1.364833,
      3,
      NULL,
      1.655001,
      1.302548,
      NULL,
      0.193664,
      3,
      NULL,
      2,
      1,
      NULL,
      1,
      1.616815,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.988535,
      NULL,
      0.579164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223498,
      NULL,
      1,
      NULL,
      1.005985,
      NULL,
      2.486561,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.699459,
      1,
      3.048434,
      '14014',
      '',
      '',
      1.653764,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


