set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '1444004',
      0.942871,
      NULL,
      0,
      1,
      '2242',
      NULL,
      1.979264,
      NULL,
      NULL,
      ' 6-13-1990',
      25.632806,
      NULL,
      2,
      NULL,
      3.983551,
      NULL,
      26,
      3,
      NULL,
      20,
      2.501742,
      '10- 6-1992',
      ' 8-29-1982',
      NULL,
      0.493897,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.570472,
      1.100467,
      NULL,
      NULL,
      13.544959,
      0,
      18,
      19,
      7.081160,
      10.250847,
      NULL,
      5.764695,
      7.942437,
      0,
      2.444699,
      1.646038,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.980535,
      0,
      1.637084,
      5.671860,
      3.323796,
      3,
      1,
      2,
      1,
      3,
      1,
      1.867037,
      7,
      1,
      NULL,
      0.358385,
      0,
      0,
      4.975407,
      3.113751,
      1,
      1,
      1,
      0.104604,
      NULL,
      NULL,
      1.257353,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.141863,
      7.636783,
      NULL,
      4.760879,
      NULL,
      2.723637,
      0.349605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853798,
      2,
      5,
      NULL,
      NULL,
      1.078403,
      1,
      0,
      1,
      NULL,
      2,
      0,
      1,
      0.887897,
      NULL,
      0.019514,
      NULL,
      1.214204,
      0.774439,
      NULL,
      0.013806,
      0.878775,
      1.111965,
      NULL,
      1,
      1,
      3,
      2,
      NULL,
      2,
      0.936713,
      1.550220,
      NULL,
      2.480631,
      1.943402,
      2,
      1.319638,
      NULL,
      3.979587,
      7.766725,
      1.311878,
      4,
      2,
      3.693103,
      1.130772,
      9.923921,
      3,
      3,
      ' 7-20-1976',
      0.811485,
      ' 1- 6-2001',
      25,
      3,
      NULL,
      1,
      3.059265,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.182880,
      1.590574,
      0,
      1.744373,
      1.975178,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.708153,
      NULL,
      16.636120,
      2,
      0,
      4.883051,
      1.968282,
      1.425879,
      1,
      1.355474,
      NULL,
      10.047066,
      3.642134,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      6,
      6,
      0,
      3.738638,
      1.823232,
      1,
      3,
      2.154031,
      1,
      4,
      NULL,
      6,
      NULL,
      0,
      ' 1-18-1979',
      23,
      NULL,
      1,
      NULL,
      2.523841,
      NULL,
      0.700689,
      2.098871,
      1,
      1,
      1.554486,
      0,
      47.760302,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.706177,
      0,
      0,
      1,
      1,
      0.346117,
      2,
      2,
      2.306765,
      4.602995,
      1.748063,
      2,
      NULL,
      2.339091,
      2,
      1.687495,
      2.356493,
      0.706245,
      1.304292,
      0,
      1.953788,
      1.995739,
      189,
      29,
      120,
      0.729832,
      NULL,
      NULL,
      3.110227,
      3.459438,
      NULL,
      NULL,
      0,
      0,
      4.124552,
      NULL,
      5,
      NULL,
      1.839073,
      2,
      3,
      NULL,
      0.849239,
      2.014999,
      NULL,
      NULL,
      0.483653,
      NULL,
      1,
      6.934574,
      74.849000,
      NULL,
      1.577791,
      NULL,
      '43444',
      '32102',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858046,
      4,
      2.412739,
      1.352125,
      0.268273,
      1,
      1,
      NULL,
      NULL,
      3,
      0.974625,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      231,
      NULL,
      1,
      0,
      1,
      1,
      0.844375,
      1,
      NULL,
      3.362553,
      NULL,
      1.132037,
      NULL,
      1.525146,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.100307,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.272501,
      NULL,
      1.244126,
      NULL,
      24.976551,
      NULL,
      NULL,
      13,
      11,
      0.091635,
      0.292965,
      NULL,
      NULL,
      1.934783,
      NULL,
      1.936796,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.643108,
      NULL,
      1,
      NULL,
      0.715753,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.393122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      1.597170,
      2,
      NULL,
      3.311284,
      3,
      NULL,
      NULL,
      2.280413,
      0,
      NULL,
      1,
      1.771730,
      NULL,
      0.284630,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1.793931,
      NULL,
      1.775612,
      1,
      NULL,
      1,
      1,
      NULL,
      0.428495,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.009641,
      NULL,
      1,
      0,
      NULL,
      1,
      1.903468,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      36,
      109,
      0,
      0.464884,
      3,
      '24441',
      '20320',
      '',
      1.193192,
      '',
      NULL,
      '',
      0.529728,
      '0001',
      '',
      '');
commit;
end;
/


