set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '3303223',
      NULL,
      1,
      6,
      0,
      '2401',
      NULL,
      1.296808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      14,
      NULL,
      50,
      0.860651,
      107,
      4,
      NULL,
      ' 4- 1-1994',
      ' 8-29-1979',
      ' 1- 5-1997',
      3,
      1,
      3.478011,
      0,
      0.687934,
      1,
      NULL,
      0.557405,
      0.046525,
      NULL,
      NULL,
      10,
      0.452796,
      89,
      59,
      NULL,
      6.962784,
      0.578733,
      2,
      6,
      NULL,
      0.682950,
      2.088709,
      NULL,
      NULL,
      0.147774,
      1.339237,
      0,
      0.021254,
      1.255059,
      0.218863,
      3.207173,
      2.335815,
      3,
      0,
      2.048253,
      3.712092,
      1,
      4,
      1,
      3.377999,
      5,
      0.760017,
      2.847682,
      0,
      NULL,
      0.127600,
      1.550917,
      NULL,
      NULL,
      4,
      1.783559,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      3.272850,
      0,
      1,
      1.874796,
      0,
      0.758100,
      1.286926,
      0.383554,
      2.500799,
      1.978773,
      0,
      0.791361,
      1,
      3,
      1.731964,
      0.918970,
      1,
      0,
      1.360248,
      1,
      2,
      3,
      0.295599,
      0,
      5.219080,
      1,
      NULL,
      NULL,
      1.854519,
      0.928092,
      1,
      0.158074,
      3,
      1,
      1,
      4.362961,
      0.611993,
      0.437737,
      NULL,
      1.368514,
      0,
      1.383636,
      NULL,
      1.089636,
      0.619408,
      0.911011,
      1,
      1.209321,
      0,
      0.169055,
      NULL,
      NULL,
      1,
      0.096803,
      1,
      8.898363,
      3,
      8.002997,
      6.746234,
      0.312031,
      1,
      3.096260,
      NULL,
      NULL,
      0.499080,
      1,
      7.326572,
      9.921456,
      5,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      7.939698,
      3.506573,
      NULL,
      0,
      ' 1-26-1993',
      511.480031,
      ' 7-19-1987',
      4.719652,
      0,
      0,
      3,
      4,
      3.338138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      4.618797,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.065920,
      2,
      0,
      8,
      NULL,
      1.645911,
      NULL,
      1.511955,
      7,
      5,
      NULL,
      0.561393,
      NULL,
      NULL,
      NULL,
      NULL,
      4.303617,
      2,
      8.778714,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      4,
      2.142586,
      0,
      2,
      3,
      9.167453,
      ' 8-18-1983',
      0,
      ' 0- 4-1980',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0.077212,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      3,
      3,
      1.132299,
      2.448597,
      NULL,
      3.241213,
      3,
      1.121661,
      3.980794,
      1,
      NULL,
      NULL,
      5,
      0,
      1,
      0.038426,
      0,
      1.548467,
      5,
      0.110700,
      1,
      NULL,
      1.166480,
      2.308280,
      0,
      4.672955,
      8,
      6,
      3.113252,
      7.927567,
      7,
      2.595502,
      2,
      1.076751,
      3,
      0.098145,
      3,
      43,
      2,
      0.880549,
      NULL,
      NULL,
      20.349578,
      60,
      6,
      NULL,
      5,
      '24022',
      '01133',
      '',
      0.174136,
      '03114',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      NULL,
      61.364713,
      51,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.145168,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.336981,
      0.042026,
      NULL,
      3.860893,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.509344,
      NULL,
      1.512876,
      0.088795,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.864533,
      NULL,
      NULL,
      NULL,
      4,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.373526,
      0.729240,
      3,
      3.125807,
      NULL,
      1,
      3.618479,
      0.247975,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.398071,
      2,
      1.528421,
      1.031310,
      0,
      1.605262,
      0,
      0.642044,
      1.192819,
      1,
      NULL,
      0,
      NULL,
      1.906546,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.755831,
      NULL,
      3.952644,
      0.985359,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.183855,
      1.796050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.220211,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.558476,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.009349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.380369,
      NULL,
      NULL,
      NULL,
      5.731137,
      5.591654,
      5,
      2.133547,
      0.947580,
      1,
      NULL,
      NULL,
      1,
      0,
      0.011581,
      0.423354,
      NULL,
      2,
      2.158237,
      3.709015,
      3.331134,
      NULL,
      NULL,
      NULL,
      0.081754,
      1.753345,
      1.659259,
      2.205081,
      0.655884,
      2.184210,
      0.050980,
      3,
      0.887316,
      1.259193,
      NULL,
      NULL,
      1,
      3,
      9,
      0.450051,
      NULL,
      0.593006,
      NULL,
      5,
      0.235503,
      1.189832,
      1,
      NULL,
      1.777863,
      1.763660,
      1.348088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.054569,
      NULL,
      0.654543,
      2.130619,
      0.982783,
      0,
      0.532016,
      1,
      NULL,
      NULL,
      NULL,
      1.244301,
      NULL,
      NULL,
      NULL,
      2.484493,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.732723,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.713235,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.496271,
      NULL,
      NULL,
      NULL,
      1.215131,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.293821,
      NULL,
      NULL,
      NULL,
      1.951728,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      1719.948735,
      1.906411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.867180,
      NULL,
      0,
      NULL,
      NULL,
      0.117696,
      1,
      1,
      NULL,
      1,
      0,
      1.419416,
      0,
      NULL,
      0,
      NULL,
      0.248744,
      1,
      NULL,
      1.202461,
      NULL,
      0.498289,
      NULL,
      0.329597,
      NULL,
      NULL,
      NULL,
      0.716686,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221904,
      1,
      1.017149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611459,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.006763,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.474681,
      NULL,
      1,
      NULL,
      1.411449,
      0.257186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.772391,
      NULL,
      0.199718,
      NULL,
      1.371139,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.624134,
      7,
      7.712420,
      NULL,
      2.418369,
      3,
      1.575759,
      2,
      NULL,
      1,
      1,
      NULL,
      3.258029,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.420522,
      NULL,
      NULL,
      0.250067,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026932,
      NULL,
      NULL,
      0.172821,
      NULL,
      NULL,
      3.633187,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.829336,
      2,
      NULL,
      1,
      NULL,
      3.302215,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.763963,
      NULL,
      0.019519,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614192,
      NULL,
      156.523248,
      1,
      NULL,
      0.944227,
      NULL,
      2,
      NULL,
      0.640844,
      NULL,
      2,
      0.273643,
      5.224976,
      2.674140,
      3.412168,
      1,
      95,
      2.272309,
      6,
      0.239722,
      NULL,
      '44200',
      '23224',
      '',
      3,
      '04404',
      '',
      '',
      0.232731,
      '',
      '',
      '');
commit;
end;
/


