set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '1302141',
      0,
      1.933337,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      ' 6- 0-1993',
      54.195811,
      NULL,
      3,
      2.079308,
      0,
      NULL,
      36,
      0.791587,
      6.968167,
      2.926862,
      3.610447,
      ' 9-17-1974',
      ' 0- 5-1974',
      '10- 1-2000',
      NULL,
      NULL,
      1.183163,
      0,
      0.641299,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      6.995073,
      NULL,
      3,
      8,
      8,
      NULL,
      0.561188,
      3,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      2.127316,
      7,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0.835111,
      0.236870,
      1,
      1.704074,
      1.952734,
      4,
      2.012314,
      0.688724,
      0.867325,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      7.280889,
      0.508418,
      2,
      NULL,
      3,
      3.999852,
      2.797587,
      NULL,
      0,
      1.445587,
      1.171232,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.576850,
      NULL,
      0,
      2.359137,
      1.315790,
      1.270839,
      0,
      1,
      1.009440,
      NULL,
      NULL,
      0.426242,
      NULL,
      NULL,
      NULL,
      3.465572,
      2.904898,
      2.080816,
      1,
      2.606940,
      0,
      0.848322,
      NULL,
      0.310199,
      NULL,
      3.898998,
      1.017166,
      4.770179,
      0,
      0.673055,
      1.507104,
      0,
      5,
      NULL,
      5,
      6.506440,
      2.305604,
      NULL,
      NULL,
      0,
      0.042302,
      8,
      0,
      4,
      1.850151,
      1.077373,
      1,
      3,
      0.433238,
      4,
      NULL,
      3.354479,
      5.296032,
      NULL,
      2,
      2.557240,
      0,
      6.808843,
      4,
      3.336692,
      1,
      1,
      '11-11-1983',
      34.595688,
      '10-28-1985',
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389299,
      1,
      NULL,
      NULL,
      0.718407,
      0,
      NULL,
      0.089155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.080187,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.257411,
      3,
      2.148298,
      1.730313,
      NULL,
      1.867066,
      NULL,
      0,
      1.954788,
      0.066175,
      NULL,
      0.988643,
      NULL,
      NULL,
      NULL,
      1,
      7,
      1.130159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000606,
      0,
      0.686374,
      1.396215,
      1,
      1,
      NULL,
      1.767251,
      48.832930,
      NULL,
      0.827667,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329639,
      0.497202,
      2.572984,
      0.827854,
      1.381532,
      2.861291,
      1.662499,
      2,
      1.386242,
      2.987083,
      0,
      1,
      2.854607,
      NULL,
      0.404680,
      NULL,
      NULL,
      0.749693,
      2.335211,
      0.547107,
      0.174112,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0.740400,
      4,
      0.720824,
      3.043887,
      NULL,
      4,
      0,
      4.870146,
      NULL,
      0.314382,
      2.244618,
      7.124258,
      0.309919,
      2.652849,
      0.662719,
      62,
      0,
      NULL,
      NULL,
      35,
      7,
      75.214591,
      5,
      3.027974,
      NULL,
      '21200',
      '14203',
      '',
      1.686358,
      '',
      '',
      '',
      1.714285,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601422,
      3.711941,
      2,
      1.295910,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509568,
      NULL,
      NULL,
      1,
      NULL,
      1,
      145,
      2.932922,
      1,
      1.350104,
      1,
      0,
      0,
      0.072596,
      1.666043,
      NULL,
      NULL,
      0,
      1,
      1.644690,
      NULL,
      0,
      NULL,
      0,
      0.486897,
      NULL,
      NULL,
      1,
      NULL,
      1.628187,
      NULL,
      1.858289,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.312899,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.424085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419963,
      0,
      NULL,
      3,
      NULL,
      188.873187,
      NULL,
      0,
      NULL,
      1.376426,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.023948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.949232,
      NULL,
      1,
      NULL,
      1.311648,
      1.563282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.568695,
      2.424395,
      1,
      0,
      3.673987,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.954017,
      0.601686,
      1.268816,
      0,
      NULL,
      1.035448,
      3.408425,
      NULL,
      NULL,
      3.284664,
      NULL,
      0,
      1,
      NULL,
      0.831180,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.758157,
      NULL,
      0.571207,
      0.398488,
      NULL,
      1,
      0.673028,
      NULL,
      NULL,
      1.260135,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.750889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052372,
      NULL,
      0.514379,
      NULL,
      0.026253,
      5.453546,
      4,
      1.277573,
      NULL,
      NULL,
      116.777742,
      95,
      2.066013,
      3,
      3,
      NULL,
      NULL,
      '',
      0.704239,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


