set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9024643';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '0342',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 2-1995',
      NULL,
      NULL,
      1,
      0.679841,
      0,
      '11-14-1979',
      27.798256,
      3.603902,
      176.729572,
      NULL,
      2.253413,
      '10-18-1993',
      '11-11-1994',
      NULL,
      3.131560,
      NULL,
      1.824340,
      3.820422,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      20.235853,
      17,
      0.685093,
      8.345152,
      4,
      0.863243,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.215465,
      1,
      NULL,
      1.830160,
      0.536674,
      0.185851,
      NULL,
      2.922505,
      5,
      1.796762,
      NULL,
      1.832443,
      1,
      0,
      1.882199,
      1,
      1.905766,
      0,
      NULL,
      1,
      NULL,
      0,
      1.389738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.472358,
      2,
      0.558200,
      NULL,
      1,
      3,
      1,
      NULL,
      0.846165,
      1,
      1,
      1.621231,
      1,
      3.211504,
      0,
      0,
      NULL,
      0.790587,
      1,
      1,
      6.381954,
      1,
      2,
      3,
      0.259364,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.424867,
      NULL,
      5.870699,
      0.146379,
      1.628285,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.190045,
      1,
      1.457057,
      NULL,
      1,
      1,
      0.607213,
      0,
      NULL,
      NULL,
      NULL,
      0.897552,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      3,
      1.680154,
      1,
      1.245486,
      1.683271,
      5.436100,
      3,
      4,
      NULL,
      8,
      0.422876,
      NULL,
      0.785583,
      NULL,
      3.304176,
      1,
      3,
      2.488651,
      ' 7- 3-1996',
      109.394507,
      ' 7-20-1987',
      162.672959,
      3,
      1,
      2.425691,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750957,
      1,
      1,
      0.225649,
      NULL,
      3.454987,
      1.059037,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.722726,
      0.284073,
      1.314390,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.995293,
      1,
      1.074772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.554909,
      1.668256,
      0,
      1.767842,
      1,
      NULL,
      NULL,
      3.554228,
      1.674760,
      NULL,
      NULL,
      NULL,
      4.122418,
      0.504218,
      NULL,
      0,
      1,
      3.730144,
      4,
      1.160219,
      2,
      6,
      NULL,
      0.202613,
      3,
      4,
      2,
      NULL,
      3.724508,
      NULL,
      0,
      NULL,
      NULL,
      1.641431,
      1.017877,
      1.540779,
      0.490328,
      1.863312,
      0,
      0.461431,
      NULL,
      0.117145,
      NULL,
      NULL,
      6.123354,
      NULL,
      3.467803,
      10.464824,
      11.951124,
      4.301529,
      0,
      3.613177,
      2,
      2.129800,
      3.634309,
      0,
      22,
      3.102826,
      2.115414,
      NULL,
      82.232414,
      79.503810,
      NULL,
      NULL,
      1.488453,
      0,
      '03124',
      '',
      '',
      2.099619,
      '02341',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2,
      NULL,
      NULL,
      11,
      1,
      NULL,
      2,
      2.661213,
      5,
      1,
      NULL,
      NULL,
      0.241248,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716716,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.185398,
      0,
      NULL,
      1.286796,
      0,
      NULL,
      NULL,
      NULL,
      1.555823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.158926,
      NULL,
      NULL,
      NULL,
      NULL,
      3.669999,
      1,
      0.374292,
      0.821045,
      0,
      3,
      1.703265,
      NULL,
      0.898214,
      0.761626,
      0.647747,
      3,
      1,
      2,
      NULL,
      1.166368,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814584,
      NULL,
      NULL,
      NULL,
      5.658312,
      2.189523,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.571451,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.315826,
      NULL,
      NULL,
      3,
      0,
      1.275602,
      NULL,
      NULL,
      3,
      NULL,
      4,
      1.582975,
      NULL,
      NULL,
      0.950451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969545,
      NULL,
      NULL,
      0.556168,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.531262,
      NULL,
      NULL,
      1.727357,
      NULL,
      1.831433,
      5,
      6,
      1.412826,
      2,
      0.716338,
      NULL,
      1.489584,
      NULL,
      NULL,
      4,
      3,
      0.469171,
      NULL,
      5,
      4.843885,
      3.601289,
      2,
      3.593569,
      3,
      2.122867,
      0,
      3.356350,
      0.505414,
      NULL,
      3.441353,
      3.969003,
      1,
      NULL,
      3.468389,
      2,
      1,
      1.573205,
      3,
      1,
      NULL,
      NULL,
      3.869356,
      3,
      NULL,
      3.716347,
      NULL,
      NULL,
      7.096526,
      5.751283,
      3.216077,
      4.830160,
      1.556595,
      4.454306,
      NULL,
      2,
      2.550479,
      NULL,
      0,
      1,
      1,
      1,
      1.599116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.251968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899704,
      0.134882,
      0,
      0.542421,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726784,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.327265,
      NULL,
      NULL,
      NULL,
      3.611110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.951072,
      NULL,
      NULL,
      NULL,
      1.331675,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      14.564169,
      NULL,
      0,
      NULL,
      NULL,
      1.797499,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.343889,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.002741,
      NULL,
      0.546668,
      31,
      0,
      0.888886,
      NULL,
      0,
      NULL,
      0,
      0.027057,
      0.156217,
      NULL,
      1,
      1.240443,
      NULL,
      1,
      1,
      NULL,
      1.577171,
      0,
      0.765509,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.084089,
      0,
      2,
      4,
      1.576774,
      0,
      NULL,
      NULL,
      NULL,
      1.276750,
      NULL,
      0.405905,
      1.194862,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.683794,
      NULL,
      1,
      1.380795,
      NULL,
      NULL,
      1,
      NULL,
      0.437164,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.991935,
      0,
      NULL,
      0,
      1.135377,
      NULL,
      1,
      3.812916,
      NULL,
      1,
      1.479926,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.271611,
      NULL,
      3,
      NULL,
      0.449495,
      NULL,
      0.555538,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.275526,
      NULL,
      11.371028,
      0.385608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726341,
      NULL,
      4,
      9.153028,
      3,
      NULL,
      1.651698,
      2.083777,
      NULL,
      45.709397,
      0.973939,
      1.070547,
      NULL,
      '44343',
      NULL,
      '',
      2.594207,
      '43024',
      '',
      '',
      1,
      '4214',
      '',
      NULL);
commit;
end;
/


