set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416498';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '3311101',
      3.099133,
      0.820861,
      2,
      0,
      '2343',
      3.777939,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      NULL,
      3,
      3.028260,
      3.738454,
      ' 0-23-1981',
      NULL,
      2.763374,
      163,
      40,
      3.557781,
      ' 3- 6-2002',
      '11-26-2003',
      ' 4- 6-1987',
      0,
      0,
      2,
      2,
      0.541091,
      3,
      3.232043,
      1.907119,
      0,
      NULL,
      0.043740,
      15.527831,
      5.565392,
      2.256880,
      NULL,
      1.666163,
      6.119407,
      NULL,
      3,
      NULL,
      2.892303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      0.259161,
      1.101894,
      0,
      1,
      0,
      1.243818,
      0.189060,
      0.781633,
      0,
      0.461033,
      1.910068,
      0.986070,
      3.349971,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.986277,
      NULL,
      NULL,
      1.494492,
      0.200257,
      0.503410,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100054,
      1.640432,
      0.550981,
      3,
      1,
      NULL,
      1.573029,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.741420,
      1,
      NULL,
      0,
      1,
      1.547730,
      0,
      1.863841,
      NULL,
      4.329473,
      1.333341,
      1.874587,
      NULL,
      0.874493,
      0.850453,
      0,
      NULL,
      1.682864,
      0,
      NULL,
      1,
      0.207558,
      NULL,
      1.928951,
      1.881563,
      0,
      NULL,
      1,
      0.100850,
      2.659527,
      2.611652,
      3.009721,
      NULL,
      0,
      0,
      NULL,
      5.565701,
      NULL,
      5.946358,
      NULL,
      2.474496,
      4,
      2.679853,
      6,
      NULL,
      1,
      0.515155,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441377,
      1.815516,
      0,
      0.343909,
      0.576216,
      0.712908,
      1.191920,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836280,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.118493,
      NULL,
      1.597563,
      NULL,
      NULL,
      NULL,
      0,
      2.123754,
      3,
      2.130844,
      3.958597,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.432081,
      NULL,
      0.745085,
      NULL,
      0.430075,
      3,
      14.297041,
      1,
      1.244987,
      NULL,
      NULL,
      NULL,
      2,
      0.433878,
      NULL,
      0,
      NULL,
      1.570816,
      3,
      NULL,
      1.753911,
      0.725294,
      0,
      0,
      1,
      0.638353,
      2,
      2,
      9.186122,
      NULL,
      0.523529,
      2.291864,
      NULL,
      NULL,
      0.495961,
      1.730902,
      NULL,
      0.747836,
      0,
      1,
      1.748328,
      0.971453,
      4,
      NULL,
      8.485381,
      NULL,
      NULL,
      4.074763,
      NULL,
      1,
      5.794183,
      NULL,
      6.287818,
      0,
      NULL,
      NULL,
      52.243843,
      NULL,
      1,
      NULL,
      50,
      15,
      22.390678,
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      1.918960,
      '',
      NULL,
      '',
      0.115780,
      NULL,
      '',
      '',
      3,
      38.360016,
      NULL,
      43,
      3.520792,
      41,
      2.061676,
      3,
      3,
      1,
      3.793534,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.296392,
      0.428831,
      1.200666,
      0,
      NULL,
      NULL,
      1.051431,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.642713,
      2.475781,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716361,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.263770,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.064105,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.949872,
      NULL,
      NULL,
      1.575754,
      NULL,
      NULL,
      1.131365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424618,
      NULL,
      NULL,
      0,
      3,
      1.058822,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4.135500,
      2,
      0,
      1.846722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2.752424,
      1,
      2,
      1.993089,
      3.452796,
      5.749301,
      2,
      3,
      0.297250,
      3.990418,
      3,
      2.634428,
      0.904469,
      1.087540,
      0,
      NULL,
      NULL,
      2.833163,
      1.737075,
      1.992509,
      1.710756,
      5.303469,
      NULL,
      NULL,
      NULL,
      0,
      5.672275,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403246,
      3.047093,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.781055,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1.527535,
      1.149652,
      0,
      0.235389,
      0.692557,
      2.496095,
      NULL,
      NULL,
      0.686517,
      3.556164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019068,
      NULL,
      NULL,
      NULL,
      1.486155,
      1.630869,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.727243,
      0,
      NULL,
      NULL,
      2,
      1.047544,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4,
      3.517901,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      172,
      0,
      NULL,
      NULL,
      1,
      1,
      0.705431,
      0.349852,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      0.905108,
      0,
      1,
      1.623122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      3.630857,
      1.298146,
      1,
      NULL,
      5,
      NULL,
      3,
      2,
      NULL,
      1,
      NULL,
      1.793330,
      0,
      1,
      NULL,
      NULL,
      1.495356,
      3,
      NULL,
      NULL,
      0.987906,
      1,
      0.907662,
      3,
      0,
      1.424572,
      3.585700,
      NULL,
      0.697273,
      3,
      0.672171,
      1,
      3,
      0,
      1.535470,
      NULL,
      NULL,
      3.000384,
      3.027900,
      0,
      2,
      3,
      0,
      0,
      1.943226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093450,
      1.797439,
      1,
      0,
      1,
      1.706110,
      2.013865,
      2.053573,
      1.997391,
      NULL,
      NULL,
      NULL,
      68,
      NULL,
      4,
      5,
      NULL,
      NULL,
      '',
      NULL,
      0.964503,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


