set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8426905';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      3.564744,
      1,
      NULL,
      2,
      '4224',
      3,
      0.911326,
      NULL,
      NULL,
      ' 8-29-2001',
      NULL,
      NULL,
      2,
      NULL,
      1,
      '11- 8-1998',
      37,
      2,
      27,
      0.165278,
      NULL,
      ' 6- 0-1993',
      NULL,
      ' 2- 5-1989',
      3.929405,
      NULL,
      2,
      NULL,
      1.037621,
      1,
      NULL,
      NULL,
      NULL,
      102.803921,
      9.995249,
      4,
      0,
      23.795135,
      27,
      4,
      24,
      7.096986,
      3,
      3,
      1.077401,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1.890109,
      0,
      0.567192,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      1,
      7,
      1.794451,
      NULL,
      NULL,
      0.760083,
      NULL,
      1,
      0,
      0,
      0.060383,
      1.435055,
      1.668562,
      5.608138,
      0.968474,
      0.846656,
      0.297289,
      NULL,
      NULL,
      1.779600,
      NULL,
      NULL,
      NULL,
      1.428965,
      NULL,
      1.474585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.669765,
      0.393889,
      0.726178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.890410,
      0.867559,
      7.391967,
      7.829931,
      6,
      1.464481,
      NULL,
      1,
      1.583304,
      NULL,
      1.157632,
      0,
      6,
      0,
      1.219163,
      0,
      NULL,
      NULL,
      NULL,
      3.214687,
      NULL,
      2.391439,
      3,
      2.036699,
      NULL,
      3,
      4,
      1.924269,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.389844,
      7.261818,
      2,
      3.476812,
      1,
      5,
      2.383547,
      2,
      1,
      7.691309,
      1.459865,
      1,
      0,
      3,
      NULL,
      812.456444,
      NULL,
      NULL,
      1,
      0.293784,
      1,
      0,
      1.543685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.425091,
      1,
      0.480185,
      1.535753,
      0.027597,
      2.145440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.721332,
      3,
      NULL,
      2,
      2,
      1.310704,
      NULL,
      NULL,
      1.552851,
      0.147785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.820479,
      0,
      1,
      NULL,
      1,
      1,
      0.226631,
      1.426678,
      13.285746,
      0.954735,
      1.151756,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.329233,
      NULL,
      0.382857,
      1,
      0.925953,
      2.311541,
      3,
      0.789368,
      NULL,
      0,
      0,
      2,
      1.114865,
      NULL,
      1.901004,
      0,
      4.162107,
      0,
      NULL,
      1.872476,
      0,
      1.733152,
      0,
      0.359491,
      NULL,
      1,
      1.194138,
      0,
      1,
      1.015958,
      7.865744,
      NULL,
      7,
      5,
      4,
      0,
      1.971549,
      7,
      3.527776,
      3.732340,
      3.181676,
      0.668979,
      NULL,
      3,
      NULL,
      NULL,
      8,
      75,
      2.332160,
      1.522374,
      0,
      '31112',
      '',
      '',
      1.218501,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      2,
      9.093571,
      305.740609,
      2,
      2.537203,
      27,
      NULL,
      7.262652,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.134935,
      0.601843,
      0.493335,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.621238,
      NULL,
      NULL,
      0.363656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815894,
      8,
      1.019629,
      0.060084,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095055,
      NULL,
      NULL,
      1.436244,
      NULL,
      NULL,
      1.734488,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623703,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020978,
      NULL,
      NULL,
      NULL,
      0.819972,
      1.588278,
      1.979038,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      1,
      NULL,
      NULL,
      4,
      2.863925,
      2,
      0,
      NULL,
      NULL,
      0.830123,
      NULL,
      NULL,
      1.909832,
      NULL,
      NULL,
      1.614630,
      2.406342,
      NULL,
      NULL,
      NULL,
      NULL,
      0.091873,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563845,
      3.759675,
      1,
      1,
      4,
      4.520154,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.265599,
      2.459649,
      0.419527,
      3.570451,
      2,
      NULL,
      5,
      3,
      2,
      3,
      2.637576,
      1.035925,
      NULL,
      NULL,
      0.881004,
      NULL,
      NULL,
      1.914180,
      2,
      3,
      2,
      5,
      3.215988,
      5.140843,
      7.003859,
      NULL,
      1,
      0.826642,
      4.412568,
      1,
      0.836557,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083431,
      NULL,
      NULL,
      0.623058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224531,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.999738,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.437254,
      NULL,
      NULL,
      NULL,
      2.008593,
      NULL,
      NULL,
      NULL,
      3.648349,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088710,
      NULL,
      NULL,
      NULL,
      0.343631,
      NULL,
      3,
      1,
      0,
      148,
      181,
      1,
      80.487571,
      4.300462,
      NULL,
      NULL,
      NULL,
      3.102461,
      16.165607,
      3.011047,
      2.921188,
      17,
      9,
      0,
      32,
      14.558623,
      2.092667,
      28,
      0,
      961,
      40.802713,
      0.499153,
      0.862143,
      0,
      NULL,
      1.095296,
      0.222778,
      1.328344,
      NULL,
      NULL,
      0.088359,
      0.063656,
      1.095154,
      NULL,
      1.617520,
      1.046310,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.920526,
      NULL,
      3.004229,
      NULL,
      5,
      1.945770,
      1,
      NULL,
      16,
      0.336485,
      3.159034,
      0.623429,
      0.515264,
      0.710602,
      NULL,
      0.203893,
      0,
      NULL,
      0.447093,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.064747,
      NULL,
      1,
      3,
      NULL,
      0.024766,
      0,
      NULL,
      NULL,
      0.961867,
      NULL,
      1.792873,
      0,
      NULL,
      0.558718,
      1,
      NULL,
      0.754184,
      0,
      1.952896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      9.010591,
      10,
      8,
      NULL,
      1.755890,
      NULL,
      58.842774,
      NULL,
      1,
      1,
      2.572565,
      '42220',
      '',
      '',
      1.185547,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


