set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9107981';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      0.382157,
      0,
      3,
      '3222',
      3,
      NULL,
      0,
      35.620590,
      NULL,
      75.795851,
      NULL,
      0.390356,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      122,
      4,
      NULL,
      NULL,
      ' 4-16-2001',
      2.319489,
      1,
      NULL,
      NULL,
      0,
      0,
      2.513304,
      0.536200,
      1,
      55.017507,
      10,
      17.611540,
      4,
      NULL,
      4.957415,
      5,
      4,
      NULL,
      4,
      3,
      NULL,
      1,
      0.578004,
      NULL,
      0.892312,
      1,
      1.085002,
      0.670824,
      0.203453,
      1,
      72.497884,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      6,
      5,
      1,
      9.714031,
      0,
      1,
      1.765655,
      NULL,
      NULL,
      3.002646,
      NULL,
      3,
      1.291436,
      5.339500,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.486457,
      0,
      NULL,
      NULL,
      2,
      3.110139,
      1,
      1.065602,
      2,
      1.137693,
      3.727256,
      0,
      1.226116,
      0.649973,
      NULL,
      2.881004,
      1,
      1,
      0.208408,
      9.435188,
      3.051798,
      1.038190,
      9,
      0,
      0,
      0.069512,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154999,
      3,
      1.615254,
      0.282634,
      0,
      NULL,
      3.134052,
      1.765256,
      1.623463,
      1,
      1.846561,
      0,
      1.580596,
      1,
      NULL,
      0,
      NULL,
      0.403818,
      1.250127,
      0,
      0.142930,
      1,
      3,
      1.757526,
      NULL,
      0,
      3,
      5,
      3.019830,
      NULL,
      2,
      NULL,
      1,
      10.525140,
      NULL,
      3,
      NULL,
      2.877127,
      2.413378,
      0.195108,
      2,
      0.017187,
      3.460004,
      NULL,
      2.306813,
      '10- 5-1985',
      NULL,
      NULL,
      40.910874,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.050638,
      1,
      0.945651,
      6,
      0.302733,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402347,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.462904,
      0,
      0.255405,
      0,
      5,
      1,
      1,
      NULL,
      NULL,
      0.378272,
      0.768944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.037436,
      1.650145,
      0,
      NULL,
      NULL,
      1.940312,
      NULL,
      2,
      NULL,
      1.951737,
      0.456653,
      NULL,
      NULL,
      NULL,
      0.249947,
      NULL,
      NULL,
      3,
      2.572300,
      1.259903,
      1.591471,
      3.956228,
      2,
      2,
      3.869390,
      1.245455,
      0.437827,
      2.328273,
      3.047381,
      3.506643,
      5,
      1.838575,
      0,
      NULL,
      0,
      1.600663,
      0,
      NULL,
      NULL,
      0.652715,
      0.838700,
      0,
      0.607338,
      NULL,
      NULL,
      1,
      4,
      11.737902,
      NULL,
      5.217840,
      NULL,
      2.247776,
      4.520605,
      NULL,
      0,
      1,
      1.694797,
      NULL,
      NULL,
      NULL,
      NULL,
      16.019295,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514573,
      0,
      '41032',
      '',
      '',
      3.745292,
      '43310',
      '',
      '',
      0.334995,
      '2323',
      '',
      NULL,
      2,
      44,
      NULL,
      13.586595,
      2.813297,
      14.430335,
      NULL,
      72,
      9.893216,
      1,
      3.482652,
      NULL,
      1.651678,
      NULL,
      NULL,
      0.709472,
      NULL,
      NULL,
      NULL,
      2,
      1.431788,
      2.286353,
      NULL,
      2.440480,
      0.999817,
      NULL,
      NULL,
      1,
      0.202516,
      1,
      0,
      3.920327,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.501756,
      3.530335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.704137,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.292438,
      NULL,
      NULL,
      NULL,
      1.900612,
      2,
      NULL,
      2.689943,
      NULL,
      1,
      2,
      NULL,
      0.959000,
      3.294449,
      2.468191,
      3,
      1,
      0.580543,
      0.118776,
      NULL,
      1,
      2.787215,
      3,
      2,
      NULL,
      3.463142,
      1.969892,
      0,
      1.575641,
      0.093688,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.805704,
      1.981855,
      1,
      3.660218,
      4.709613,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.142808,
      1,
      0.539880,
      0.526069,
      NULL,
      NULL,
      7.969357,
      5.982205,
      NULL,
      2,
      NULL,
      NULL,
      1.009527,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.262392,
      NULL,
      NULL,
      1.725716,
      NULL,
      NULL,
      1.773311,
      NULL,
      NULL,
      1.992821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.169342,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.087761,
      0.615768,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.316065,
      2.194516,
      1.293007,
      2.084964,
      NULL,
      1,
      7.665085,
      1.381042,
      NULL,
      NULL,
      17.673833,
      3.945148,
      0.469898,
      NULL,
      NULL,
      1.669802,
      1.441831,
      1.923668,
      NULL,
      0.592941,
      NULL,
      0.905098,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      2,
      1,
      1,
      0,
      1.239767,
      1,
      NULL,
      3,
      NULL,
      NULL,
      3.978218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.290584,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.090343,
      0.815437,
      0.303830,
      0,
      0,
      3,
      0.251260,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509996,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2,
      0.220826,
      NULL,
      3,
      3.258790,
      134,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514819,
      NULL,
      NULL,
      NULL,
      7.973106,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.335388,
      415,
      37.745323,
      0.979418,
      NULL,
      0,
      3,
      0,
      2.730839,
      1.835722,
      1.713877,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1.731789,
      3,
      NULL,
      0,
      NULL,
      1.683626,
      NULL,
      0,
      NULL,
      3.850180,
      NULL,
      0.416444,
      NULL,
      47.927824,
      NULL,
      4.735210,
      14.759192,
      25.697404,
      0,
      2.694027,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.745214,
      NULL,
      0.697498,
      NULL,
      NULL,
      NULL,
      0.891021,
      NULL,
      0.919582,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.295290,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330052,
      2.549564,
      NULL,
      0.199748,
      NULL,
      2.527347,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.969324,
      NULL,
      0.595221,
      NULL,
      NULL,
      NULL,
      3.034545,
      NULL,
      2.809417,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.008665,
      NULL,
      3.546386,
      NULL,
      1,
      NULL,
      1.054891,
      1.586933,
      0,
      NULL,
      3.726721,
      NULL,
      0,
      NULL,
      303,
      NULL,
      3.962500,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.798646,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      3.606547,
      NULL,
      11,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      NULL,
      3.808056,
      NULL,
      30.271361,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2,
      1.084894,
      2,
      22,
      NULL,
      1.482986,
      0,
      0,
      1.471255,
      1.676388,
      7,
      3,
      9.367036,
      1.245375,
      1.871467,
      2.776013,
      2.883607,
      NULL,
      1.225159,
      0.460468,
      1.623240,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.561866,
      NULL,
      1,
      0,
      NULL,
      3.073454,
      3.748691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684417,
      NULL,
      NULL,
      1.382424,
      NULL,
      NULL,
      3.536071,
      0,
      NULL,
      1.359299,
      0,
      NULL,
      1.440500,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.510718,
      NULL,
      4.075050,
      8,
      2,
      NULL,
      NULL,
      NULL,
      55.990664,
      27.089261,
      5.470020,
      1,
      NULL,
      NULL,
      '10243',
      '12123',
      NULL,
      '14040',
      '',
      '',
      NULL,
      '0213',
      '0244',
      '4214');
commit;
end;
/


