set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6611767';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '24',
      2.856505,
      8.361666,
      '4022203',
      2,
      0.874492,
      NULL,
      2,
      '4434',
      NULL,
      1,
      NULL,
      NULL,
      '11-26-1996',
      26.431214,
      3.276032,
      NULL,
      3.371004,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.702149,
      ' 2-27-1975',
      ' 4-25-1984',
      ' 4- 7-1981',
      3.675907,
      0,
      3,
      1.051379,
      NULL,
      0.486269,
      NULL,
      1,
      1,
      89,
      2.800320,
      8.634811,
      4.566889,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      5.468918,
      NULL,
      1.089956,
      0.875505,
      0,
      NULL,
      1,
      1.635215,
      0.775852,
      1,
      0.308231,
      NULL,
      76.742627,
      NULL,
      0.103262,
      7.511418,
      0.343756,
      6.468370,
      0,
      1,
      NULL,
      1.968036,
      1,
      NULL,
      0,
      0,
      0.392123,
      0.736279,
      1,
      2,
      1,
      1,
      0.120534,
      1.650702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379788,
      2.787661,
      0,
      NULL,
      0.319417,
      0,
      1.366060,
      NULL,
      3.748906,
      1.886189,
      1.935290,
      0,
      1,
      1.678115,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      1.055638,
      4.003946,
      0.599478,
      3.898852,
      1.931295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.258503,
      1,
      1,
      1,
      1,
      NULL,
      0.725939,
      0.578045,
      1.850936,
      NULL,
      1.631266,
      1,
      1,
      0.263128,
      0.328976,
      1.425631,
      1.571073,
      NULL,
      2.030617,
      NULL,
      2,
      8.018028,
      1,
      3.319670,
      7.387980,
      1.670030,
      8,
      0,
      3,
      NULL,
      0.190457,
      0.411606,
      0,
      0,
      3.697796,
      10,
      6.585039,
      6.773922,
      8.699491,
      2.004845,
      NULL,
      6,
      4,
      0.669548,
      8,
      10,
      10,
      0,
      '10-10-1976',
      NULL,
      '10- 7-1979',
      3638,
      NULL,
      1,
      0.646348,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      3.538259,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820511,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.475168,
      0,
      1.870284,
      2.603278,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      11.380042,
      NULL,
      2.390234,
      1,
      NULL,
      1.024340,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.879361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      0.210274,
      NULL,
      0.445673,
      3,
      7571.579342,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      1,
      0.571610,
      2.929028,
      2.542732,
      3.295262,
      3.577374,
      2,
      0,
      3.436810,
      0,
      2,
      NULL,
      3,
      0.870948,
      0,
      2,
      1,
      0,
      NULL,
      1.221542,
      1,
      1.593421,
      NULL,
      NULL,
      1.399593,
      NULL,
      NULL,
      1.536295,
      1,
      3,
      2,
      1,
      0.216041,
      0,
      5.648068,
      1,
      1,
      0,
      1,
      0,
      5.293208,
      1.004113,
      1.248703,
      19.569619,
      NULL,
      NULL,
      NULL,
      NULL,
      3.530404,
      NULL,
      '42403',
      '14401',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245347,
      NULL,
      '',
      '',
      3,
      0.893431,
      676.188618,
      NULL,
      1,
      NULL,
      NULL,
      132.530946,
      NULL,
      2,
      NULL,
      1.639222,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.229295,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.560824,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.000118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497295,
      NULL,
      NULL,
      0.102430,
      NULL,
      NULL,
      0.287675,
      NULL,
      NULL,
      NULL,
      8,
      0.273776,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068396,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.013663,
      2,
      2,
      0,
      NULL,
      0.441974,
      1,
      0,
      1.232695,
      0.783406,
      2,
      0.672392,
      NULL,
      0.760917,
      NULL,
      0,
      NULL,
      NULL,
      0.154854,
      NULL,
      NULL,
      2.928430,
      1.726561,
      1.772343,
      6,
      6.683295,
      0,
      0.788547,
      1.826830,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3.463762,
      3,
      1.248533,
      2,
      0.924948,
      2.294002,
      1,
      NULL,
      NULL,
      NULL,
      2.068799,
      2.409531,
      1.591601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.947626,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.387609,
      1.193053,
      NULL,
      1.768555,
      0,
      3.236737,
      0.050790,
      NULL,
      NULL,
      6,
      0,
      1.313055,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.875895,
      NULL,
      0.753599,
      0.059990,
      1.771126,
      NULL,
      0.391838,
      1.866625,
      0.836562,
      4,
      1,
      7,
      NULL,
      3,
      NULL,
      1.380840,
      NULL,
      0,
      3,
      NULL,
      3,
      NULL,
      3.636414,
      NULL,
      NULL,
      3.780065,
      NULL,
      5,
      3.850218,
      3.485057,
      NULL,
      1,
      2.229879,
      1,
      0.882769,
      1.040665,
      NULL,
      NULL,
      2.448846,
      NULL,
      NULL,
      9.426529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.605690,
      NULL,
      NULL,
      0.417141,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.993516,
      NULL,
      1.077246,
      1,
      1.377276,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.769272,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.297622,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.337294,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      448395.821195,
      1.000434,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      113.523355,
      51055.572612,
      1.435441,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.304057,
      NULL,
      0.222169,
      0,
      1.506914,
      NULL,
      0,
      0,
      NULL,
      1.288055,
      1.613086,
      0,
      0,
      NULL,
      1,
      1.426377,
      0,
      0.604083,
      1,
      0.662649,
      0,
      1,
      1.985655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.596351,
      3.956883,
      9.466924,
      7.247057,
      2,
      6,
      0,
      16.552271,
      NULL,
      0,
      1.107250,
      NULL,
      NULL,
      NULL,
      1.722206,
      1.876080,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.922801,
      NULL,
      0,
      1.785570,
      NULL,
      2.962481,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.889426,
      0.151816,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.244557,
      NULL,
      1.953485,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309993,
      NULL,
      1.890663,
      NULL,
      NULL,
      4,
      NULL,
      1,
      2,
      NULL,
      22.789764,
      5,
      2.444373,
      3.754637,
      1.764550,
      '20114',
      '11434',
      '',
      1,
      '',
      '',
      NULL,
      0.687287,
      '',
      NULL,
      '');
commit;
end;
/


