set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9831665';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      5.063330,
      3,
      3.679883,
      2.009520,
      3,
      2,
      0,
      '410',
      '43131414',
      8,
      NULL,
      NULL,
      2,
      0,
      3,
      0,
      '3043',
      2.914214,
      0,
      NULL,
      NULL,
      ' 7-16-1980',
      64,
      8,
      NULL,
      3,
      3.300202,
      ' 0- 8-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-12-1986',
      1.537532,
      2.102864,
      NULL,
      2,
      0,
      2.496853,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154645,
      NULL,
      NULL,
      NULL,
      NULL,
      3.487187,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      8.067204,
      2,
      1,
      1.336045,
      0,
      0,
      1,
      0,
      7,
      1.548455,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.833468,
      NULL,
      0.429344,
      NULL,
      NULL,
      1.005310,
      NULL,
      NULL,
      2.879344,
      0,
      1,
      3,
      1.174830,
      NULL,
      2.368376,
      1,
      1,
      3,
      0.131996,
      NULL,
      NULL,
      1,
      0.381098,
      1.406466,
      NULL,
      NULL,
      1.500141,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1.121799,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.288392,
      1.590272,
      0.531432,
      1,
      0,
      0.133459,
      NULL,
      1.795971,
      NULL,
      2,
      NULL,
      5.826537,
      0.963466,
      1,
      0,
      NULL,
      1,
      1.798215,
      0.066491,
      NULL,
      1,
      1,
      2.893870,
      1,
      1.777384,
      0.080015,
      4.902783,
      NULL,
      1.535703,
      1,
      0,
      1.058018,
      1,
      0,
      4,
      NULL,
      7,
      NULL,
      4.211470,
      3,
      5.452551,
      7,
      NULL,
      0,
      NULL,
      0.781790,
      NULL,
      2,
      ' 5- 7-1985',
      NULL,
      NULL,
      4,
      3.953199,
      1,
      NULL,
      7.028048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435956,
      0,
      1,
      1,
      1,
      NULL,
      2.401287,
      0.635812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.710606,
      NULL,
      19.896736,
      3.565240,
      0.253604,
      0.471291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.176908,
      2,
      3.011571,
      1,
      3,
      1.329267,
      NULL,
      NULL,
      NULL,
      NULL,
      3.405871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.715852,
      0,
      0,
      0.776210,
      NULL,
      1,
      NULL,
      1.945217,
      6.051009,
      NULL,
      1.904479,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      3.213444,
      3.993981,
      0.009604,
      2.980851,
      0.525799,
      3,
      0,
      0.292787,
      3.225012,
      3,
      NULL,
      3.222319,
      0,
      1,
      0,
      1.436776,
      NULL,
      0.265944,
      NULL,
      1.290511,
      1.505353,
      1,
      0,
      1,
      NULL,
      1,
      2.838298,
      0,
      1.343380,
      8,
      7,
      NULL,
      0.826546,
      4,
      6.663245,
      2,
      2,
      3,
      2.810443,
      0,
      0.311602,
      42.185317,
      2,
      3.334280,
      NULL,
      NULL,
      NULL,
      NULL,
      3.058838,
      3,
      NULL,
      '32204',
      '',
      '',
      0.640466,
      '',
      '',
      '',
      0.484950,
      '',
      '',
      '',
      3,
      12.750475,
      24.389899,
      11,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.376984,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.163960,
      NULL,
      NULL,
      0.866792,
      NULL,
      NULL,
      NULL,
      1,
      1.886288,
      NULL,
      NULL,
      NULL,
      1.540549,
      NULL,
      NULL,
      0.529731,
      NULL,
      NULL,
      0.935303,
      NULL,
      NULL,
      1.066524,
      NULL,
      NULL,
      0.018187,
      NULL,
      0.588781,
      1.156549,
      0.129289,
      NULL,
      NULL,
      NULL,
      2.166130,
      0.214325,
      3.562960,
      NULL,
      NULL,
      1,
      0,
      1.322632,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.613122,
      1,
      0.092128,
      0.964488,
      0,
      0.190403,
      0.502089,
      0,
      0.290575,
      0,
      0,
      0.220720,
      1.695247,
      3.387425,
      0,
      NULL,
      NULL,
      0.990006,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.947396,
      1.288905,
      0,
      1.295338,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.175042,
      1.979238,
      NULL,
      0.990573,
      NULL,
      NULL,
      0.372406,
      NULL,
      NULL,
      0.981661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.981765,
      NULL,
      NULL,
      0.390669,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154775,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      0.869935,
      1,
      0,
      1,
      2,
      3,
      1.906141,
      NULL,
      5.395291,
      0,
      NULL,
      NULL,
      NULL,
      1.728577,
      NULL,
      NULL,
      2.249006,
      NULL,
      1.838911,
      0,
      1,
      1.763883,
      0,
      3,
      3.418773,
      NULL,
      NULL,
      0.143862,
      3.753067,
      1.606698,
      0.617914,
      0,
      1.571348,
      NULL,
      1,
      NULL,
      1,
      1.629460,
      1,
      0.004850,
      2,
      5.016775,
      4,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.396174,
      1.974291,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.870451,
      0.463402,
      0,
      0.669170,
      NULL,
      1.675609,
      7,
      NULL,
      NULL,
      NULL,
      69,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.136446,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.779917,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.224698,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.981617,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.319992,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.666835,
      0,
      0.976871,
      0.983046,
      2,
      0.622336,
      NULL,
      NULL,
      1.581412,
      NULL,
      NULL,
      1.879316,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      239,
      NULL,
      0,
      1,
      1.253438,
      0,
      1.331822,
      NULL,
      NULL,
      NULL,
      1.019928,
      3,
      1.798135,
      2.147218,
      0,
      1.336309,
      1.697155,
      0.031725,
      0,
      0,
      NULL,
      3.143661,
      NULL,
      3.158885,
      NULL,
      0,
      NULL,
      1.553622,
      NULL,
      1,
      NULL,
      12,
      NULL,
      2.077994,
      27.858421,
      4,
      0.451412,
      1.482826,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.222352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484599,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.223355,
      NULL,
      1,
      0.084913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.313015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.798572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691859,
      0.815781,
      NULL,
      NULL,
      NULL,
      2.973230,
      NULL,
      189.816308,
      NULL,
      0.851950,
      NULL,
      NULL,
      NULL,
      3,
      0.535360,
      1,
      12,
      33.450818,
      NULL,
      NULL,
      NULL,
      NULL,
      3.025861,
      2.656053,
      NULL,
      11.139780,
      2.334276,
      2,
      0,
      2.227096,
      13,
      NULL,
      2.469506,
      1,
      1.049274,
      1.870304,
      NULL,
      NULL,
      1.453862,
      0,
      NULL,
      3,
      NULL,
      3.675760,
      0.326675,
      NULL,
      3,
      0.043889,
      2,
      0.866497,
      NULL,
      1,
      3,
      0.363086,
      NULL,
      3.646330,
      1.850054,
      3.756529,
      1.095959,
      1,
      NULL,
      0,
      0.925603,
      1,
      0,
      1,
      1.916647,
      1.767594,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287345,
      1.211335,
      NULL,
      0.209584,
      0,
      NULL,
      4,
      1.724504,
      NULL,
      0.897837,
      NULL,
      NULL,
      106,
      95,
      NULL,
      NULL,
      NULL,
      '30224',
      '31100',
      '3043',
      0,
      NULL,
      NULL,
      '',
      3.531821,
      '004',
      NULL,
      '');
commit;
end;
/


