set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3611604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '0423133',
      2.444459,
      1,
      3,
      1,
      '1011',
      1.078238,
      NULL,
      NULL,
      NULL,
      NULL,
      25.842441,
      NULL,
      5.253203,
      2.267724,
      0.859629,
      NULL,
      21,
      NULL,
      34.060169,
      83,
      3,
      NULL,
      ' 7-20-1975',
      ' 6- 4-1989',
      0.000951,
      0,
      2.919017,
      1,
      0,
      0.076506,
      NULL,
      NULL,
      0,
      667,
      5,
      15,
      1,
      NULL,
      4,
      NULL,
      NULL,
      0.595161,
      2.880707,
      5,
      1,
      1.111617,
      1,
      1.179394,
      1.777317,
      0,
      0.601922,
      1.952030,
      0.077849,
      0,
      15,
      12,
      2.087990,
      3.250298,
      NULL,
      1,
      0.614124,
      1,
      9,
      1,
      1,
      0.367029,
      0,
      1.674164,
      0,
      0,
      0,
      3.292509,
      1,
      4,
      NULL,
      0,
      1.472182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      1.088102,
      1,
      0.834915,
      3.203702,
      NULL,
      NULL,
      2.161910,
      NULL,
      0,
      1,
      1.191119,
      0.463187,
      3.074591,
      2.982174,
      0,
      0.112561,
      0,
      1,
      NULL,
      2.751147,
      1.777553,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      6.685107,
      1,
      5,
      0.013797,
      0.826934,
      1.422091,
      1.435238,
      NULL,
      0.970773,
      0,
      1.546718,
      2.052486,
      1,
      NULL,
      0.252976,
      NULL,
      0.321225,
      NULL,
      1.537546,
      1,
      1,
      0,
      1,
      8.753210,
      1.071685,
      1,
      0,
      NULL,
      NULL,
      1,
      6,
      NULL,
      1.263305,
      4.941833,
      3.390466,
      NULL,
      6.774011,
      NULL,
      4,
      NULL,
      0,
      1.155501,
      1,
      2.429757,
      2.632549,
      NULL,
      NULL,
      NULL,
      ' 3-15-1990',
      860.815805,
      NULL,
      1,
      NULL,
      4.705081,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.523282,
      0,
      0,
      0,
      1.370958,
      1.721795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323985,
      0.993529,
      NULL,
      NULL,
      0.501892,
      4.543226,
      0.045076,
      NULL,
      NULL,
      NULL,
      1,
      3.737549,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.007337,
      NULL,
      1.623783,
      0,
      1,
      NULL,
      NULL,
      0,
      1.871276,
      NULL,
      NULL,
      NULL,
      2.795135,
      NULL,
      1.032652,
      3.874681,
      2.732561,
      2,
      2,
      1.804476,
      NULL,
      0.584302,
      1.563902,
      2.350035,
      NULL,
      NULL,
      NULL,
      0,
      9,
      0.941802,
      1.481882,
      3,
      1,
      0,
      1.747452,
      0,
      1,
      0.472508,
      0.909061,
      0,
      0,
      1.841086,
      0.282431,
      1,
      5,
      0.519646,
      1.155773,
      0.615974,
      0.937172,
      3,
      1,
      0,
      6,
      0,
      NULL,
      1,
      24.042975,
      1.667420,
      1.290127,
      NULL,
      26,
      52.238288,
      NULL,
      NULL,
      0.051181,
      3.619900,
      '24004',
      NULL,
      '',
      0.709943,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      34,
      547.829256,
      1.620723,
      NULL,
      3,
      15.516224,
      76,
      0,
      NULL,
      1.497113,
      NULL,
      0,
      NULL,
      NULL,
      1.829611,
      NULL,
      NULL,
      NULL,
      0.754634,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.177107,
      NULL,
      NULL,
      0,
      NULL,
      5.703523,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.710917,
      1,
      NULL,
      1,
      NULL,
      0.452710,
      3,
      0,
      NULL,
      NULL,
      1.463465,
      NULL,
      NULL,
      0.541746,
      NULL,
      0.508193,
      NULL,
      0.530273,
      0,
      1,
      1.505811,
      NULL,
      1.616544,
      0.294615,
      NULL,
      0,
      3.584757,
      3,
      NULL,
      1.027602,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8.565115,
      6.021877,
      6,
      1.027686,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719232,
      1.609227,
      0,
      NULL,
      NULL,
      NULL,
      0.366844,
      3.099151,
      3.488182,
      3.162490,
      NULL,
      0,
      1.917092,
      NULL,
      NULL,
      1.372034,
      NULL,
      1.000303,
      2.502468,
      1,
      NULL,
      1,
      NULL,
      NULL,
      7.342014,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.035665,
      NULL,
      NULL,
      3,
      1,
      3,
      0.756471,
      NULL,
      NULL,
      1.794642,
      0,
      3,
      6.586245,
      0.506481,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.079679,
      3,
      NULL,
      0,
      1,
      6,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.019961,
      1,
      2,
      0.662825,
      0,
      0.289826,
      0,
      0,
      0.942597,
      NULL,
      NULL,
      2,
      NULL,
      1.176879,
      0,
      1,
      5.755133,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828038,
      NULL,
      NULL,
      1.807512,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.309686,
      NULL,
      NULL,
      0.923845,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.160608,
      1.535246,
      1,
      2,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      8.625031,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.381583,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458263,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.034503,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.046726,
      NULL,
      NULL,
      NULL,
      3.360920,
      NULL,
      NULL,
      NULL,
      0.680518,
      NULL,
      NULL,
      NULL,
      1.128995,
      NULL,
      74.599162,
      0.620936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497514,
      13,
      0.837508,
      183.912114,
      0,
      NULL,
      1,
      0.059550,
      1.807786,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1.528790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422392,
      0,
      1,
      1.777944,
      0.494728,
      1,
      0.509050,
      0.994847,
      5,
      0,
      3.835839,
      0,
      1,
      0,
      NULL,
      0,
      0.477792,
      NULL,
      0.557622,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.787347,
      1.749316,
      NULL,
      0.018427,
      1.851921,
      NULL,
      0,
      1.544871,
      NULL,
      1,
      1.959604,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.084541,
      NULL,
      2,
      NULL,
      1.883552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156086,
      NULL,
      1,
      NULL,
      0,
      NULL,
      8.418408,
      6.531867,
      3.551206,
      1.002679,
      0,
      3,
      31,
      59,
      7,
      0.441093,
      0,
      '13330',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


