set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000159';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '1224224',
      0.717139,
      NULL,
      2,
      NULL,
      '4214',
      NULL,
      3,
      1.868830,
      NULL,
      ' 6-19-1994',
      62,
      NULL,
      NULL,
      1.605804,
      1.604429,
      ' 4-14-2001',
      16.524111,
      0,
      54.418945,
      85.692229,
      0,
      NULL,
      NULL,
      '10-10-1978',
      0.606036,
      0,
      1,
      NULL,
      1.484403,
      0,
      NULL,
      2.724664,
      NULL,
      NULL,
      NULL,
      12,
      4.516930,
      8.398867,
      19,
      3,
      2.456430,
      2.980535,
      4.953830,
      9,
      1,
      NULL,
      0,
      0.790446,
      1,
      0.203953,
      1.032347,
      0.222514,
      NULL,
      1,
      38,
      12,
      3,
      NULL,
      3.851707,
      5,
      3.545694,
      0,
      0,
      0.927607,
      0.533145,
      7,
      0,
      3.278884,
      NULL,
      1,
      NULL,
      3.909045,
      1,
      NULL,
      0.299223,
      1,
      0.921944,
      NULL,
      NULL,
      0.574700,
      1,
      4,
      0.653907,
      0.529086,
      3.425922,
      1.173610,
      0.744117,
      1,
      0,
      NULL,
      0.956308,
      0,
      1,
      1,
      0.694559,
      NULL,
      NULL,
      NULL,
      1,
      1.773961,
      0,
      0,
      0,
      1,
      7.859258,
      0.171376,
      0.849137,
      0.706916,
      0,
      NULL,
      NULL,
      NULL,
      1.681667,
      NULL,
      0.259882,
      1.076163,
      8.086427,
      NULL,
      5.438919,
      NULL,
      NULL,
      0,
      2.740931,
      NULL,
      1,
      1,
      NULL,
      1.364702,
      1,
      0.397745,
      0.918007,
      1,
      1,
      NULL,
      1,
      9,
      NULL,
      1.311118,
      1,
      NULL,
      6.304396,
      8.770318,
      5,
      NULL,
      NULL,
      5,
      NULL,
      10,
      NULL,
      0.476910,
      9,
      7.416321,
      3,
      5.584535,
      0.535012,
      5.549501,
      9,
      9,
      7.827817,
      NULL,
      2,
      2.480557,
      '10- 4-1987',
      35.436334,
      ' 8-17-1994',
      NULL,
      2,
      4,
      1,
      NULL,
      1.927002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.184933,
      NULL,
      1.139020,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.063145,
      NULL,
      83.420632,
      2.819225,
      1.457912,
      7.380756,
      1,
      1.979692,
      1,
      3,
      NULL,
      5,
      0,
      1,
      0.099292,
      1.809456,
      0,
      4.150046,
      5,
      6.023596,
      3.472460,
      NULL,
      9.013710,
      1,
      2,
      5,
      NULL,
      0.039650,
      12.891041,
      3,
      0,
      5.140679,
      5,
      NULL,
      ' 0- 5-1975',
      34.534468,
      ' 7-13-1988',
      59,
      3,
      3.094169,
      0.793279,
      2.544323,
      2.325380,
      NULL,
      0.053243,
      0,
      0,
      0,
      1.673399,
      448,
      1,
      0.198745,
      NULL,
      NULL,
      NULL,
      2.145635,
      1.489399,
      1,
      3,
      3.536849,
      1.140428,
      2,
      NULL,
      0.546984,
      NULL,
      NULL,
      NULL,
      0.677605,
      0,
      2.393427,
      NULL,
      0,
      0.394225,
      0,
      NULL,
      1,
      1,
      0.110487,
      0.843879,
      NULL,
      0,
      0.318306,
      0.081042,
      NULL,
      3.930330,
      0.780637,
      1.901089,
      10,
      11.747956,
      6,
      5,
      7,
      3,
      NULL,
      0,
      7,
      NULL,
      2.659578,
      NULL,
      30,
      0.144551,
      NULL,
      51,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.076240,
      NULL,
      '',
      '',
      2,
      '23014',
      '',
      '',
      0.718240,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      1.047284,
      3,
      13,
      2.423474,
      0.876927,
      NULL,
      NULL,
      1.703924,
      NULL,
      NULL,
      0.995307,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      14,
      1.747969,
      1,
      NULL,
      NULL,
      1.008775,
      NULL,
      0,
      NULL,
      1,
      1,
      1.846482,
      0,
      0.170193,
      0.168630,
      NULL,
      1.338352,
      NULL,
      NULL,
      1.115613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.543978,
      NULL,
      1,
      8.626854,
      5.950747,
      NULL,
      5.170681,
      2,
      NULL,
      2.120154,
      1.905849,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.955232,
      NULL,
      1.640371,
      NULL,
      NULL,
      1.558263,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      3.212898,
      NULL,
      NULL,
      2.480222,
      NULL,
      1.026691,
      0,
      NULL,
      1,
      2.979922,
      NULL,
      1.867946,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372599,
      NULL,
      0,
      NULL,
      1.426801,
      NULL,
      NULL,
      1.957854,
      0.284245,
      2.990470,
      NULL,
      3.821218,
      87.333807,
      96,
      5,
      NULL,
      2.466709,
      '30212',
      '',
      '',
      2.350609,
      '12140',
      '',
      '',
      0.694701,
      '',
      '',
      '');
commit;
end;
/


