set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9986186';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3,
      0.087810,
      3,
      1.717413,
      NULL,
      2,
      0,
      '424',
      '33322433',
      19,
      18.764160,
      '3213223',
      NULL,
      1.110835,
      NULL,
      0,
      '2010',
      3,
      1.849454,
      NULL,
      NULL,
      ' 8-19-1989',
      19.606676,
      59.059952,
      NULL,
      2,
      14.146078,
      ' 8-20-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '10- 0-1983',
      0,
      1.749841,
      1,
      1,
      1.039845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.305835,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0.005466,
      0,
      1,
      1,
      0.611947,
      0,
      0.150276,
      NULL,
      3,
      NULL,
      2.631363,
      2,
      1.515666,
      0.693781,
      9.917990,
      0.877954,
      0.856821,
      4.555080,
      0,
      0.726633,
      NULL,
      1,
      0.208673,
      5,
      NULL,
      3,
      4.385028,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723872,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271859,
      0.728596,
      7,
      1.550065,
      0,
      NULL,
      1.813242,
      1,
      NULL,
      0.434689,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513388,
      1.305266,
      0,
      0.090248,
      NULL,
      NULL,
      0.062247,
      NULL,
      0.026866,
      1,
      0,
      NULL,
      0.200656,
      0,
      1.832344,
      1,
      1,
      0,
      0.190939,
      NULL,
      7.650469,
      0,
      0,
      NULL,
      5.560619,
      NULL,
      2,
      7.507059,
      2,
      1,
      1,
      1.613661,
      1.395889,
      NULL,
      ' 6-21-1996',
      4,
      '10-18-1983',
      15.728039,
      NULL,
      2.792677,
      0,
      2.287421,
      0.367215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751549,
      0,
      NULL,
      0,
      0.751930,
      1.170964,
      0,
      0.386795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.502561,
      2.570511,
      3,
      NULL,
      0,
      2.194362,
      1,
      NULL,
      2,
      NULL,
      2,
      0.539840,
      NULL,
      NULL,
      NULL,
      0.380248,
      0.512825,
      0.755350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985581,
      1,
      NULL,
      0.560062,
      1,
      0.996266,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.975394,
      NULL,
      1.384070,
      3.629198,
      NULL,
      2,
      0,
      3.464208,
      0.343059,
      1.486978,
      1,
      0.255308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696697,
      3.609769,
      9,
      NULL,
      1,
      2.814513,
      0.206838,
      3.380169,
      1.333102,
      NULL,
      3,
      NULL,
      1,
      42,
      NULL,
      1,
      78,
      NULL,
      NULL,
      NULL,
      0.013613,
      5,
      0.397046,
      '12410',
      '',
      '',
      0.740576,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      203.300251,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.785496,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.732292,
      NULL,
      NULL,
      1.842328,
      NULL,
      NULL,
      1.729547,
      NULL,
      NULL,
      0.499368,
      NULL,
      NULL,
      1.227208,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.692416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133119,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.866076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.997533,
      1,
      0,
      3.633405,
      1,
      1.470549,
      0,
      NULL,
      NULL,
      0,
      0.380906,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.390765,
      NULL,
      5,
      NULL,
      0.254871,
      0.361410,
      NULL,
      NULL,
      0.323217,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.538992,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624054,
      NULL,
      NULL,
      0.359970,
      NULL,
      NULL,
      1.096366,
      NULL,
      NULL,
      0.062495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.334434,
      0.122492,
      1,
      1.276922,
      0.369028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.977435,
      1.366133,
      0,
      1,
      0.326109,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168775,
      NULL,
      NULL,
      NULL,
      0.272181,
      NULL,
      0,
      NULL,
      3.700339,
      1.442171,
      0.923142,
      NULL,
      NULL,
      NULL,
      3.357159,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.745820,
      0,
      1.923219,
      0,
      NULL,
      1,
      0.441771,
      1.869270,
      0,
      NULL,
      1.082901,
      NULL,
      0,
      0.426113,
      0,
      1,
      1,
      1.611656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956518,
      1.151974,
      0.228283,
      0.074641,
      1,
      3,
      NULL,
      0,
      3,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.780896,
      3.392997,
      NULL,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.439492,
      1,
      NULL,
      0,
      1,
      NULL,
      1.499343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662241,
      1,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518867,
      NULL,
      NULL,
      NULL,
      0.746843,
      NULL,
      1,
      0,
      5.485638,
      0,
      NULL,
      NULL,
      37.583146,
      19.008439,
      4,
      NULL,
      2.424091,
      '41201',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.468727,
      '',
      '',
      '');
commit;
end;
/


