set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '3023301',
      NULL,
      1,
      1,
      0,
      '3132',
      2.495317,
      0.479357,
      NULL,
      NULL,
      ' 5-22-1989',
      47,
      NULL,
      5,
      3.623348,
      NULL,
      ' 2-14-1983',
      NULL,
      4,
      179.009338,
      28.051537,
      1,
      ' 5- 9-1993',
      ' 5- 8-1996',
      NULL,
      1.613929,
      NULL,
      1.416783,
      NULL,
      1,
      NULL,
      2,
      2.147806,
      NULL,
      NULL,
      NULL,
      7,
      0.378362,
      NULL,
      11.193291,
      5.430265,
      4,
      2.423723,
      NULL,
      2.743635,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.711903,
      2,
      NULL,
      0.829243,
      NULL,
      3,
      5.026469,
      3.974523,
      NULL,
      4,
      0,
      3.319764,
      0.082105,
      4.380383,
      0.178474,
      5.449155,
      1.573941,
      NULL,
      0.323004,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      2,
      1.562740,
      NULL,
      0.200850,
      3,
      0.391198,
      1,
      NULL,
      0.250463,
      NULL,
      1.538206,
      NULL,
      NULL,
      2.375776,
      0.082209,
      3,
      8.885220,
      0.162532,
      3,
      3,
      0.556918,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      2.295487,
      2.435134,
      2.261096,
      0,
      0,
      1,
      0,
      4.474430,
      NULL,
      1,
      1.769948,
      1.469798,
      1,
      NULL,
      0.862567,
      3.794174,
      1.715494,
      2.728143,
      0,
      NULL,
      4.565134,
      0,
      1.852755,
      0.504589,
      0.924922,
      1,
      NULL,
      1.636035,
      0.772561,
      2.668792,
      5.772024,
      NULL,
      4.055482,
      NULL,
      8.835951,
      6.409246,
      3.454122,
      2.338135,
      3.708899,
      2.247832,
      3,
      2,
      1.241628,
      4.418440,
      3,
      '10-27-1975',
      19.858689,
      ' 7- 6-2002',
      15.093870,
      NULL,
      0,
      0,
      2.766863,
      3.293490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.452075,
      NULL,
      3,
      0.381800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      9,
      1,
      NULL,
      1,
      2.263251,
      NULL,
      NULL,
      1.778057,
      NULL,
      1,
      1.658477,
      2.375050,
      0,
      1.775591,
      NULL,
      1.179811,
      0.111764,
      2.192061,
      1,
      2.935788,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.498317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1.332399,
      NULL,
      1,
      35,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0.742522,
      2,
      0,
      NULL,
      2,
      1.093297,
      3.299272,
      3,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      1.839328,
      1.838299,
      1,
      0,
      0,
      0,
      1,
      1.121299,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      10,
      7,
      10.714668,
      4,
      5,
      3,
      3.108930,
      NULL,
      NULL,
      0,
      0,
      34.995713,
      NULL,
      2,
      NULL,
      57.339675,
      8,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '43204',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '21211',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.741117,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.771359,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.427692,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.257230,
      1,
      1,
      1,
      0.376686,
      1,
      1,
      1.879459,
      1,
      0.874264,
      0,
      0.799990,
      3.666660,
      0.766010,
      0.596691,
      1,
      0.285495,
      NULL,
      3.206530,
      NULL,
      NULL,
      NULL,
      1.570352,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.807370,
      NULL,
      8,
      NULL,
      1,
      5,
      27.956352,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.846933,
      NULL,
      1.546852,
      NULL,
      2.627829,
      NULL,
      0,
      NULL,
      1.000264,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.049260,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.935926,
      NULL,
      1,
      2.788644,
      1.685091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684349,
      1.273578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.902699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.376737,
      1.446948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823027,
      NULL,
      NULL,
      1.058881,
      NULL,
      0.623361,
      NULL,
      NULL,
      NULL,
      0.004368,
      NULL,
      1,
      NULL,
      0,
      0.803452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.423592,
      0,
      NULL,
      1.735447,
      1.905515,
      5,
      3.741335,
      3,
      1,
      0.507240,
      2.226975,
      NULL,
      0.419958,
      0.299307,
      NULL,
      NULL,
      0.863947,
      NULL,
      1,
      0,
      NULL,
      0.024330,
      0,
      NULL,
      1,
      3.536980,
      NULL,
      0,
      3.566362,
      NULL,
      0,
      NULL,
      NULL,
      1.722938,
      2,
      NULL,
      1.293049,
      0.087536,
      NULL,
      1,
      NULL,
      NULL,
      2.673073,
      0.729775,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.467214,
      NULL,
      0,
      NULL,
      0.614573,
      4.899192,
      NULL,
      1,
      NULL,
      NULL,
      103.599013,
      93.797420,
      0.575963,
      NULL,
      2.076150,
      '04424',
      '40000',
      '',
      0.979884,
      '',
      NULL,
      '',
      0.817218,
      '12230',
      '',
      '');
commit;
end;
/


