set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9914576';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.824265,
      2.766630,
      4,
      NULL,
      7.396725,
      1,
      3.410171,
      2.964132,
      '321',
      '13140312',
      15,
      NULL,
      '0432304',
      0,
      0,
      4,
      NULL,
      '2332',
      0.003519,
      0.827467,
      NULL,
      NULL,
      ' 7-25-1987',
      22.726992,
      7,
      NULL,
      1.898900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '10- 9-2000',
      NULL,
      1,
      1,
      1.586986,
      0.157767,
      1.376594,
      0,
      NULL,
      1,
      22,
      3,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      9.831061,
      2.198897,
      NULL,
      0,
      0.616013,
      1.839127,
      1,
      NULL,
      1,
      0.872959,
      1.813864,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.465644,
      5.974879,
      0,
      3.401943,
      0,
      1,
      6.232297,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.110253,
      9.440370,
      1,
      3.250924,
      1.392065,
      0,
      0.068244,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.942162,
      1,
      2,
      5.765697,
      NULL,
      1,
      0.691097,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.746026,
      4,
      0,
      1,
      1,
      1.173576,
      1,
      1,
      NULL,
      0.807933,
      4,
      1.688231,
      1,
      0.902293,
      NULL,
      0.406630,
      NULL,
      1.808981,
      5,
      3.135789,
      0.045483,
      NULL,
      0.982997,
      7.603313,
      NULL,
      2,
      7,
      3,
      1,
      6.307040,
      5.367218,
      2.882919,
      0.750177,
      7,
      2.289126,
      2,
      1.327600,
      4.717257,
      NULL,
      0.045727,
      5,
      2.207838,
      9,
      NULL,
      3,
      ' 9- 3-2002',
      67,
      ' 5-18-1996',
      62.396358,
      2.501331,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.425585,
      1.132168,
      2.883459,
      NULL,
      1.428804,
      1.775032,
      1.683670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.922680,
      1,
      NULL,
      NULL,
      NULL,
      6.466211,
      8.040581,
      4.073190,
      5.283611,
      0.724256,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357508,
      10,
      1.184771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.142865,
      NULL,
      1.006207,
      0.785314,
      1,
      0,
      0,
      NULL,
      2,
      1.722404,
      NULL,
      NULL,
      NULL,
      0,
      2.606963,
      2.672190,
      0.812561,
      3,
      3,
      NULL,
      1,
      NULL,
      3,
      1,
      0.453833,
      2,
      3.396381,
      2,
      2,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0.808241,
      1.360529,
      0,
      NULL,
      1.290207,
      0,
      0,
      NULL,
      3.253735,
      1.815307,
      8.399340,
      0,
      6,
      0,
      4.458674,
      5,
      4.081921,
      2,
      6.203813,
      2.163366,
      NULL,
      1,
      26.819424,
      1,
      NULL,
      36.464434,
      NULL,
      NULL,
      NULL,
      3.803733,
      1,
      1,
      '21441',
      '02321',
      '24121',
      3.022179,
      '32022',
      '',
      '',
      1,
      '',
      NULL,
      '',
      2,
      9,
      29.063729,
      6.804971,
      1.922641,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403248,
      1.441733,
      2.857109,
      0,
      NULL,
      NULL,
      1.908213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.888646,
      NULL,
      1.887306,
      2.566387,
      0.028828,
      0,
      3.686485,
      2.938503,
      NULL,
      1.915367,
      1.952872,
      3.937101,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.256407,
      NULL,
      NULL,
      1.947351,
      9.725475,
      1,
      2.362293,
      0.885781,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.717223,
      1,
      2.112436,
      1.156295,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.956652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.265784,
      3.373547,
      1,
      1,
      NULL,
      NULL,
      0.581229,
      NULL,
      NULL,
      3,
      0,
      7.857980,
      3.127744,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.834510,
      3.229973,
      0,
      NULL,
      3.180537,
      1.103669,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.947099,
      0.287192,
      3.708345,
      0.902837,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.583842,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860010,
      NULL,
      NULL,
      NULL,
      3,
      0.063027,
      NULL,
      1.994256,
      3.674509,
      4.325565,
      NULL,
      1.675033,
      11.744892,
      3,
      3,
      2.849074,
      NULL,
      NULL,
      2,
      NULL,
      2,
      2,
      2.090668,
      3.711415,
      NULL,
      NULL,
      2,
      10.992357,
      10.865310,
      3,
      NULL,
      3.166387,
      0.819624,
      3,
      0.011622,
      1.520970,
      3.342160,
      NULL,
      3,
      2,
      0.087399,
      0,
      3,
      2.100744,
      NULL,
      3,
      2.045069,
      6.679586,
      1,
      3.080143,
      9.569152,
      0,
      0,
      1,
      1.117610,
      NULL,
      2.771446,
      NULL,
      NULL,
      0.578914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079322,
      NULL,
      NULL,
      0.443200,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.642466,
      0.945417,
      NULL,
      1.606768,
      0.215490,
      NULL,
      NULL,
      NULL,
      1.088819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.525515,
      NULL,
      NULL,
      NULL,
      0.377186,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412072,
      NULL,
      NULL,
      NULL,
      3.008793,
      NULL,
      NULL,
      NULL,
      3.301692,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.137645,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.708904,
      NULL,
      NULL,
      0.749524,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.648120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      333.231356,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1.293733,
      1.427767,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0.467592,
      3,
      1.430866,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.874391,
      NULL,
      1,
      NULL,
      73,
      NULL,
      2,
      NULL,
      19.424280,
      NULL,
      1.623661,
      0,
      NULL,
      1.722064,
      NULL,
      NULL,
      NULL,
      0.405589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.881112,
      NULL,
      0.770656,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.516694,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.225380,
      NULL,
      NULL,
      0,
      0.016672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.206413,
      1.921006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137893,
      2,
      NULL,
      1.251305,
      NULL,
      0.852043,
      NULL,
      NULL,
      NULL,
      0.217431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.069969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.839877,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      126.182783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      6.892461,
      NULL,
      2.690513,
      2.351862,
      0,
      NULL,
      0.336428,
      3,
      1,
      9.513999,
      2.790007,
      3.742087,
      2,
      NULL,
      3,
      0,
      0.781807,
      NULL,
      0.487076,
      0.398718,
      NULL,
      0.914307,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.732004,
      0,
      NULL,
      2.896314,
      NULL,
      NULL,
      1.715624,
      2.843715,
      NULL,
      1,
      3,
      NULL,
      3,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.197222,
      NULL,
      1.277445,
      NULL,
      NULL,
      1.581777,
      1.255465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.648911,
      NULL,
      1,
      NULL,
      6.496209,
      NULL,
      7.429722,
      NULL,
      0.666274,
      1,
      38.871930,
      97.927175,
      3,
      0.064296,
      1,
      '30101',
      NULL,
      NULL,
      2,
      '43022',
      '',
      '',
      0.374640,
      '',
      '',
      '');
commit;
end;
/


