set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '1213244',
      NULL,
      NULL,
      5,
      3,
      '4144',
      0.763719,
      NULL,
      NULL,
      NULL,
      ' 1-13-1986',
      48,
      NULL,
      7.391288,
      1,
      1,
      ' 1-24-1986',
      7,
      NULL,
      135.952349,
      23.701899,
      2.828060,
      NULL,
      ' 2-26-1989',
      NULL,
      3,
      2.783501,
      NULL,
      0.961112,
      1,
      0.271706,
      1.622637,
      2.014044,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      13,
      4.366876,
      17,
      2,
      NULL,
      4.947750,
      0,
      0,
      6,
      1.602609,
      1.250398,
      0,
      0.817586,
      1,
      1,
      0,
      0.092583,
      2,
      3.282334,
      2,
      0.167606,
      2,
      0.389682,
      0.563869,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0.862299,
      NULL,
      1.350776,
      NULL,
      1.816553,
      0.941643,
      1,
      NULL,
      NULL,
      1.404850,
      NULL,
      NULL,
      1,
      0,
      1.912728,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594936,
      1.512430,
      NULL,
      0,
      2.044041,
      0.948006,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.005649,
      0,
      NULL,
      1.015911,
      0.112549,
      1,
      1,
      0,
      1.626319,
      1,
      1,
      0,
      0.269807,
      0.582737,
      0.093231,
      0.990882,
      NULL,
      1,
      NULL,
      1.804207,
      1,
      1.150520,
      1.633565,
      0.903430,
      NULL,
      1.017011,
      1.504282,
      1,
      0,
      NULL,
      0.845901,
      1,
      0.101667,
      1,
      1,
      0.225997,
      0.907462,
      0.333191,
      0.329879,
      NULL,
      0.791084,
      0.681136,
      1.588270,
      0,
      0.560158,
      0.064159,
      NULL,
      ' 3-17-1990',
      17,
      ' 4- 8-1991',
      2.018491,
      0,
      1.255696,
      NULL,
      1.541762,
      1.213362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.247554,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.902380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870080,
      1.907047,
      0,
      1,
      0.149240,
      2.863363,
      2,
      0.444449,
      2.612662,
      1.454804,
      NULL,
      NULL,
      NULL,
      0,
      1.172328,
      1.497393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709055,
      1.118094,
      1.668969,
      1.048447,
      1.263914,
      1,
      3,
      17,
      1.181718,
      0.054246,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273008,
      0,
      3,
      4.077461,
      0.810253,
      3.399036,
      0.199805,
      0.463153,
      4,
      NULL,
      3,
      NULL,
      5,
      3.979878,
      NULL,
      6.533455,
      NULL,
      0,
      4,
      NULL,
      NULL,
      0,
      NULL,
      0.163221,
      1.629624,
      1.931816,
      0.692843,
      1,
      0.070085,
      0.938191,
      0,
      3,
      10.676916,
      0,
      NULL,
      3,
      3,
      3,
      0,
      NULL,
      0.954983,
      0.635477,
      NULL,
      30.125243,
      2.231171,
      1,
      NULL,
      44,
      32.604008,
      82.914213,
      2,
      5,
      1,
      '1041',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.243268,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.146974,
      NULL,
      1,
      1.018214,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.822547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.217795,
      NULL,
      NULL,
      1.201559,
      NULL,
      1,
      399.351357,
      NULL,
      NULL,
      1,
      1.602039,
      0,
      0,
      0.935431,
      0.881424,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.341665,
      0,
      NULL,
      1.621073,
      NULL,
      NULL,
      1.720382,
      NULL,
      0,
      NULL,
      0.290355,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.829088,
      NULL,
      0.257738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.206987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.437812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616695,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.254354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867996,
      0,
      1.272228,
      NULL,
      1.823142,
      NULL,
      0.909395,
      NULL,
      NULL,
      NULL,
      1.588346,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.787433,
      1.399268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817744,
      NULL,
      NULL,
      0,
      NULL,
      1.902807,
      NULL,
      NULL,
      NULL,
      0.544626,
      NULL,
      0,
      NULL,
      3.766148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146859,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.373486,
      3.447201,
      0.401138,
      0,
      1,
      3,
      NULL,
      1,
      1,
      1.401794,
      1.587218,
      0.153551,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.137666,
      NULL,
      0.296313,
      1,
      NULL,
      NULL,
      0.376432,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.342860,
      NULL,
      1,
      1.441869,
      NULL,
      0.846228,
      0.233370,
      NULL,
      0.778846,
      NULL,
      NULL,
      3.222964,
      1,
      0.956046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.803095,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      1.461188,
      NULL,
      NULL,
      29,
      103.020780,
      NULL,
      4,
      1.674443,
      '3340',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


