set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.465254,
      NULL,
      7.841543,
      4.407738,
      3.217852,
      1,
      2,
      1.910505,
      '320',
      '21141113',
      27,
      11,
      '4123141',
      NULL,
      NULL,
      4,
      0,
      NULL,
      5,
      0.554707,
      NULL,
      NULL,
      ' 3-16-1980',
      23,
      35,
      NULL,
      3,
      NULL,
      ' 0-21-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-17-1999',
      NULL,
      NULL,
      1.332689,
      3.826203,
      NULL,
      1.750171,
      2,
      NULL,
      1,
      6.826923,
      9,
      4.925575,
      0.383315,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911294,
      1,
      NULL,
      0.566480,
      0.330628,
      NULL,
      0.386416,
      1.616205,
      1.716835,
      1,
      1,
      0.031415,
      0.108814,
      0,
      NULL,
      2,
      NULL,
      0.644145,
      3,
      0,
      0.835170,
      1.789574,
      4,
      2.874143,
      0.644408,
      0.365416,
      0,
      6.340907,
      0,
      5.521256,
      NULL,
      NULL,
      1,
      0,
      1.383532,
      1,
      NULL,
      NULL,
      1.702692,
      NULL,
      NULL,
      6.818387,
      0,
      1,
      2.803891,
      0.409702,
      0,
      3,
      1.559201,
      1.881685,
      2.041368,
      1.992125,
      NULL,
      2,
      1.785187,
      1,
      1,
      NULL,
      1.782504,
      0,
      4,
      3,
      NULL,
      0.309653,
      NULL,
      2.833265,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.575206,
      4,
      NULL,
      0,
      NULL,
      0.146602,
      1.756476,
      0.556400,
      1,
      3,
      NULL,
      0,
      1,
      0.841817,
      1.642073,
      1.261199,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.607656,
      5,
      NULL,
      1,
      NULL,
      1,
      0.415871,
      0,
      3,
      0,
      5.187983,
      NULL,
      0,
      10.251639,
      1.611794,
      NULL,
      NULL,
      7,
      5.453270,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      ' 6- 6-2000',
      31,
      ' 4-11-1974',
      31.918607,
      1.442958,
      2,
      2.597579,
      NULL,
      3.436571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335320,
      1,
      0.610137,
      3.857444,
      1,
      1,
      NULL,
      0.437804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.347382,
      0.311837,
      0.884618,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.111879,
      1.471790,
      NULL,
      NULL,
      NULL,
      0.412290,
      7,
      NULL,
      5,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908157,
      4,
      1.064565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768605,
      1.889164,
      0,
      2,
      1,
      0,
      0,
      0.869391,
      NULL,
      2,
      1.877181,
      NULL,
      NULL,
      NULL,
      2.280099,
      1,
      2,
      3.860891,
      0,
      2.671620,
      3,
      3.274461,
      2.984101,
      3,
      0,
      0.092658,
      NULL,
      0,
      0.584957,
      NULL,
      0,
      0,
      0.294215,
      1.262227,
      1,
      NULL,
      1.011349,
      0.126878,
      1.708387,
      NULL,
      1,
      1.879946,
      1.371227,
      2.400881,
      NULL,
      0.359051,
      1,
      9.598042,
      2.575573,
      NULL,
      11,
      2.294352,
      4,
      0.564753,
      5,
      3,
      1.322647,
      0.040688,
      NULL,
      4,
      1.218206,
      28,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      NULL,
      '22141',
      '2410',
      1.441487,
      '',
      '',
      '',
      NULL,
      '1434',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      0.257718,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.724644,
      0.062138,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.719024,
      NULL,
      0.438393,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.654080,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409750,
      3.883806,
      0,
      2.635999,
      2,
      0.425134,
      2,
      1.992241,
      1.096721,
      NULL,
      2.100837,
      0,
      2.342186,
      6,
      0,
      3.678477,
      1,
      NULL,
      NULL,
      NULL,
      0.025573,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203226,
      1.434642,
      0,
      NULL,
      NULL,
      1.043647,
      NULL,
      NULL,
      2.887906,
      0,
      0,
      3.364437,
      0.650043,
      1,
      1.298489,
      0,
      1.661464,
      2.200806,
      1.131310,
      2,
      2,
      0,
      1,
      1.643445,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.752336,
      NULL,
      NULL,
      3.736372,
      1.777191,
      0.280534,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.436215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.408523,
      NULL,
      0,
      NULL,
      NULL,
      1,
      7.248443,
      5.267966,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      4.137548,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.343105,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.345310,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0.562499,
      2,
      1.825890,
      4.162024,
      2.555694,
      2.236693,
      NULL,
      1,
      1.502993,
      NULL,
      NULL,
      2.556648,
      3,
      2.931403,
      2.514674,
      2.183784,
      1,
      2.537533,
      8,
      NULL,
      2,
      2,
      0,
      1.701742,
      0,
      0,
      0,
      3.797611,
      NULL,
      1.631745,
      NULL,
      2,
      NULL,
      0.842391,
      3,
      4.563318,
      0,
      5.685648,
      NULL,
      0.173556,
      NULL,
      NULL,
      0.636894,
      NULL,
      1.692728,
      0.438848,
      3.983136,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.841198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772745,
      NULL,
      NULL,
      1.111232,
      NULL,
      NULL,
      6.911198,
      NULL,
      NULL,
      1.029107,
      1.424434,
      1,
      0,
      1.286937,
      NULL,
      0.555128,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328705,
      NULL,
      NULL,
      NULL,
      1.837531,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.959952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8.780876,
      NULL,
      NULL,
      NULL,
      1.378934,
      NULL,
      2.316974,
      0,
      1,
      0.946503,
      1,
      1,
      NULL,
      1,
      0.852269,
      NULL,
      NULL,
      0,
      1.766857,
      0.167908,
      0,
      NULL,
      NULL,
      0.034032,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.590587,
      NULL,
      0.881153,
      0,
      1.175246,
      1,
      1.492682,
      0,
      0,
      1.007168,
      3,
      0,
      0.405073,
      0.158568,
      1,
      0,
      1.150641,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.538512,
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      0,
      7,
      NULL,
      1.448210,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.887445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.618376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051166,
      NULL,
      1,
      NULL,
      1.315225,
      1.534708,
      0.901243,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.141775,
      NULL,
      0.368823,
      NULL,
      NULL,
      NULL,
      0,
      0.792792,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.062314,
      0.872961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614353,
      NULL,
      0.136601,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0.949323,
      NULL,
      0.485501,
      NULL,
      1,
      1.770110,
      3.296687,
      8,
      17.420589,
      1,
      NULL,
      NULL,
      NULL,
      0.344365,
      NULL,
      NULL,
      NULL,
      3.193534,
      2.086973,
      4,
      1.677970,
      6.176394,
      0.063624,
      0,
      1.799570,
      2,
      1,
      3.196795,
      1.091622,
      0.247780,
      1.730707,
      1.659687,
      1.174704,
      1.640850,
      1,
      1,
      NULL,
      2.051990,
      0,
      NULL,
      NULL,
      0.420353,
      0,
      1,
      0.817009,
      1.245988,
      NULL,
      1.110656,
      NULL,
      NULL,
      0,
      0.149837,
      2.446618,
      1.725259,
      3,
      1.595784,
      1,
      0,
      1,
      2,
      0.644457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.747275,
      2.291404,
      2,
      2.305011,
      1,
      1,
      1.895695,
      3,
      3.029132,
      3.861035,
      1,
      3.085979,
      NULL,
      2.480589,
      2.890530,
      1,
      NULL,
      0,
      3.338177,
      NULL,
      NULL,
      1,
      1,
      1,
      11.530162,
      0.808337,
      NULL,
      0,
      NULL,
      3.717625,
      1,
      1,
      1,
      NULL,
      9,
      1.877648,
      2.694218,
      NULL,
      3,
      35,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      '00324',
      '02433',
      1,
      '',
      NULL,
      NULL,
      2.178330,
      '2040',
      NULL,
      '');
commit;
end;
/


