set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9130391';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '0004202',
      NULL,
      NULL,
      4,
      2,
      '0414',
      1.843769,
      1,
      NULL,
      NULL,
      '10-18-1991',
      15.488434,
      NULL,
      2.403060,
      0,
      NULL,
      ' 1-27-1989',
      NULL,
      3.578013,
      239,
      85,
      2.907496,
      ' 4-28-1989',
      '11-10-1985',
      ' 6- 7-2001',
      0,
      3.521288,
      2.570748,
      1.405888,
      0,
      NULL,
      3.827471,
      1,
      NULL,
      4.115198,
      NULL,
      NULL,
      0.746906,
      NULL,
      2.067347,
      4,
      9,
      NULL,
      5,
      1.286344,
      0.524293,
      NULL,
      0.542260,
      0,
      NULL,
      1.553357,
      1,
      NULL,
      0,
      NULL,
      0,
      2,
      0.382186,
      NULL,
      0.285519,
      0,
      NULL,
      1.741840,
      0,
      1.813465,
      0,
      0,
      NULL,
      1.421559,
      0.206220,
      1.233101,
      1.215916,
      0.935865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.869214,
      1.637004,
      1.571140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.506580,
      1.218893,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.813642,
      5.432621,
      5.676081,
      0.979859,
      1,
      5.143559,
      7.096334,
      NULL,
      3.850661,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.300577,
      9.239658,
      2.420425,
      0,
      NULL,
      2.584610,
      3,
      5.177670,
      3.187625,
      4.375503,
      NULL,
      7.446569,
      7.923675,
      7,
      1,
      5.495012,
      0,
      NULL,
      2,
      NULL,
      7.324912,
      11,
      NULL,
      7,
      5.247135,
      3,
      2,
      '10- 7-1976',
      NULL,
      ' 0-25-1979',
      37.956856,
      0,
      2.756241,
      1,
      4.999814,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838344,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      0,
      1.964597,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803469,
      3.585294,
      1.036711,
      1,
      0.873560,
      0.777778,
      0.938205,
      3,
      68.884032,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.149728,
      NULL,
      1.809362,
      3.951969,
      2,
      1.910235,
      0.201268,
      NULL,
      2,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      4.823796,
      NULL,
      82.503214,
      83,
      NULL,
      51,
      0.368560,
      0,
      1.287758,
      NULL,
      NULL,
      NULL,
      0.484448,
      18,
      8.234672,
      1,
      7.508676,
      4.920242,
      1.561630,
      0,
      7,
      NULL,
      2,
      3,
      5,
      2.696570,
      NULL,
      2.246918,
      57,
      1.658774,
      0,
      NULL,
      NULL,
      24,
      NULL,
      1.833300,
      5,
      2.001417,
      '23401',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0.363658,
      NULL,
      NULL,
      '',
      3,
      33.470449,
      NULL,
      NULL,
      0.737126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819152,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852278,
      NULL,
      NULL,
      0,
      3.227179,
      NULL,
      1.726101,
      NULL,
      NULL,
      3.183651,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831658,
      NULL,
      NULL,
      1.563406,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.694544,
      NULL,
      NULL,
      4.235143,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397224,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583179,
      NULL,
      NULL,
      NULL,
      NULL,
      2.025290,
      NULL,
      1,
      2.557407,
      0,
      NULL,
      NULL,
      NULL,
      1.555871,
      3,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      7.507508,
      NULL,
      2,
      1.219851,
      NULL,
      NULL,
      0.496802,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.949463,
      NULL,
      NULL,
      0.200971,
      NULL,
      NULL,
      NULL,
      2,
      0.517220,
      3,
      2.289275,
      2.092851,
      9.610785,
      4.187542,
      4.128960,
      8,
      2,
      NULL,
      4.946867,
      3,
      3,
      NULL,
      3.827791,
      0,
      2,
      NULL,
      3,
      0,
      0,
      1,
      3.380107,
      5,
      5.550454,
      1,
      3,
      0,
      NULL,
      2.499376,
      3.792802,
      NULL,
      2,
      0,
      2.404180,
      3.016765,
      1,
      0,
      10.761423,
      NULL,
      8,
      NULL,
      0.160862,
      1,
      2.703736,
      3.649732,
      0,
      0,
      0.318528,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.838530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079988,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.191478,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.316216,
      0,
      0.540241,
      NULL,
      1.520616,
      2,
      0,
      NULL,
      NULL,
      1.535787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.855018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.510898,
      NULL,
      NULL,
      NULL,
      1.078608,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.618449,
      NULL,
      8,
      0.392732,
      1.671322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.582446,
      NULL,
      0,
      57.005095,
      0,
      0,
      0.085007,
      0.534059,
      1,
      0.989490,
      1.044947,
      NULL,
      1,
      1,
      1,
      0.437739,
      0.541356,
      0.511450,
      1,
      1.288976,
      1.312055,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.502488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1.425968,
      1.821930,
      2.116011,
      15,
      3.519804,
      2,
      1.903546,
      NULL,
      1.481610,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440950,
      1,
      NULL,
      0.889641,
      1.100077,
      NULL,
      2.506010,
      3,
      NULL,
      1,
      2.425545,
      NULL,
      0,
      2.396125,
      NULL,
      2.228688,
      3.882096,
      NULL,
      1,
      0,
      NULL,
      1,
      0.945189,
      NULL,
      1,
      3,
      NULL,
      2,
      1,
      1.692654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.753761,
      NULL,
      1.939235,
      NULL,
      NULL,
      5.698040,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.526601,
      0.427973,
      '22434',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.171574,
      '',
      '',
      '');
commit;
end;
/


