set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332012';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '1333440',
      3.116593,
      NULL,
      3,
      0,
      '4134',
      0.640514,
      1,
      NULL,
      NULL,
      ' 3-17-1984',
      40.364341,
      NULL,
      4,
      2,
      1.012085,
      ' 9-16-1997',
      NULL,
      0,
      179.651646,
      154.071193,
      1.860369,
      NULL,
      '10- 6-1977',
      ' 5-16-1986',
      NULL,
      0,
      2,
      0.728027,
      0.907795,
      0,
      3,
      NULL,
      0,
      381.380649,
      1.588968,
      4,
      5,
      23.322634,
      19.915858,
      0,
      0.125932,
      2.158759,
      NULL,
      0,
      0.244944,
      NULL,
      NULL,
      0,
      0,
      1.556197,
      1,
      0,
      0.389115,
      1,
      0,
      0.496218,
      NULL,
      0.373756,
      1,
      NULL,
      1,
      NULL,
      3.490207,
      0,
      1,
      1.115896,
      1,
      1.446221,
      NULL,
      1,
      NULL,
      4,
      1,
      0.068886,
      1.908682,
      0.709846,
      1.186867,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1.589368,
      1.278621,
      3.953836,
      1,
      1.952846,
      2,
      1.133723,
      1.933009,
      3,
      1,
      0.709622,
      3,
      NULL,
      3.732040,
      1.661294,
      1,
      0.771400,
      NULL,
      0.594980,
      0,
      NULL,
      1,
      0.293019,
      3.898417,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      3.051017,
      0,
      8.004355,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0.465321,
      1,
      0.637346,
      1.181154,
      0.318294,
      1,
      1.790466,
      3,
      NULL,
      0.500987,
      0,
      0.620043,
      1.481067,
      1,
      1,
      0,
      0.914927,
      1.964701,
      0.709096,
      1,
      5.400735,
      1,
      5.191978,
      1.189262,
      0,
      2.921407,
      1,
      NULL,
      6,
      NULL,
      NULL,
      8,
      3.983881,
      1,
      1,
      1.473464,
      3.681755,
      ' 1-22-2002',
      NULL,
      ' 7-21-1982',
      1509,
      1.561925,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644583,
      0,
      0.692766,
      NULL,
      0.656025,
      0.106988,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739331,
      5.446937,
      4.903260,
      7.894542,
      4.820815,
      3.775058,
      NULL,
      0.961551,
      NULL,
      2,
      1.376671,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877855,
      1.769871,
      1.621866,
      0.160747,
      0.167755,
      1,
      NULL,
      3.456064,
      14.966656,
      NULL,
      2.746286,
      NULL,
      NULL,
      181,
      1.158672,
      NULL,
      1,
      0,
      1.029749,
      1,
      1.059322,
      0.607820,
      1,
      0,
      0.305656,
      1.971691,
      NULL,
      NULL,
      1.477587,
      NULL,
      1,
      1.486102,
      1.664676,
      0,
      1,
      1.297874,
      1.727128,
      0,
      1.785226,
      0,
      0.875715,
      0.620454,
      NULL,
      0.447553,
      2,
      NULL,
      NULL,
      NULL,
      2.941457,
      7.383637,
      NULL,
      NULL,
      3.662727,
      0.717236,
      NULL,
      0,
      2,
      0,
      58,
      0.769658,
      1,
      NULL,
      46.556385,
      39,
      51,
      NULL,
      NULL,
      0,
      '12423',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      3.932427,
      13,
      352.031753,
      8.531552,
      3,
      16.488677,
      191,
      152.014632,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.051764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.572756,
      NULL,
      NULL,
      5.732442,
      NULL,
      5,
      1.510315,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693884,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.811549,
      NULL,
      NULL,
      NULL,
      0.399773,
      NULL,
      NULL,
      NULL,
      0.393398,
      1.297389,
      1.647785,
      NULL,
      1.570061,
      NULL,
      0.242272,
      0.355468,
      2,
      0,
      2.583110,
      2,
      1,
      NULL,
      2,
      0.112986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.156653,
      NULL,
      1,
      4,
      1,
      6,
      1,
      0.512847,
      NULL,
      NULL,
      NULL,
      1.871405,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381259,
      NULL,
      3.312867,
      1,
      0.051874,
      2.493534,
      1,
      0,
      0,
      NULL,
      NULL,
      9.637569,
      5,
      1,
      NULL,
      NULL,
      NULL,
      0.574135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.417700,
      NULL,
      NULL,
      1.662412,
      NULL,
      NULL,
      1.993019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.692713,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.248073,
      NULL,
      NULL,
      1.016624,
      NULL,
      NULL,
      0.727760,
      0,
      0,
      0,
      NULL,
      NULL,
      0.594929,
      5,
      3,
      NULL,
      2.600105,
      1.875006,
      NULL,
      NULL,
      NULL,
      0.566446,
      0.615719,
      1,
      0.076958,
      NULL,
      1.745429,
      NULL,
      5,
      1,
      1,
      NULL,
      NULL,
      1,
      3.386922,
      7,
      0,
      0,
      1.669653,
      1.059948,
      1,
      0.122051,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.787812,
      NULL,
      0.400838,
      1,
      0,
      3.581219,
      1.506529,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987177,
      NULL,
      NULL,
      NULL,
      1.135284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.447136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.558345,
      14,
      2,
      2.848800,
      NULL,
      233.850370,
      367,
      2.702390,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      9.811074,
      9,
      0.963204,
      NULL,
      NULL,
      2.364256,
      70,
      NULL,
      2879.005121,
      34,
      0.239955,
      0,
      0,
      NULL,
      0.821396,
      1.224389,
      0,
      0,
      1,
      1,
      1.940839,
      1,
      0,
      1.634473,
      0,
      NULL,
      0.401662,
      1.597384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042167,
      1.734880,
      2.316444,
      9,
      3,
      9.989829,
      0,
      4,
      15,
      2.889914,
      3,
      1.577577,
      NULL,
      1,
      NULL,
      0.084990,
      0,
      NULL,
      1.493707,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.354960,
      NULL,
      NULL,
      2.129795,
      3,
      NULL,
      1.706790,
      NULL,
      NULL,
      2.530757,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377000,
      NULL,
      0.258338,
      NULL,
      7.018930,
      7.428043,
      1,
      2.801246,
      3.045483,
      1.826317,
      NULL,
      31,
      6.705941,
      0,
      3.304720,
      '44121',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.986885,
      '',
      '',
      '');
commit;
end;
/


