set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8135230';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '4234303',
      1,
      0,
      1,
      NULL,
      '2204',
      3.796938,
      NULL,
      1,
      1,
      '10- 3-1976',
      39,
      NULL,
      5.513255,
      1.350753,
      1.192722,
      NULL,
      NULL,
      3,
      226.740439,
      102,
      4,
      NULL,
      NULL,
      ' 0-24-1984',
      1.194595,
      1.820498,
      1.402767,
      0,
      1.019585,
      1.964690,
      2,
      2.111406,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      15.738601,
      NULL,
      0,
      9.410419,
      3,
      1.185578,
      4.630517,
      1,
      1.190260,
      NULL,
      0,
      1,
      0,
      0.067612,
      1.676465,
      0,
      1.087479,
      57,
      4.830144,
      8.165704,
      NULL,
      2,
      NULL,
      0.874229,
      1,
      NULL,
      0.407038,
      1,
      0,
      0.581891,
      1,
      0.946926,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201667,
      0.415519,
      0.044219,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.573725,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329546,
      0,
      1,
      3.598134,
      NULL,
      1,
      1.128909,
      0.688940,
      0,
      0,
      1,
      NULL,
      NULL,
      0.580999,
      NULL,
      NULL,
      1,
      1.210954,
      NULL,
      1,
      5,
      1.787029,
      5.413231,
      NULL,
      1,
      NULL,
      NULL,
      7.298818,
      6,
      NULL,
      NULL,
      2,
      6,
      4.215873,
      2.365056,
      4,
      NULL,
      4.450995,
      7,
      NULL,
      NULL,
      5.888033,
      NULL,
      NULL,
      0.889262,
      NULL,
      0.271141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.010373,
      0.961945,
      0,
      1,
      0.900201,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.216294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.203664,
      0,
      0,
      1.092976,
      0,
      0.856379,
      NULL,
      NULL,
      NULL,
      0.202224,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184811,
      3,
      0,
      0,
      NULL,
      0,
      1,
      0.321866,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.000980,
      0,
      3,
      2.997729,
      NULL,
      0,
      1.896028,
      3.852032,
      2,
      0,
      0.974190,
      3.305872,
      1.628312,
      NULL,
      0,
      3,
      NULL,
      1.383506,
      0,
      0,
      1.326712,
      NULL,
      1.273943,
      NULL,
      1.509499,
      NULL,
      0,
      1.275824,
      1,
      0,
      NULL,
      1.459828,
      8.027952,
      7,
      4.592225,
      6.641385,
      5,
      3.885633,
      3.710164,
      3,
      NULL,
      2,
      2.112709,
      NULL,
      14,
      3.379428,
      1,
      70.531176,
      NULL,
      NULL,
      NULL,
      1.201882,
      0.092983,
      NULL,
      '40212',
      '42414',
      NULL,
      NULL,
      '',
      '',
      '',
      2.244783,
      '44322',
      '',
      '',
      NULL,
      21.733946,
      181.151561,
      NULL,
      3,
      13,
      5,
      7,
      5.306068,
      0.605332,
      NULL,
      1.550900,
      0,
      NULL,
      NULL,
      0.727306,
      NULL,
      NULL,
      0,
      NULL,
      0.091106,
      0,
      NULL,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.945700,
      NULL,
      NULL,
      0.067995,
      NULL,
      NULL,
      1.666988,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.130480,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.753396,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.713435,
      2,
      0,
      3.580896,
      0.212443,
      2,
      0.014150,
      3,
      0.559326,
      NULL,
      1,
      NULL,
      2.536091,
      0,
      1,
      NULL,
      1.190247,
      NULL,
      0.731120,
      1.776835,
      NULL,
      1.028634,
      0.570487,
      0,
      3.101480,
      2,
      0.036717,
      1.056230,
      0.127505,
      NULL,
      NULL,
      0,
      2,
      1,
      3,
      1.357209,
      1.003335,
      0.653253,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.041626,
      NULL,
      0,
      2,
      3,
      1,
      NULL,
      NULL,
      8,
      9,
      4.143100,
      NULL,
      NULL,
      NULL,
      3.783777,
      0.917699,
      0.648900,
      2.009282,
      3.839137,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.910880,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.719949,
      NULL,
      NULL,
      1.524255,
      NULL,
      NULL,
      2,
      2,
      0.153984,
      NULL,
      NULL,
      NULL,
      7,
      7,
      0.062071,
      0,
      NULL,
      5,
      4.583075,
      0,
      1.319673,
      1,
      1.265516,
      NULL,
      3,
      3.951075,
      0.407293,
      0,
      2,
      0,
      4.116038,
      8.079111,
      7.042021,
      0.700719,
      2,
      0.647965,
      3.198974,
      3.521270,
      3.143989,
      0.242287,
      NULL,
      NULL,
      0,
      3.465903,
      2.932398,
      4,
      3,
      4.837030,
      3,
      5,
      NULL,
      3,
      NULL,
      7.240137,
      0.661355,
      1.982364,
      1.023839,
      1,
      NULL,
      1,
      NULL,
      NULL,
      5.168537,
      NULL,
      NULL,
      0.832185,
      NULL,
      NULL,
      0.142072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.477247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.346543,
      1,
      0,
      0.186731,
      0,
      2,
      2,
      NULL,
      NULL,
      5.577447,
      0,
      NULL,
      NULL,
      1.005393,
      2.904599,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.286801,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.824317,
      0.852700,
      NULL,
      NULL,
      0.533143,
      1.058633,
      NULL,
      NULL,
      0,
      3.331770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      18.623099,
      NULL,
      NULL,
      6.472489,
      9.192276,
      NULL,
      NULL,
      2,
      15,
      NULL,
      NULL,
      0.108244,
      NULL,
      NULL,
      NULL,
      0.579494,
      0.440211,
      NULL,
      NULL,
      1.315992,
      2,
      NULL,
      NULL,
      0,
      1.620656,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.629773,
      NULL,
      NULL,
      NULL,
      3.349174,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1.248565,
      NULL,
      NULL,
      NULL,
      1,
      6,
      17.442277,
      1.226654,
      16,
      0,
      1,
      NULL,
      NULL,
      0.247404,
      NULL,
      NULL,
      0.733109,
      1,
      0.396817,
      NULL,
      6,
      1.729522,
      1.532541,
      NULL,
      1.708391,
      362,
      4,
      0.024431,
      0,
      1.714139,
      2.666256,
      1.367066,
      3,
      0.381637,
      0.915756,
      0.556926,
      1,
      1.045897,
      0,
      0,
      3.809153,
      0,
      0.566692,
      NULL,
      2.807655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.021537,
      NULL,
      0,
      NULL,
      3.960325,
      NULL,
      22.257955,
      NULL,
      3.486135,
      2.854843,
      26.950593,
      3.090728,
      1.592655,
      NULL,
      NULL,
      0,
      NULL,
      0.366476,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.003324,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.826951,
      NULL,
      0.683642,
      NULL,
      NULL,
      NULL,
      0.497438,
      NULL,
      0.397486,
      NULL,
      1.774067,
      1,
      1.492230,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.373432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095308,
      0.328903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.026871,
      1,
      NULL,
      NULL,
      NULL,
      0.378977,
      0,
      0.231695,
      1,
      NULL,
      NULL,
      1.924307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.821153,
      0.417122,
      0.779374,
      NULL,
      NULL,
      5,
      2,
      3.668721,
      11,
      2,
      1.496861,
      1,
      0,
      0.889589,
      0.525993,
      0.398873,
      1,
      NULL,
      1.955538,
      NULL,
      0.638559,
      0.288044,
      1.154894,
      0,
      NULL,
      2,
      NULL,
      NULL,
      3,
      1.644017,
      0.400675,
      0.474828,
      0.471527,
      1,
      0,
      NULL,
      0.636933,
      1,
      1.227954,
      0.021949,
      3.286039,
      2,
      0,
      1,
      NULL,
      0,
      0.921526,
      3,
      2.171184,
      1,
      0,
      NULL,
      3.703187,
      NULL,
      2.625530,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.110623,
      NULL,
      0.216727,
      NULL,
      1,
      NULL,
      1,
      NULL,
      8,
      NULL,
      NULL,
      2.087287,
      1.537787,
      NULL,
      0,
      NULL,
      3.199012,
      NULL,
      3.394111,
      NULL,
      0.646694,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.541835,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173663,
      NULL,
      1,
      NULL,
      1.129258,
      NULL,
      NULL,
      1,
      8.661999,
      7,
      11.936074,
      3.937746,
      NULL,
      3.673879,
      NULL,
      48.316133,
      5.649001,
      1.724270,
      3,
      '04211',
      '21332',
      '',
      0.195359,
      '',
      '',
      '',
      2.109083,
      '04431',
      NULL,
      '');
commit;
end;
/


