
--Add birthhx
create or replace procedure birthhx(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('birthhx', 'birthhx', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX SECOND RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'BI118', 101, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-WORDS NO INFO');

add_assessment_score(v_id1, owner_id, owner_id, 'BI119', 102, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-SENTENCE YEAR');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BI7', 18, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX CHILD''S BIRTH DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'BI112', 95, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BIRTH DEFECTS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI113', 96, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-WALKED YEAR');

add_assessment_score(v_id1, owner_id, owner_id, 'BI110', 93, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX NON-PRESCRIPT. BEFORE PREGNANCY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI111', 94, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX MEMBER OF A MULTIPLE BIRTH');

add_assessment_score(v_id1, owner_id, owner_id, 'BI116', 99, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-WORDS YEAR');

add_assessment_score(v_id1, owner_id, owner_id, 'BI4', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX RELATIONSHIP OF INFORMANT');

add_assessment_score(v_id1, owner_id, owner_id, 'BI114', 97, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-WALKED MONTH');

add_assessment_score(v_id1, owner_id, owner_id, 'BI115', 98, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-WALKED NO INFO');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'BI38', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX AVE/DAY ALCOHOL DURING PREG.');

add_assessment_score(v_id1, owner_id, owner_id, 'BI39', 50, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX CAFFEINE DURING PREGNANCY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI36', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX AVE/DAY CIGARETTES DURING PREG.');

add_assessment_score(v_id1, owner_id, owner_id, 'BI37', 48, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX ALCOHOL DURING PREGNANCY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI34', 45, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX MEDS TO PREVENT WEIGHT GAIN');

add_assessment_score(v_id1, owner_id, owner_id, 'BI35', 46, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX CIGARETTES DURING PREGNANCY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI32', 43, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX MEDS FOR HIGH BLOOD PRESSURE');

add_assessment_score(v_id1, owner_id, owner_id, 'BI33', 44, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX MEDS TO PREVENT MISCARRIAGE');

add_assessment_score(v_id1, owner_id, owner_id, 'BI30', 41, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX MEDS FOR MORNING SICKNESS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI31', 42, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX MEDS FOR PAIN');

add_assessment_score(v_id1, owner_id, owner_id, 'BI70', 81, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX FEVER/ILL BEFORE 12 MONTHS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI71', 82, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX INFECTION/ILL BEFORE 12 MONTHS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI127', 110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-SENTENCE AGE');

add_assessment_score(v_id1, owner_id, owner_id, 'BI29', 40, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX X-RAYS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI125', 108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-WALKED AGE');

add_assessment_score(v_id1, owner_id, owner_id, 'BI124', 107, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-READ NO INFO');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 10, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'BI122', 105, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-READ YEAR');

add_assessment_score(v_id1, owner_id, owner_id, 'BI121', 104, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-SENT. NO INFO');

add_assessment_score(v_id1, owner_id, owner_id, 'BI28', 39, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX EMOTIONAL PROBLEMS - OTHERS');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 9, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'BI128', 111, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-READ AGE');

add_assessment_score(v_id1, owner_id, owner_id, 'BI65', 76, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BABY REQUIRED INCUBATOR');

add_assessment_score(v_id1, owner_id, owner_id, 'BI64', 75, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BABY REQUIRED BLOOD TRANSFUSION');

add_assessment_score(v_id1, owner_id, owner_id, 'BI67', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BREAST FED FOR HOW LONG? (mo)');

add_assessment_score(v_id1, owner_id, owner_id, 'BI66', 77, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BREAST FED');

add_assessment_score(v_id1, owner_id, owner_id, 'BI61', 72, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BABY HAD CONVULSIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI60', 71, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BABY DID NOT BREATHE AT FIRST');

add_assessment_score(v_id1, owner_id, owner_id, 'BI63', 74, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BABY REQUIRED OXYGEN');

add_assessment_score(v_id1, owner_id, owner_id, 'BI62', 73, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BABY HAD JAUNDICE');

add_assessment_score(v_id1, owner_id, owner_id, 'BI21', 32, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX RH INCOMPATIBILITY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI20', 31, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"BIRTHHX SEIZURE, CONVULSIONS"');

add_assessment_score(v_id1, owner_id, owner_id, 'BI23', 34, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DIABETES MELLITUS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI22', 33, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX RUEBELLA (GERMAN MEASLES)');

add_assessment_score(v_id1, owner_id, owner_id, 'BI69', 80, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BOTTLE FED FOR HOW LONG? (mo)');

add_assessment_score(v_id1, owner_id, owner_id, 'BI68', 79, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BOTTLE FED');

add_assessment_score(v_id1, owner_id, owner_id, 'BI27', 38, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX EMOTIONAL PROBLEMS - DEPRESSION');

add_assessment_score(v_id1, owner_id, owner_id, 'BI26', 37, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX EMOTIONAL PROBLEMS - ANXIETY');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX FIRST ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX SECOND ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'TYPE', 7, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX TYPE OF INTERVIEW');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 1, 'Proband/Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 2, 'Informant', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 3, 'Consensus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 4, 'Blind', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 5, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 6, 'Consensus II', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BI130', 113, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DELAYED VERBAL SKILLS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI131', 114, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX RELIABILITY OF RECALL OF EVENTS');
add_assessment_code(v_id1, owner_id, owner_id, 'BI131', 0, 'ERROR', 'varchar');
add_assessment_code(v_id1, owner_id, owner_id, 'BI131', 1, 'Very Good', 'varchar');
add_assessment_code(v_id1, owner_id, owner_id, 'BI131', 2, 'Good', 'varchar');
add_assessment_code(v_id1, owner_id, owner_id, 'BI131', 3, 'Fair', 'varchar');
add_assessment_code(v_id1, owner_id, owner_id, 'BI131', 4, 'Poor', 'varchar');
add_assessment_code(v_id1, owner_id, owner_id, 'BI131', 5, 'Essentially no information', 'varchar');

add_assessment_score(v_id1, owner_id, owner_id, 'BI126', 109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-WORDS AGE');

add_assessment_score(v_id1, owner_id, owner_id, 'BI25', 36, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX SERIOUS INJURY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI24', 35, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX ANEMIA');

add_assessment_score(v_id1, owner_id, owner_id, 'BI105', 88, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX AVE/DAY ALCOHOL BEFORE PREG.');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 15, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DATE FORM WAS DONE');

add_assessment_score(v_id1, owner_id, owner_id, 'BI123', 106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-READ MONTH');

add_assessment_score(v_id1, owner_id, owner_id, 'BI10', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BIRTH WEIGHT OF BABY - POUNDS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI11', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BIRTH WEIGHT OF BABY - OUNCES');

add_assessment_score(v_id1, owner_id, owner_id, 'BI12', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX NUMBER OF PRIOR MISCARRIAGES');

add_assessment_score(v_id1, owner_id, owner_id, 'BI13', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX NUMBER OF PRIOR STILL BIRTHS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI14', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BIRTH ORDER OF THIS CHILD');

add_assessment_score(v_id1, owner_id, owner_id, 'BI15', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX NUMBER OF CHILDREN BORN LIVING');

add_assessment_score(v_id1, owner_id, owner_id, 'BI16', 27, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BLEEDING FROM THE VAGINA');

add_assessment_score(v_id1, owner_id, owner_id, 'BI17', 28, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX PREMATURE CONTRACTIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI18', 29, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"BIRTHHX SWELLING OF FACE, HANDS, ANKLES"');

add_assessment_score(v_id1, owner_id, owner_id, 'BI19', 30, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX HIGH BLOOD PRESSURE (TOX.)');

add_assessment_score(v_id1, owner_id, owner_id, 'BI120', 103, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-SENTENCE MONTH');

add_assessment_score(v_id1, owner_id, owner_id, 'BI117', 100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DEVELOP LANDMARKS-WORDS MONTH');

add_assessment_score(v_id1, owner_id, owner_id, 'BI104', 87, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX ALCOHOL BEFORE PREGNANCY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI58', 69, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BABY WAS BLUE AT BIRTH');

add_assessment_score(v_id1, owner_id, owner_id, 'BI59', 70, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BABY HAD SLOW HEART BEAT');

add_assessment_score(v_id1, owner_id, owner_id, 'BI54', 65, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX TYPE OF DELIVERY: BREECH');

add_assessment_score(v_id1, owner_id, owner_id, 'BI55', 66, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX TYPE OF DELIVERY: FORCEPS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI56', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX LENGTH OF LABOR (HOURS)');

add_assessment_score(v_id1, owner_id, owner_id, 'BI57', 68, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX CORD AROUND NECK OF BABY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI50', 61, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX TYPE OF DELIVERY: VAGINAL');

add_assessment_score(v_id1, owner_id, owner_id, 'BI51', 62, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX TYPE OF DELIVERY: CAESAREAN');

add_assessment_score(v_id1, owner_id, owner_id, 'BI52', 63, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DELIVERY: GENERAL ANESTHESIA');

add_assessment_score(v_id1, owner_id, owner_id, 'BI53', 64, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DELIVERY: LOCAL ANESTHESIA');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'BI3', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX FAMILY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'BI109', 92, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX NON-PRESCRIPT. DURING PREGNANCY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI108', 91, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX MARIJUANA BEFORE PREGNANCY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI129', 112, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DELAYED MOTOR SKILLS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI8', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX AGE OF MOTHER AT BIRTH');

add_assessment_score(v_id1, owner_id, owner_id, 'BI9', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX AGE OF FATHER AT BIRTH');

add_assessment_score(v_id1, owner_id, owner_id, 'BI101', 84, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX MEDS FOR PSYCHIATRIC PROBLEMS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI100', 83, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX OTHER SERIOUS MEDICAL ILLNESS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI103', 86, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX AVE/DAY CIGARETTES BEFORE PREG.');

add_assessment_score(v_id1, owner_id, owner_id, 'BI102', 85, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX CIGARETTES BEFORE PREGNANCY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI2', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX TYPE OF FAMILY STUDY SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'BI107', 90, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX AVE/DAY CAFFEINE BEFORE PREG.');

add_assessment_score(v_id1, owner_id, owner_id, 'BI1', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX FAMILY STUDY SUBJECT?');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'BI106', 89, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX CAFFEINE BEFORE PREGNANCY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI49', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX NUMBER OF WEEKS LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'BI48', 59, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX LATE DELIVERY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI47', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX NUMBER OF WEEKS EARLY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI46', 57, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX PREMATURE DELIVERY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI45', 56, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX OTHER DRUGS');

add_assessment_score(v_id1, owner_id, owner_id, 'BI44', 55, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX MARIJUANA DURING PREGNANCY');

add_assessment_score(v_id1, owner_id, owner_id, 'BI43', 54, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX THYROID');

add_assessment_score(v_id1, owner_id, owner_id, 'BI42', 53, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX VALIUM');

add_assessment_score(v_id1, owner_id, owner_id, 'BI41', 52, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX HORMONES');

add_assessment_score(v_id1, owner_id, owner_id, 'BI40', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIRTHHX AVE/DAY CAFFEINE DURING PREG.');

commit;
END;
/
