set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'birthhx';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_birthhx_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '421',
      '31',
      6,
      14.869555,
      '1132011',
      2.337649,
      3,
      3,
      '3034332',
      3.787641,
      0,
      NULL,
      NULL,
      1.360738,
      ' 3- 2-1980',
      57,
      NULL,
      '10- 2-1991',
      9,
      38.712387,
      8.277493,
      4.086847,
      1,
      NULL,
      NULL,
      2.853942,
      NULL,
      '3',
      '1',
      '3',
      NULL,
      NULL,
      '4',
      '3',
      '4',
      '2',
      '4',
      '0',
      NULL,
      '0',
      '3',
      '0',
      '4',
      '3',
      '3',
      NULL,
      27,
      '3',
      NULL,
      '1',
      NULL,
      '4',
      '4',
      NULL,
      '2',
      NULL,
      NULL,
      9,
      '0',
      NULL,
      '1',
      NULL,
      NULL,
      '3',
      NULL,
      '0',
      14.782582,
      '0',
      '2',
      '3',
      '1',
      '3',
      '2',
      '1',
      NULL,
      '0',
      '1',
      NULL,
      '1',
      0,
      '0',
      '1',
      '3',
      '0',
      '4',
      4.132762,
      NULL,
      NULL,
      NULL,
      13.087656,
      NULL,
      '0',
      '0',
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      3.887256,
      0,
      '',
      9,
      NULL,
      '',
      1,
      2.923296,
      1,
      4,
      '3',
      '4',
      '2');
commit;
end;
/


