set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'birthhx';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9803061';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_birthhx_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '423',
      '04423023',
      NULL,
      44,
      '0004230',
      NULL,
      3,
      2,
      '4403132',
      NULL,
      0.335412,
      NULL,
      NULL,
      2,
      ' 7-10-1999',
      226,
      101.434967,
      ' 0-15-1998',
      41.322839,
      30,
      NULL,
      NULL,
      1.444571,
      1,
      NULL,
      3.392119,
      '4',
      '3',
      NULL,
      '1',
      '3',
      NULL,
      '4',
      NULL,
      '2',
      NULL,
      '3',
      '1',
      '3',
      '3',
      '2',
      '3',
      '3',
      NULL,
      '2',
      '2',
      NULL,
      '1',
      NULL,
      '1',
      2,
      '1',
      '2',
      NULL,
      '1',
      '0',
      '0',
      NULL,
      '0',
      2.230075,
      '3',
      NULL,
      '3',
      NULL,
      '4',
      '0',
      8.609962,
      '0',
      '0',
      '0',
      NULL,
      '2',
      '1',
      '0',
      '4',
      '0',
      '4',
      NULL,
      '0',
      15,
      '2',
      '4',
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      3.227565,
      '3',
      NULL,
      '0',
      '3',
      '2',
      '3',
      '1',
      0,
      6.822315,
      '',
      0.923455,
      0,
      '',
      2,
      13.746438,
      '',
      NULL,
      0.250331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL);
commit;
end;
/


