set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'birthhx';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7404860';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_birthhx_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '31',
      10.920678,
      NULL,
      '2304344',
      2.028245,
      3,
      1,
      '0320333',
      3.545911,
      NULL,
      NULL,
      NULL,
      3,
      '11- 9-1985',
      47,
      80,
      NULL,
      37.988544,
      28.393905,
      NULL,
      14.536358,
      NULL,
      1.751872,
      8.789427,
      13,
      '4',
      NULL,
      '2',
      '2',
      '1',
      '4',
      '3',
      '1',
      '4',
      '2',
      '2',
      '1',
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      18,
      '2',
      NULL,
      '2',
      5,
      '4',
      '3',
      '2',
      '4',
      '3',
      '1',
      1,
      '2',
      NULL,
      NULL,
      '0',
      '3',
      '2',
      '2',
      NULL,
      6,
      '2',
      NULL,
      '1',
      '1',
      NULL,
      '0',
      NULL,
      '4',
      '0',
      '2',
      NULL,
      '1',
      NULL,
      '3',
      '3',
      '3',
      '1',
      '3',
      6.982436,
      '2',
      NULL,
      '2',
      1,
      NULL,
      '3',
      '1',
      '0',
      NULL,
      1,
      22.792410,
      '',
      0.546840,
      15,
      '',
      2.055234,
      0,
      NULL,
      10.634283,
      0,
      '',
      NULL,
      3.941179,
      0.093897,
      10.144555,
      NULL,
      '1',
      '4');
commit;
end;
/


