
--Add brief
create or replace procedure brief(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('brief', 'brief', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'WEEK', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF WEEK NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'USG', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF URINE SPECIFIC GRAVITY');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'BR15', 28, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF SUSPICIOUSNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'BR15', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR15', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR15', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR15', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR15', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR15', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR15', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR15', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR9', 22, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF GUILT FEELINGS');
add_assessment_code(v_id1, owner_id, owner_id, 'BR9', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR9', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR9', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR9', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR9', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR9', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR9', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR9', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR8', 21, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF CONCEPTUAL DISORGANIZATION');
add_assessment_code(v_id1, owner_id, owner_id, 'BR8', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR8', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR8', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR8', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR8', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR8', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR8', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR8', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR7', 20, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF EMOTIONAL WITHDRAWAL');
add_assessment_code(v_id1, owner_id, owner_id, 'BR7', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR7', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR7', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR7', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR7', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR7', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR7', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR7', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR6', 19, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF ANXIETY');
add_assessment_code(v_id1, owner_id, owner_id, 'BR6', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR6', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR6', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR6', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR6', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR6', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR6', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR6', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR5', 18, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF SOMATIC CONCERN');
add_assessment_code(v_id1, owner_id, owner_id, 'BR5', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR5', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR5', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR5', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR5', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR5', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR5', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR5', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'BR13', 26, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF DEPRESSIVE MOOD');
add_assessment_code(v_id1, owner_id, owner_id, 'BR13', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR13', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR13', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR13', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR13', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR13', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR13', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR13', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR12', 25, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF GRANDIOSITY');
add_assessment_code(v_id1, owner_id, owner_id, 'BR12', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR12', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR12', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR12', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR12', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR12', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR12', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR12', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR11', 24, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF MANNERISMS AND POSTURING');
add_assessment_code(v_id1, owner_id, owner_id, 'BR11', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR11', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR11', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR11', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR11', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR11', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR11', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR11', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR10', 23, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF TENSION');
add_assessment_code(v_id1, owner_id, owner_id, 'BR10', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR10', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR10', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR10', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR10', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR10', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR10', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR10', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR17', 30, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF MOTOR RETARDATION');
add_assessment_code(v_id1, owner_id, owner_id, 'BR17', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR17', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR17', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR17', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR17', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR17', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR17', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR17', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 9, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR14', 27, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF HOSTILITY');
add_assessment_code(v_id1, owner_id, owner_id, 'BR14', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR14', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR14', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR14', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR14', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR14', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR14', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR14', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 12, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF INTERVIEW DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'BR19', 32, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF UNUSUAL THOUGHT CONTENT');
add_assessment_code(v_id1, owner_id, owner_id, 'BR19', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR19', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR19', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR19', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR19', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR19', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR19', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR19', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR18', 31, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF UNCOOPERATIVENESS');
add_assessment_code(v_id1, owner_id, owner_id, 'BR18', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR18', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR18', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR18', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR18', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR18', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR18', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR18', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR22', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF DISORIENTATION');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'BR20', 33, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF BLUNTED AFFECT');
add_assessment_code(v_id1, owner_id, owner_id, 'BR20', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR20', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR20', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR20', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR20', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR20', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR20', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR20', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR21', 34, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF EXCITEMENT');
add_assessment_code(v_id1, owner_id, owner_id, 'BR21', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR21', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR21', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR21', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR21', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR21', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR21', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR21', 7, 'Very severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'MED', 16, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF MEDICATION STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 0, 'No medication', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 1, 'Medication', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF FIRST DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF SECOND DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'DRUGSTAT', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF PATIENT STATUS');

add_assessment_score(v_id1, owner_id, owner_id, 'PROC', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF PROCEDURE CODE');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 0, 'Weekly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 1, 'Xenon -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 2, 'Xenon -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 3, 'IMP -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 4, 'IMP -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 5, 'HMPAO -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 6, 'HMPAO -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 7, 'DI-SPECT -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 8, 'DI-SPECT -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 9, 'Behavioral -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 10, 'Behavioral -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 11, 'PET/150 H2O -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 12, 'Pet/150 H2O -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 13, 'Thalamus', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BR16', 29, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BRIEF HALLUCINATORY BEHAVIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'BR16', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR16', 1, 'Not reported', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR16', 2, 'Very mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR16', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR16', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR16', 5, 'Moderately severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR16', 6, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BR16', 7, 'Very severe', 'integer');

commit;
END;
/
