
--Add calgary
create or replace procedure calgary(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('calgary', 'calgary', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'WEEK', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY WEEK NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'USG', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY URINE SPECIFIC GRAVITY');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'CL12', 25, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY SUICIDE');
add_assessment_code(v_id1, owner_id, owner_id, 'CL12', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL12', 1, 'Mild: frequent thought of being better off dead', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL12', 2, 'Moderate: deliberately considered suicide with a plan', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL12', 3, 'Severe: suicidal attempt apparently designed to end in death', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CL13', 26, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY OBSERVED DEPRESSION');
add_assessment_code(v_id1, owner_id, owner_id, 'CL13', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL13', 1, 'Mild: subject appears sad and mournfull even during parts of the interview', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL13', 2, 'Moderate: subject appears sad and mournfull throughout the interview', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL13', 3, 'Severe: subject chokes on distressing topics, sighs deeply and cries openl', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'CL11', 24, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY EARLY WAKENING');
add_assessment_code(v_id1, owner_id, owner_id, 'CL11', 0, 'Absent: no early wakening', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL11', 1, 'Mild: occasionally wakes (twice weekly) 1 hour before normal time', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL11', 2, 'Moderate: often wakes (up to 5 times/week) 1 hour before normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL11', 3, 'Severe: daily wakes 1 hour or more before normal time.', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CL10', 23, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY MORNING DEPRESSION');
add_assessment_code(v_id1, owner_id, owner_id, 'CL10', 0, 'Absent: no depression', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL10', 1, 'Mild: depression present but no diurnal variation', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL10', 2, 'Moderate: depression spontaniously mentioned to be worse in the a.m.', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL10', 3, 'Severe: depression markedly worse in the a.m. improving in the p.m.', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 9, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CL5', 18, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY DEPRESSION');
add_assessment_code(v_id1, owner_id, owner_id, 'CL5', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL5', 1, 'Mild: expresses some sadness on questioning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL5', 2, 'Moderate: distinct depressed mood upto half time over 2 weeks', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL5', 3, 'Severe: distinct depressed mood 1/2+ time daily', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 12, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY INTERVIEW DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'MED', 16, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"CALGARY MEDICATION STATUS(0=NOMED,1=MED)"');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 0, 'No medication', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 1, 'Medication', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY FIRST DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY SECOND DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'CL8', 21, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY GUILTY IDEAS OF REFERENCE');
add_assessment_code(v_id1, owner_id, owner_id, 'CL8', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL8', 1, 'Mild: subject feels blamed but not accused less than 50% of the time', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL8', 2, 'Moderate: persisting sense of being blamed, and/or accused', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL8', 3, 'Severe: persistent sense of being accused.', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CL9', 22, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY PATHOLOGICAL GUILT');
add_assessment_code(v_id1, owner_id, owner_id, 'CL9', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL9', 1, 'Mild: subject feels over guilty less than 50% of the time', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL9', 2, 'Moderate: subject feels guilty over past actions more than 50% of the time', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL9', 3, 'Severe: subject feels s/he is to blame for everything that has gone wrong', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DRUGSTAT', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY DRUG STATUS AT INTAKE');

add_assessment_score(v_id1, owner_id, owner_id, 'CL6', 19, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY HOPELESSNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'CL6', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL6', 1, 'Mild: has at times felt hopeless over last week but has hope for future', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL6', 2, 'Moderate: persistent, moderate sense of hopelessness over last week', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL6', 3, 'Severe: persisting and distressing sense of hopelessness.', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CL7', 20, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY SELF DEPRECIATION');
add_assessment_code(v_id1, owner_id, owner_id, 'CL7', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL7', 1, 'Mild: some inferiority; not amounting to feeling of worthlessness', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL7', 2, 'Moderate: subject feels worthless less then 50% of the time', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CL7', 3, 'Severe: subject feels worthless more that 50% of the time', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PROC', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CALGARY PROCEDURE CODE');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 0, 'Weekly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 1, 'Xenon -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 2, 'Xenon -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 3, 'IMP -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 4, 'IMP -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 5, 'HMPAO -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 6, 'HMPAO -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 7, 'DI-SPECT -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 8, 'DI-SPECT -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 9, 'Behavioral -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 10, 'Behavioral -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 11, 'PET/150 H2O -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 12, 'Pet/150 H2O -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 13, 'Thalamus', 'integer');

commit;
END;
/
