
--Add calgary
create or replace procedure add_calgary_value(
experiment_ID_in number, visit_ID_in number,
segment_ID_in number, owner_id_in number, subject_id_in varchar2,
time_stamp_in TIMESTAMP,
BATCHNUM varchar2,
DOCNUM varchar2,
ENT1 float,
ENT2 float,
ID varchar2,
ASS float,
WEEK float,
PROC integer,
REL integer,
FRM varchar2,
VER float,
DATE varchar,
RATER float,
RATER2 float,
DRUGSTAT float,
MED integer,
USG float,
CL5 integer,
CL6 integer,
CL7 integer,
CL8 integer,
CL9 integer,
CL10 integer,
CL11 integer,
CL12 integer,
CL13 integer)
is
  v_assessment_ID number;
  v_stored_A_ID number;
  v_rc number;

BEGIN

   v_assessment_ID := get_assessment_id('calgary');

   if owner_id_in < 0 then
      Raise_application_error(-20113,'ERROR: v_owner_id_in < 0');
   end if;

   if v_assessment_ID < 0 then
      Raise_application_error(-20113,'ERROR: v_assessment_ID < 0');
   end if;

   if experiment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: experiment_ID_in < 0');
   end if;

   if visit_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: visit_ID_in < 0');
   end if;

   if segment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: segment_ID_in < 0');
   end if;

   v_stored_A_ID := add_stored_assessment(v_assessment_ID, owner_id_in, owner_id_in,
     visit_ID_in, experiment_ID_in, segment_ID_in, subject_id_in, time_stamp_in, subject_id_in, 'self');

-- adding data
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'BATCHNUM', 'varchar', 1, NULL, batchnum, NULL, batchnum, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'WEEK', 'float', 7, week, to_char(week), week, to_char(week), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'USG', 'float', 17, usg, to_char(usg), usg, to_char(usg), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER2', 'float', 14, rater2, to_char(rater2), rater2, to_char(rater2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CL12', 'integer', 25, cl12, to_char(cl12), cl12, to_char(cl12), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CL13', 'integer', 26, cl13, to_char(cl13), cl13, to_char(cl13), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FRM', 'varchar', 10, NULL, frm, NULL, frm, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CL11', 'integer', 24, cl11, to_char(cl11), cl11, to_char(cl11), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CL10', 'integer', 23, cl10, to_char(cl10), cl10, to_char(cl10), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER', 'float', 13, rater, to_char(rater), rater, to_char(rater), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'REL', 'integer', 9, rel, to_char(rel), rel, to_char(rel), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CL5', 'integer', 18, cl5, to_char(cl5), cl5, to_char(cl5), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DATE', 'timestamp', 12, NULL, date, NULL, date, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'VER', 'float', 11, ver, to_char(ver), ver, to_char(ver), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ID', 'varchar', 5, NULL, id, NULL, id, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ASS', 'float', 6, ass, to_char(ass), ass, to_char(ass), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'MED', 'integer', 16, med, to_char(med), med, to_char(med), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DOCNUM', 'varchar', 2, NULL, docnum, NULL, docnum, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENT1', 'float', 3, ent1, to_char(ent1), ent1, to_char(ent1), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENT2', 'float', 4, ent2, to_char(ent2), ent2, to_char(ent2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CL8', 'integer', 21, cl8, to_char(cl8), cl8, to_char(cl8), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CL9', 'integer', 22, cl9, to_char(cl9), cl9, to_char(cl9), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DRUGSTAT', 'float', 15, drugstat, to_char(drugstat), drugstat, to_char(drugstat), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CL6', 'integer', 19, cl6, to_char(cl6), cl6, to_char(cl6), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CL7', 'integer', 20, cl7, to_char(cl7), cl7, to_char(cl7), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROC', 'integer', 8, proc, to_char(proc), proc, to_char(proc), NULL, '', NULL, 0, 0, subject_id_in, 0);
EXCEPTION
   WHEN OTHERS THEN
      dbms_output.put_line('add_calgary_value for subject: ' || subject_id_in || ' failed!');
      raise;

commit;
END;
/
