
--Add cash
create or replace procedure cash(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('cash', 'cash', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'CA240', 260, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: TD - AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'CA490', 511, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH FRIENDS/PEERS - MUCH OF TIM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA491', 512, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH GLOBAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA918', 939, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS IN/HYPER SOMNIA: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA315', 336, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: # HOSP. IN PAST TWO YEARS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA315', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA315', 1, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA315', 2, 'Infrequent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA315', 3, 'Intermittently', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA315', 4, 'Several', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA315', 5, 'Majority', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA314', 335, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: TOTAL DURATION OF HOSPITAL (mo)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA317', 338, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - PERSECUTORY - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA316', 337, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - PERSECUTORY - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA311', 332, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PREVIOUS PSYCH HOSPITALIZATION?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA310', 331, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AGE AT FIRST OUTPATIENT CARE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA313', 334, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: # PREVIOUS HOSPITALIZATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA312', 333, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AGE AT FIRST HOSPITALIZATION');

add_assessment_score(v_id1, owner_id, owner_id, 'CA319', 340, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - JEALOUSY - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA318', 339, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - PERSECUT - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA930', 951, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS LOSS OF PLEASURE: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA498', 519, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PATTERN OF SYMPTOMS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA498', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA498', 1, 'Positive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA498', 2, 'Negative', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA498', 3, 'Pos/Neg', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA498', 4, 'Neg/Pos', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA702', 723, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL # HOSPITALIZATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA703', 724, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL TOLERANCE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA700', 721, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL OUTPATIENT TREATMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA499', 520, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PATTERN OF SEVERITY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA499', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA499', 1, 'Episodic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA499', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA499', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA499', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA706', 727, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL TREMORS: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA707', 728, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL NAUSEA: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA704', 725, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL TOLERANCE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA705', 726, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL TREMORS: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA708', 729, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL NAUSEA: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA709', 730, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL MALAISE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA171', 191, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: INCREASED TALKATIVENESS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA171', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA171', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA171', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA171', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA171', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA171', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA170', 190, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: INCREASE IN ACTIVITY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA170', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA170', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA170', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA170', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA170', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA170', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA173', 193, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: INFLATED SELF-ESTEEM');
add_assessment_code(v_id1, owner_id, owner_id, 'CA173', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA173', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA173', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA173', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA173', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA173', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA172', 192, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: RACING THOUGHTS/FLIGHT OF IDEAS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA172', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA172', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA172', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA172', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA172', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA172', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA175', 195, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DISTRACTIBILITY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA175', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA175', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA175', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA175', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA175', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA175', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA174', 194, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DECREASED NEED FOR SLEEP');
add_assessment_code(v_id1, owner_id, owner_id, 'CA174', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA174', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA174', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA174', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA174', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA174', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA177', 197, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING OF MANIC BEHAVIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA176', 196, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: POOR JUDGMENT');
add_assessment_code(v_id1, owner_id, owner_id, 'CA176', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA176', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA176', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA176', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA176', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA176', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA179', 199, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: # SYMPTOMS RATED 3 OR MORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA178', 198, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: EUPHORIC MOOD RATED 3 OR MORE?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA95', 115, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: SOMATIC/TACTILE HALLUCINATIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA95', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA95', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA95', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA95', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA95', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA95', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA278', 298, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - ATTENTION: SERIAL 7s');

add_assessment_score(v_id1, owner_id, owner_id, 'CA279', 299, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - ATTENTION: WORLD BACKWAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA276', 296, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - ORIENTATION: PLACE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA277', 297, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - REGISTRATION');

add_assessment_score(v_id1, owner_id, owner_id, 'CA274', 294, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: IS SUBJECT AN INFORMANT?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA275', 295, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - ORIENTATION: DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA272', 292, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - OTHER LEFT/MIXED');

add_assessment_score(v_id1, owner_id, owner_id, 'CA273', 293, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - FAMILY HANDEDNESS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA270', 290, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # MIXED DAUGHTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA271', 291, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - SPOUSES HANDEDNES');
add_assessment_code(v_id1, owner_id, owner_id, 'CA271', 0, 'No Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA271', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA271', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA271', 3, 'Mixed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA727', 748, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL AMNESTIC SYN: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA817', 838, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ SUBSTANCE USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA638', 659, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD # EPISODES COL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA639', 660, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD SUICIDE GESTURES/ATTEMPTS?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA636', 657, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD # SX COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA637', 658, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD # EPISODES COL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA634', 655, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD # SX COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA635', 656, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD # SX COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA632', 653, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD THOUGHTS OF DEATH: COL 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA633', 654, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD # SX COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA630', 651, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD THOUGHTS OF DEATH: COL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA631', 652, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD THOUGHTS OF DEATH: COL 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA910', 931, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO INAPP LAUGHING: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA811', 832, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HALL IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA224', 244, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH DEPRESS. DATE OF FULL SYND. ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'CA819', 840, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ PATHOLOGICAL USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA683', 704, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL PATHOLOGICAL USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA682', 703, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL PATHOLOG USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA528', 549, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA INCREASE TALK: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA529', 550, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA INCREASE TALK: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA687', 708, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL ABSENT FROM WORK: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA686', 707, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL ABSENT FROM WORK: CUR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA685', 706, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL VIOLENCE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA684', 705, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL VIOLENCE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA522', 543, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA IMPAIRMENT: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'TYPE', 16, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH TYPE OF SUBJECT');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 1, 'Proband/Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 2, 'Informant', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 3, 'Consensus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 4, 'Blind', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 5, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 6, 'Consensus II', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA520', 541, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA EXPANSIVE NATURE: COL 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA521', 542, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA IMPAIRMENT: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA526', 547, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA INCREASE ACT: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA527', 548, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA INCREASE TALK: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA524', 545, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA INCREASE ACT: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA525', 546, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA INCREASE ACT: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA40', 60, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LIVES WITH MATE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA40', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA40', 1, 'Married', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA40', 2, 'Liv Hetero', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA40', 3, 'Liv Homo', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA41', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LIVES WITH CHILDREN 0-5 YEARS OLD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA42', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LIVES WITH CHILDREN 6-12 YEARS OLD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA43', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LIVES WITH CHILDREN 13-18 YRS OLD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA44', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LIVES WITH CHILDREN 18 YRS &''||'' OLDER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA45', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LIVES WITH BROTHERS/SISTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA46', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LIVES WITH OTHER RELATIVES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA47', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LIVES WITH FRIENDS OR OTHERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA48', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LIVES WITH OTHERS IN HALFWAY HOUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA49', 69, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH TYPE OF DWELLING');
add_assessment_code(v_id1, owner_id, owner_id, 'CA49', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA49', 1, 'House', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA49', 2, 'Appartment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA49', 3, 'Rooming House', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA49', 4, 'Halfway House', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA49', 5, 'Dorm', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA49', 6, 'Transient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA49', 7, 'Institutionalized', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA49', 8, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA49', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA823', 844, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ DUR OF IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA822', 843, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ DUR OF IMPAIRMENT: CUR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA821', 842, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA820', 841, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ IMPAIRMENT: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA826', 847, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ TOLERANCE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA825', 846, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ # EPISODES OF ABUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA824', 845, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ CURRENTLY ABUSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA939', 960, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS PESSIMISTIC FUTURE: RESIDUA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA829', 850, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ DEPENDENCE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA828', 849, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ DEPENDENCE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA925', 946, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS PRODUCTIVIEY: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 17, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH RELIABILITY CODE');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA677', 698, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL BLACKOUTS: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA359', 380, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - WITH AFFECTIVE CLEARING');

add_assessment_score(v_id1, owner_id, owner_id, 'CA358', 379, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - MOOD INCONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA454', 475, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALOG POV SPEECH - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA455', 476, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALOG POV CONTENT - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA452', 473, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALOG POV SPEECH - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA453', 474, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALOG POV SPEECH - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA450', 471, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT GLOBAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA451', 472, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT GLOBAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA351', 372, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - THGHT WITH - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA350', 371, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - THGHT WITH - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA353', 374, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - GLOBAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA352', 373, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - GLOBAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA355', 376, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - SENSORIUM WHILE DELUSIONA');
add_assessment_code(v_id1, owner_id, owner_id, 'CA355', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA355', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA355', 2, 'Definite Physical', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA355', 3, 'Definite Not Physical', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA354', 375, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - GLOBAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA458', 479, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALOG GLOBAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA459', 480, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALOG GLOBAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA957', 978, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: GAS PAST YEAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA419', 440, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - REP/STEREO - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA955', 976, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FUNCTION PAST 5 YEARS: MOSTLIFE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA954', 975, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FUNCTION PAST 5 YEARS: CRITERIA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA953', 974, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FUNCTION PAST 5 YEARS: SOCIAL');
add_assessment_code(v_id1, owner_id, owner_id, 'CA953', 0, 'No Info', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA953', 1, 'Supperb', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA953', 2, 'Very Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA953', 3, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA953', 4, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA953', 5, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA953', 6, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA953', 7, 'Inadequate', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA952', 973, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FUNCTION PAST 5 YEARS: OVERALL');
add_assessment_code(v_id1, owner_id, owner_id, 'CA952', 0, 'No Info', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA952', 1, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA952', 2, 'Slight', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA952', 3, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA952', 4, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA952', 5, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA952', 6, 'Major', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA898', 919, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO PEOPLE SEEKING: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA899', 920, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO PEOPLE SEEKING: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA896', 917, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO CREATIVE THINKING: PREMORB');

add_assessment_score(v_id1, owner_id, owner_id, 'CA897', 918, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO CREATIVE THINKING: RESIDUA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA894', 915, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO PRODUCTIVITY: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA895', 916, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO PRODUCTIVITY: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA892', 913, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO INFLATED ESTEEM: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA893', 914, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO INFLATED ESTEEM: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA890', 911, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO INCREASED ENERGY: PREMORBI');

add_assessment_score(v_id1, owner_id, owner_id, 'CA891', 912, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO INCREASED ENERGY: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA710', 731, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL MALAISE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA679', 700, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL EXACERBAT ILLNESS: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA967', 988, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AXIS II DIAGNOSES-2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA232', 252, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: TREATMENT - ANXIOLYTICS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA233', 253, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: TREATMENT - LITHIUM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA230', 250, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: TREATMENT - ANTIDEP (HETEROCYC)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA231', 251, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: TREATMENT - ANTIDEP (MAO INHIB)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA236', 256, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HOSPITALIZED?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA237', 257, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION OF HOSPITALIZATION');

add_assessment_score(v_id1, owner_id, owner_id, 'CA234', 254, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: TREATMENT - TEGRETOL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA235', 255, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: TREATMENT - ECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA441', 462, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT - WAXY - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA238', 258, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: OUTPATIENT TREATMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA239', 259, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: SYMPTOMS OF TARDIVE DYSKINESIA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA329', 350, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - RELIGIOUS - FIRST YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA84', 104, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: FAMILIAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA905', 926, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO PHYSICAL RESTLESS: RESIDUA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA85', 105, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: UNFAMILIAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA86', 106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: CRITICAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA87', 107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: COMPLIMENTARY');

add_assessment_score(v_id1, owner_id, owner_id, 'CA373', 394, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES HEARD? - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA372', 393, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - AUD: CONVERSE-MUCH OF TIM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA672', 693, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL BINGES: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA673', 694, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL BINGES: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA670', 691, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL EFFORTS TO STOP: CURREN');

add_assessment_score(v_id1, owner_id, owner_id, 'CA671', 692, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL EFFORTS TO STOP: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA676', 697, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL BLACKOUTS: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA82', 102, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: MALE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA674', 695, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL CONSUMED FIFTH: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA675', 696, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL CONSUMED FIFTH: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA320', 341, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - JEALOUSY - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA678', 699, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL EXACERBAT ILLNESS: CUR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA83', 103, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: FEMALE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA321', 342, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - JEALOUSY - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA773', 794, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC # EPISODES OF ABUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA779', 800, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC CRIT FOR DEPEND: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA701', 722, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL INPATIENT TREATMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 23, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH DATE FORM WAS FILLED OUT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA772', 793, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC CURRENTLY ABUSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA771', 792, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC DUR OF IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA770', 791, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC DUR OF IMPAIRMENT: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA777', 798, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC WITHDRAWAL: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA776', 797, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC WITHDRAWAL: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA775', 796, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC TOLERANCE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA774', 795, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC TOLERANCE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA287', 307, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - TOTAL SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA286', 306, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - COPY DESIGN');

add_assessment_score(v_id1, owner_id, owner_id, 'CA285', 305, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - WRITE A SENTENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA284', 304, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - CLOSE YOUR EYES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA283', 303, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - LANG: 3-STAGE COMMAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA282', 302, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - LANGUAGE: IFS ANDS BUTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA128', 148, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING OF CATATONIA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA280', 300, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - RECALL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA126', 146, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CATATONIA POSTURING/MANNERISMS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA127', 147, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: POSTURING/MANNERISMS DUE TO TD?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA124', 144, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CATATONIA WAXY FLEXIBILITY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA124', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA124', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA124', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA125', 145, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CATATONIA EXCITEMENT');
add_assessment_code(v_id1, owner_id, owner_id, 'CA125', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA125', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA125', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA122', 142, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CATATONIA STUPOR');
add_assessment_code(v_id1, owner_id, owner_id, 'CA122', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA122', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA122', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA123', 143, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CATATONIA RIGIDITY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA123', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA123', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA123', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA289', 309, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GAS - IS SUBJECT HOSPITALIZED?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA288', 308, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - LEVEL OF CONSCIOUSNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA288', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA288', 1, 'Alert', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA288', 2, 'Drowsy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA288', 3, 'Stupor', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA481', 502, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH REC INTEREST - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA480', 501, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH REC INTERESTS - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA483', 504, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH SEXUAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA482', 503, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH SEXUAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA485', 506, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH INTIMACY - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA484', 505, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH SEXUAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA19', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SOURCE (WARD STAFF)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA486', 507, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH INTIMACY - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA489', 510, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH FRIENDS/PEERS - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA16', 36, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH DISCHARGE DATE FROM HOSPITAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA15', 35, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH ADMISSION DATE INTO HOSPITAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA14', 34, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PSYCHIATRIC TREATMENT STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA14', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA14', 1, 'Inpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA14', 2, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA14', 3, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA14', 4, 'Nonpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA14', 5, 'Outpatient/Day Tx', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA13', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH WEIGHT (kg.)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA12', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH HEIGHT (cm.)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA11', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SEX');

add_assessment_score(v_id1, owner_id, owner_id, 'CA10', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH AGE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA884', 905, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AFF PERS SYN: COL 2 APPLICABLE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA478', 499, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL GLOBAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA570', 591, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD ANXIOUS NATURE: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA693', 714, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL ARGUMENTS: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA9', 29, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH BIRTHDATE OF SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA8', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH RELATIONSHIP OF INFORMANT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA281', 301, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MMSE - LANGUAGE: PENCIL/WATCH');

add_assessment_score(v_id1, owner_id, owner_id, 'CA3', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH FAMILY STUDY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA2', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH FAMILY STUDY TYPE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA1', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH INVOLVED IN FAMILY STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'CA129', 149, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: POVERTY OF SPEECH');
add_assessment_code(v_id1, owner_id, owner_id, 'CA129', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA129', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA129', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA129', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA129', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA129', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA7', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH MEDICATION STATUS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA6', 26, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SUBJECT STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA6', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA6', 1, 'Normal Control', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA6', 2, 'Neuroleptic Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA6', 3, 'Neuroleptic Non-Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA6', 4, 'Almost Neuroleptic Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA6', 5, 'Totally Psychoactive Drug Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA6', 6, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA938', 959, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS PESSIMISTIC FUTURE: PREMORB');

add_assessment_score(v_id1, owner_id, owner_id, 'CA193', 213, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CHANGE IN APPETITE OR WEIGHT');
add_assessment_code(v_id1, owner_id, owner_id, 'CA193', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA193', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA193', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA193', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA193', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA193', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA192', 212, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: NATURE OF MOOD: ANXIOUS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA191', 211, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: NATURE OF MOOD: DYSPHORIC');

add_assessment_score(v_id1, owner_id, owner_id, 'CA190', 210, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION OF DYSPHORIA (WEEKS)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA197', 217, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: WEIGHT LOSS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA196', 216, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DECREASED APPETITE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA195', 215, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: WEIGHT GAIN');

add_assessment_score(v_id1, owner_id, owner_id, 'CA194', 214, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: INCREASED APPETITE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA199', 219, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: INSOMNIA/HYPERSOMNIA');
add_assessment_code(v_id1, owner_id, owner_id, 'CA199', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA199', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA199', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA199', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA199', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA199', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA198', 218, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: WEIGHT (KG.) GAINED OR LOST');

add_assessment_score(v_id1, owner_id, owner_id, 'CAXIS4C', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH AXIS IV C');

add_assessment_score(v_id1, owner_id, owner_id, 'CAXIS4B', 2, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH AXIS IV B');

add_assessment_score(v_id1, owner_id, owner_id, 'CAXIS4A', 1, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH AXIS IV A');

add_assessment_score(v_id1, owner_id, owner_id, 'CAXIS4G', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH AXIS IV G');

add_assessment_score(v_id1, owner_id, owner_id, 'CA421', 442, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - REP/STEREO - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CAXIS4E', 5, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH AXIS IV E');

add_assessment_score(v_id1, owner_id, owner_id, 'CAXIS4D', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH AXIS IV D');

add_assessment_score(v_id1, owner_id, owner_id, 'CA904', 925, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO PHYSICAL RESTLESS: PREMORB');

add_assessment_score(v_id1, owner_id, owner_id, 'CA470', 491, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL IMPERSIS - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA906', 927, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO MORE TALKATIVE: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CAXIS4H', 8, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH AXIS IV H');

add_assessment_score(v_id1, owner_id, owner_id, 'CA900', 921, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO HYPERSEXUALITY: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA901', 922, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO HYPERSEXUALITY: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA902', 923, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO INVOLVED PLEASURE: PREMORB');

add_assessment_score(v_id1, owner_id, owner_id, 'CA578', 599, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD WEIGHT GAIN: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA399', 420, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - GLOBAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA398', 419, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - GLOBAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA395', 416, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VISION - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA394', 415, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - OLFACTORY - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA397', 418, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VISION - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA121', 141, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING OF POSITIVE FTD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA391', 412, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - SOMATIC - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA390', 411, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - SOMATIC - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA393', 414, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - OLFACTORY - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA392', 413, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - OLFACTORY - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA553', 574, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD COLUMN 1 APPLICABLE?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA552', 573, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD CRITERIA - SYMPTOMS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA551', 572, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD CRITERIA - IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA550', 571, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD CRITERIA - MOOD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA557', 578, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD MOOD - COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA556', 577, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD COLUMN 4 APPLICABLE?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA555', 576, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD COLUMN 3 APPLICABLE?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA554', 575, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD COLUMN 2 APPLICABLE?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA412', 433, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - CLOTH/APPE - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA413', 434, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - SOC/SEXUAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA559', 580, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD MOOD - COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA411', 432, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - CLOTH/APPE - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA416', 437, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - AGG/AGIT   - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA417', 438, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - AGG/AGIT   - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA414', 435, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - SOC/SEXUAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA415', 436, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - SOC/SEXUAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA429', 450, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FTD - PRES SPEECH - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA428', 449, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FTD - PRES SPEECH - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA903', 924, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO INVOLVED PLEASURE: RESIDUA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA612', 633, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD PSYCHO RETARDATION: COL 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA613', 634, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD LOSS OF INTEREST: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA306', 327, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AXIS III DIAGNOSES-3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA307', 328, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PREVIOUS PSYCHIATRIC PROBLEM?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA304', 325, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AXIS III DIAGNOSES-1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA305', 326, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AXIS III DIAGNOSES-2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA302', 323, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AXIS II DIAGNOSES-3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA303', 324, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: NUMBER OF AXIS III DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA300', 321, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AXIS II DIAGNOSES-1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA301', 322, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AXIS II DIAGNOSES-2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA308', 329, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'CA309', 330, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: NUMBER OF MONTHES SINCE ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'CA867', 888, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH ODD SPEECH: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA866', 887, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH ODD SPEECH: PRODROMAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA865', 886, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH ODD SPEECH: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA864', 885, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH SOCIAL ANXIETY: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA863', 884, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH SOCIAL ANXIETY: PRODROMAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA862', 883, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH SOCIAL ANXIETY: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA861', 882, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH WEIRD PERCEPTUAL: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA860', 881, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH WEIRD PERCEPTUAL: PRODROMAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA869', 890, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH SOCIAL ISOLATION: PRODROMAL');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH RATER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA739', 760, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB DUR OF IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA738', 759, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB DUR OF IMPAIRMENT: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA737', 758, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA736', 757, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB IMPAIRMENT: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA735', 756, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB PATHOLOGICAL USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA734', 755, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB PATHOLOGICAL USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA733', 754, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB SUBSTANCE USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA732', 753, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB SUBSTANCE USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA731', 752, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DRUG EVIDENCE OF USE/DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA730', 751, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL PHYSICAL COMP: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA162', 182, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: ROLE OF ORGANIC FACTORS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA162', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA162', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA162', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA163', 183, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CURRENT SYMPTOM FACTORS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA163', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA163', 1, 'Positive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA163', 2, 'Negative', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA163', 3, 'Mixed Hi', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA163', 4, 'Mixed Lo', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA160', 180, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: REMAINS IN SYNDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA161', 181, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: ROLE OF PRECIPITANTS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA161', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA161', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA161', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA166', 186, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION OF EUPHORIA (WEEKS)');
add_assessment_code(v_id1, owner_id, owner_id, 'CA166', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA166', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA166', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA166', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA166', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA166', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA167', 187, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: NATURE OF MOOD: EUPHORIC');
add_assessment_code(v_id1, owner_id, owner_id, 'CA167', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA167', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA167', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA167', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA167', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA167', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA164', 184, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: EUPHORIC MOOD');
add_assessment_code(v_id1, owner_id, owner_id, 'CA164', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA164', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA164', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA164', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA164', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA164', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA165', 185, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION OF EUPHORIA (DAYS)');
add_assessment_code(v_id1, owner_id, owner_id, 'CA165', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA165', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA165', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA165', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA165', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA165', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA168', 188, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: NATURE OF MOOD: IRRITABLE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA168', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA168', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA168', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA168', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA168', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA168', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA169', 189, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: NATURE OF MOOD: EXPANSIVE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA169', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA169', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA169', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA169', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA169', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA169', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA558', 579, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD MOOD - COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA249', 269, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - HOLDING KNIFE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA249', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA249', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA249', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA249', 3, 'Either', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA248', 268, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - SWINGING A CLUB');
add_assessment_code(v_id1, owner_id, owner_id, 'CA248', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA248', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA248', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA248', 3, 'Either', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA487', 508, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH INTIMACY - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA243', 263, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - CONSIDER YOURSELF');
add_assessment_code(v_id1, owner_id, owner_id, 'CA243', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA243', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA243', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA243', 3, 'Mixed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA242', 262, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION OF NEUROLEPTICS PRE-TD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA241', 261, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION OF TD SX (MONTHS)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA18', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SOURCE (INTERVIEW WITH SUBJECT)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA247', 267, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - THROWING A BALL');
add_assessment_code(v_id1, owner_id, owner_id, 'CA247', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA247', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA247', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA247', 3, 'Either', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA246', 266, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - WRITING');
add_assessment_code(v_id1, owner_id, owner_id, 'CA246', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA246', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA246', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA246', 3, 'Either', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA245', 265, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HAND - RIGHT FOR MOST ACTIVITIE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA244', 264, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - FORCED CHANGE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA17', 37, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH ENTRY INTO STUDY DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA488', 509, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH FRIENDS/PEERS - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA929', 950, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS SOCIAL WITHDRAWAL: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA609', 630, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD PSYCHO RETARDATION: COL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA608', 629, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD PSYCHOMOTOR AGITATION: COL4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA603', 624, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD HYPERSOMNIA: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA602', 623, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD HYPERSOMNIA: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA601', 622, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD HYPERSOMNIA: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA600', 621, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - TERMINAL: COL 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA607', 628, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD PSYCHOMOTOR AGITATION: COL3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA606', 627, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD PSYCHOMOTOR AGITATION: COL2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA605', 626, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD PSYCHOMOTOR AGITATION: COL1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA604', 625, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD HYPERSOMNIA: COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA97', 117, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VISUAL HALLUCINATIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA97', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA97', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA97', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA97', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA97', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA97', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA680', 701, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL NONBEVERAGE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA763', 784, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS CRITERIA FOR DEPEN: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA96', 116, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: OLFACTORY HALLUCINATIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA96', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA96', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA96', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA96', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA96', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA96', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA517', 538, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA IRRITABLE NATURE: COL 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA516', 537, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA IRRITABLE NATURE: COL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA515', 536, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA IRRITABLE NATURE: COL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA514', 535, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA EUPHORIC NATURE: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA513', 534, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA EUPHORIC NATURE: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA512', 533, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA EUPHORIC NATURE: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA511', 532, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA MOOD DURATION: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA510', 531, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA MOOD DURATION: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA523', 544, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA IMPAIRMENT: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA519', 540, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA EXPANSIVE NATURE: COL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA518', 539, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA EXPANSIVE NATURE: COL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA698', 719, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL AGE DRINKING BEGAN');

add_assessment_score(v_id1, owner_id, owner_id, 'CA699', 720, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL AGE DRINKING STOPPED');

add_assessment_score(v_id1, owner_id, owner_id, 'CA694', 715, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL DURATION (mo): CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA695', 716, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL DURATION (mo): PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA696', 717, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL CURRENTLY ABUSES?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA697', 718, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL TOTAL # EPISODES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA690', 711, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL LEGAL DIFFICULTIES: CUR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA691', 712, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL LEGAL DIFFICULTIES:PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA692', 713, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL ARGUMENTS: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 13, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SUBJECT ID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA53', 73, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: PERSECUTORY DELUSIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA53', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA53', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA53', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA53', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA53', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA53', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA52', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CURRENT SECTION APPLICABLE?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA51', 71, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SOURCE OF INCOME');
add_assessment_code(v_id1, owner_id, owner_id, 'CA51', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA51', 1, 'Employment/Retirement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA51', 2, 'Parents', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA51', 3, 'Social Security', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA51', 4, 'Aid', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA51', 5, 'Other Soc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA51', 6, 'Employment and Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA51', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA50', 70, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH FINANCIAL RESPONSIBILITY - DWELLING');
add_assessment_code(v_id1, owner_id, owner_id, 'CA50', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA50', 1, 'Self', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA50', 2, 'Parents', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA50', 3, 'Relatives', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA50', 4, 'Structured', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA50', 5, 'Unstructured', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA50', 6, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA57', 77, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: RELIGIOUS DELUSIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA57', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA57', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA57', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA57', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA57', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA57', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA55', 75, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DELUSIONS OF SIN OR GUILT');
add_assessment_code(v_id1, owner_id, owner_id, 'CA55', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA55', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA55', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA55', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA55', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA55', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA54', 74, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DELUSIONS OF JEALOUSY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA54', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA54', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA54', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA54', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA54', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA54', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA59', 79, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: IDEAS/DELUSIONS OF REFERENCE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA59', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA59', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA59', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA59', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA59', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA59', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA58', 78, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: SOMATIC DELUSIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA58', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA58', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA58', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA58', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA58', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA58', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA56', 76, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GRANDIOSE DELUSIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA56', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA56', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA56', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA56', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA56', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA56', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA935', 956, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS LESS ACTIVE: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA934', 955, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS LESS ACTIVE: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA937', 958, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS RESTLESSNESS: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA936', 957, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS RESTLESSNESS: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA838', 859, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PAS WITHDRAWAL (AGE 6-12)');
add_assessment_code(v_id1, owner_id, owner_id, 'CA838', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA838', 1, 'Some', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA838', 2, 'Timid', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA838', 3, 'Unrelated', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA839', 860, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PAS PEER RELATIONS (AGE 6-12)');
add_assessment_code(v_id1, owner_id, owner_id, 'CA839', 0, 'Many', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA839', 1, 'Few Close', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA839', 2, 'Casual', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA839', 3, 'Few Casual', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA839', 4, 'None', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA933', 954, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS IRRITABILITY: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA932', 953, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS IRRITABILITY: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA834', 855, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DRUGS EVER SOUGHT TREATMENT?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA835', 856, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DRUGS TREATED AS OUTPATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA836', 857, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DRUGS TREATED AS INPATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA837', 858, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DRUGS # OF HOSPITALIZATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA830', 851, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DRUGS CURRENTLY ABUSING ANY?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA831', 852, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DRUGS ABUSED ANY IN THE PAST?');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 18, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA833', 854, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DRUGS AGE ALL ABUSE STOPPED');

add_assessment_score(v_id1, owner_id, owner_id, 'CA463', 484, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AFF GLOBAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA462', 483, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AFF GLOBAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA461', 482, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AFF GLOBAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA460', 481, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALOG GLOBAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA467', 488, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL GROOMING - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA466', 487, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: INAPP AFF GLOBAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA465', 486, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: INAPP AFF GLOBAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA464', 485, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: INAPP AFF GLOBAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA342', 363, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - MIND READ - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA343', 364, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - THGHT BROAD - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA340', 361, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - MIND READ - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA341', 362, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - MIND READ - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA346', 367, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - THGHT INSER - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA347', 368, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - THGHT INSER - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA344', 365, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - THGHT BROAD - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA345', 366, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - THGHT BROAD - MUCH OF TIM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA940', 961, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS TEARFULNESS: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA941', 962, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS TEARFULNESS: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA942', 963, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS AGE FIRST SYMPTOMS NOTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CA943', 964, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS SX CHRONIC SINCE ONSET?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA944', 965, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS CLUSTER DURATION (mo)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA945', 966, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPOMANIA PATTERN: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA946', 967, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPOMANIA PATTERN: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA882', 903, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH HYGIENE IMPAIR: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA948', 969, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYSTHYMIA PATTERN: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA949', 970, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CYCLOTHYMIA PATTERN: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA661', 682, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX EVER HAD ECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA589', 610, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - INITIAL: COL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA209', 229, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: FEELINGS OF WORTHLESSNESS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA208', 228, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: LOSS OF ENERGY');

add_assessment_score(v_id1, owner_id, owner_id, 'CA207', 227, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: LOSS OF INTEREST/PLEASURE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA206', 226, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: PSYCHOMOTOR RETARDATION');

add_assessment_score(v_id1, owner_id, owner_id, 'CA205', 225, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: PSYCHOMOTOR AGITATION');

add_assessment_score(v_id1, owner_id, owner_id, 'CA204', 224, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: TERMINAL INSOMNIA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA203', 223, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MIDDLE INSOMNIA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA202', 222, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: INITIAL INSOMNIA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA201', 221, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DECREASED AMOUNT OF SLEEP');

add_assessment_score(v_id1, owner_id, owner_id, 'CA200', 220, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: INCREASED AMOUNT OF SLEEP');

add_assessment_score(v_id1, owner_id, owner_id, 'CA666', 687, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL NEEDS DAILY: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA951', 972, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FUNCTION PAST 5 YEARS: OUTCOME');
add_assessment_code(v_id1, owner_id, owner_id, 'CA951', 0, 'No Info', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA951', 1, 'Comp Return', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA951', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA951', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA951', 4, 'Marked', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA669', 690, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL CANT CUT DOWN: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA668', 689, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL CANT CUT DOWN: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA689', 710, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL LOSS OF JOB: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA764', 785, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC SUBSTANCE USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA765', 786, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC SUBSTANCE USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA766', 787, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC PATHOLOGICAL USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA767', 788, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC PATHOLOGICAL USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA760', 781, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS WITHDRAWAL: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA566', 587, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD DYSPHORIC NATURE: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA649', 670, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX EVER HAD ANTIDEP (MAO)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA648', 669, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX DOSE YRS ANTIDEP (HETERO)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA647', 668, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX MONTHS ON ANTIDEP (HETER)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA646', 667, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX EVER HAD ANTIDEP (HETERO)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA645', 666, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX DOSE YRS NEUROLEPTICS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA644', 665, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX MONTHS ON NEUROLEPTICS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA643', 664, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX EVER HAD NEUROLEPTICS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA642', 663, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD SUICIDE THREAT TO LIFE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA642', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA642', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA642', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA642', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA642', 4, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA642', 5, 'Extreme', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA642', 6, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA641', 662, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD SUICIDE SEVERITY OF ATTEMPT');
add_assessment_code(v_id1, owner_id, owner_id, 'CA641', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA641', 1, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA641', 2, 'Not Sure', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA641', 3, 'Definate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA641', 4, 'Serious', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA641', 5, 'Very Serious', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA641', 6, 'Extreme', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA641', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA641', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA641', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA640', 661, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD SUICIDE NUMBER OF ATTEMPTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA356', 377, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - OCCUR IN MANIC SYNDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA832', 853, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DRUGS AGE FIRST ABUSE BEGAN');

add_assessment_score(v_id1, owner_id, owner_id, 'CA290', 310, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GAS - PAST MONTH OR AT ADMIT');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 1, 'Needs constant supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 2, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 3, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 4, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 9, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 10, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 11, 'Needs some supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 12, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 13, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 14, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 15, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 16, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 17, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 18, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 19, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 20, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 21, 'Unable to function in most areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 22, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 23, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 24, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 25, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 26, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 27, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 28, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 29, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 30, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 31, 'Major impairment in several areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 32, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 33, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 34, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 35, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 36, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 37, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 38, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 39, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 40, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 41, 'Serious symptomology requiring Tx', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 42, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 43, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 44, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 45, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 46, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 47, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 48, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 49, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 50, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 51, 'Moderate symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 52, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 53, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 54, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 55, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 56, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 57, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 58, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 59, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 60, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 61, 'Mild symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 62, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 63, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 64, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 65, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 66, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 67, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 68, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 69, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 70, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 71, 'Slight impairment in functioning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 72, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 73, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 74, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 75, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 76, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 77, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 78, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 79, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 80, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 81, 'Good functioning in all areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 82, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 83, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 84, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 85, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 86, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 87, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 88, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 89, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 90, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA290', 91, 'Superior functioning', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA291', 311, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GAS - AT ADMISSION');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 1, 'Needs constant supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 2, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 3, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 4, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 9, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 10, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 11, 'Needs some supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 12, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 13, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 14, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 15, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 16, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 17, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 18, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 19, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 20, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 21, 'Unable to function in most areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 22, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 23, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 24, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 25, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 26, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 27, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 28, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 29, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 30, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 31, 'Major impairment in several areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 32, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 33, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 34, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 35, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 36, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 37, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 38, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 39, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 40, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 41, 'Serious symptomology requiring Tx', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 42, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 43, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 44, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 45, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 46, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 47, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 48, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 49, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 50, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 51, 'Moderate symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 52, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 53, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 54, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 55, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 56, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 57, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 58, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 59, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 60, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 61, 'Mild symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 62, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 63, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 64, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 65, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 66, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 67, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 68, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 69, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 70, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 71, 'Slight impairment in functioning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 72, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 73, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 74, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 75, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 76, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 77, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 78, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 79, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 80, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 81, 'Good functioning in all areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 82, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 83, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 84, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 85, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 86, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 87, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 88, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 89, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 90, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA291', 91, 'Superior functioning', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA292', 312, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GAS - WORST DURING HOSPITALIZAT');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 1, 'Needs constant supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 2, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 3, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 4, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 9, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 10, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 11, 'Needs some supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 12, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 13, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 14, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 15, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 16, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 17, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 18, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 19, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 20, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 21, 'Unable to function in most areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 22, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 23, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 24, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 25, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 26, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 27, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 28, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 29, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 30, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 31, 'Major impairment in several areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 32, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 33, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 34, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 35, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 36, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 37, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 38, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 39, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 40, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 41, 'Serious symptomology requiring Tx', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 42, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 43, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 44, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 45, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 46, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 47, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 48, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 49, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 50, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 51, 'Moderate symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 52, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 53, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 54, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 55, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 56, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 57, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 58, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 59, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 60, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 61, 'Mild symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 62, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 63, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 64, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 65, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 66, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 67, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 68, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 69, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 70, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 71, 'Slight impairment in functioning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 72, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 73, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 74, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 75, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 76, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 77, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 78, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 79, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 80, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 81, 'Good functioning in all areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 82, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 83, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 84, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 85, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 86, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 87, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 88, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 89, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 90, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA292', 91, 'Superior functioning', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA118', 138, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: PRESSURE OF SPEECH');
add_assessment_code(v_id1, owner_id, owner_id, 'CA118', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA118', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA118', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA118', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA118', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA118', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA294', 314, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GAS - RELIAB OF INFO IN PART I');
add_assessment_code(v_id1, owner_id, owner_id, 'CA294', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA294', 1, 'Very Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA294', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA294', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA294', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA294', 5, 'Very Poor', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA296', 317, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AXIS I DIAGNOSES-1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA295A', 315, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CRITERIA USED FOR DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA113', 133, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DERAILMENT');
add_assessment_code(v_id1, owner_id, owner_id, 'CA113', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA113', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA113', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA113', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA113', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA113', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA112', 132, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING OF BIZARRE BEHAV');
add_assessment_code(v_id1, owner_id, owner_id, 'CA112', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA112', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA112', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA112', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA112', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA112', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA111', 131, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: RITUALISTIC OR STEREOTYPED BEH');
add_assessment_code(v_id1, owner_id, owner_id, 'CA111', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA111', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA111', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA111', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA111', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA111', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA110', 130, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AGGRESSIVE AND AGITATED BEHAV');
add_assessment_code(v_id1, owner_id, owner_id, 'CA110', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA110', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA110', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA110', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA110', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA110', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA117', 137, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CIRCUMSTANTIALITY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA117', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA117', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA117', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA117', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA117', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA117', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA116', 136, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: ILLOGICALITY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA116', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA116', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA116', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA116', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA116', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA116', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA115', 135, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: INCOHERENCE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA115', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA115', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA115', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA115', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA115', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA115', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA114', 134, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: TANGENTIALITY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA114', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA114', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA114', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA114', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA114', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA114', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA919', 940, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS IN/HYPER SOMNIA: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA492', 513, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH GLOBAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA493', 514, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH GLOBAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA28', 48, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PREVIOUS OCCUPATION');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 1, 'Maj Profession', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 2, 'Min Profession', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 3, 'Sales', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 4, 'Skilled emp', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 5, 'Unskilled emp', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 6, 'Student', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 7, 'Home', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 8, 'Unemployed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA29', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CURRENT OCCUPATION');

add_assessment_score(v_id1, owner_id, owner_id, 'CA496', 517, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ATT GLOBAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA497', 518, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OUTSIDE PSYCHOTIC EPISODE?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA494', 515, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ATT GLOBAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA495', 516, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ATT GLOBAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA22', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SOURCE (OTHER)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA23', 43, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SOURCE (RECORDS FROM OTHER INSTIT)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA20', 40, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SOURCE (HOSPITAL RECORDS)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA21', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SOURCE (INTERVIEW REL/FRIENDS)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA26', 46, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CURRENT OCCUP STATUS - RETIRED');

add_assessment_score(v_id1, owner_id, owner_id, 'CA27', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LENGTH OF UNEMPLOYMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA24', 44, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH MARITAL STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 1, 'Never', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 2, 'Married', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 3, 'Seperated', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 4, 'Divorced', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 5, 'Divorced/Remarried', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 6, 'Divorced 2+/ not married', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 7, 'Divorced 2+/ married', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 8, 'Widowed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA25', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CURRENT OCCUP STATUS - WORKING');

add_assessment_score(v_id1, owner_id, owner_id, 'CA747', 768, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB CRITERIA DEPEND: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA908', 929, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO OVERLY OPTIMISTIC: PREMORB');

add_assessment_score(v_id1, owner_id, owner_id, 'CAXIS4F', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH AXIS IV F');

add_assessment_score(v_id1, owner_id, owner_id, 'CA799', 820, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PCP PATHOLOGICAL USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA798', 819, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PCP PATHOLOGICAL USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA791', 812, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH TOLERANCE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA790', 811, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH TOLERANCE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA793', 814, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH WITHDRAWAL: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA792', 813, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH WITHDRAWAL: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA795', 816, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH CRIT FOR DEPEND: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA794', 815, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH CRIT FOR DEPEND: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA797', 818, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PCP SUBSTANCE USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA796', 817, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PCP SUBSTANCE USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA719', 740, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL DEPENDENCE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA188', 208, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DYSPHORIC MOOD');
add_assessment_code(v_id1, owner_id, owner_id, 'CA188', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA188', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA188', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA188', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA188', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA188', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA189', 209, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION OF DYSPHORIA (DAYS)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA718', 739, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL HYPOTENSION: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA184', 204, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION SINCE FULL SYNDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA185', 205, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: REMAINS IN SYNDROME?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA186', 206, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: ROLE OF PRECIPITANTS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA186', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA186', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA186', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA187', 207, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: ROLE OF ORGANIC FACTORS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA187', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA187', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA187', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA180', 200, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CRITERIA MET FOR MANIC SYNDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA181', 201, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH MANIC DATE OF 1ST SYMPTOM ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'CA182', 202, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION SINCE FIRST SYMPTOM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA183', 203, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH MANIC DATE OF FULL SYNDROME ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'CA907', 928, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO MORE TALKATIVE: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA971', 992, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AXIS III DIAGNOSES-2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA970', 991, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AXIS III DIAGNOSES-1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA972', 993, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AXIS III DIAGNOSES-3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA348', 369, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - THGHT INSER - MUCH OF TIM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA427', 448, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FTD - DIS SPEECH - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA426', 447, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FTD - DIS SPEECH - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA425', 446, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FTD - DIS SPEECH - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA424', 445, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - GLOBAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA423', 444, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - GLOBAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA422', 443, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - GLOBAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA388', 409, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: RIGHT SIDE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA389', 410, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - SOMATIC - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA386', 407, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: OUTSIDE HEAD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA387', 408, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: LEFT SIDE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA384', 405, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: ALWAYS THE SAME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA385', 406, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: INSIDE HEAD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA382', 403, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: COMMANDING');

add_assessment_score(v_id1, owner_id, owner_id, 'CA383', 404, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: MULTIPLE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA380', 401, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: CRITICAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA381', 402, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: COMPLIMENTARY');

add_assessment_score(v_id1, owner_id, owner_id, 'CA548', 569, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA # EPISODES COL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA549', 570, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA # EPISODES COL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA544', 565, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA POOR JUDGMENT: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA545', 566, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA # SX - COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA546', 567, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA # SX - COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA547', 568, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA # SX - COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA540', 561, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA DISTRACTIBILITY: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA541', 562, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA DISTRACTIBILITY: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA542', 563, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA POOR JUDGMENT: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA543', 564, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA POOR JUDGMENT: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH 1ST DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH 2ND DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'CA812', 833, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HALL DUR OF IMPAIRMENT: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA469', 490, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL GROOMING - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA805', 826, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PCP # EPIOSDES OF ABUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA804', 825, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PCP CURRENTLY ABUSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA807', 828, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HALL SUBSTANCE USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA468', 489, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL GROOMING - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA801', 822, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PCP IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA800', 821, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PCP IMPAIRMENT: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA803', 824, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PCP DUR OF IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA802', 823, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PCP DUR OF IMPAIRMENT: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA809', 830, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HALL PATHOLOGICAL USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA808', 829, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HALL PATHOLOGICAL USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA947', 968, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYSTHYMIA PATTERN: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA333', 354, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - SOMATIC - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA332', 353, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - SOMATIC - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA331', 352, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - SOMATIC - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA330', 351, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - RELIGIOUS - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA337', 358, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - BEING CONTROLLED - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA336', 357, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - OF REFER - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA335', 356, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - OF REFER - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA334', 355, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - OF REFER - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA931', 952, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS LOSS OF PLEASURE: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA339', 360, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - BEING CONT - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA338', 359, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - BEING CONTR - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA870', 891, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH SOCIAL ISOLATION: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA871', 892, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH INADEQ RAPPORT: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA872', 893, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH INADEQ RAPPORT: PRODROMAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA873', 894, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH INADEQ RAPPORT: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA874', 895, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH PECULIAR BEHAV: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA875', 896, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH PECULIAR BEHAV: PRODROMAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA876', 897, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH PECULIAR BEHAV: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA877', 898, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH ROLE IMPAIRMENT: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA878', 899, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH ROLE IMPAIRMENT: PRODROMAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA879', 900, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH ROLE IMPAIRMENT: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA728', 749, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL AMNESTIC SYN: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA729', 750, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL PHYSICAL COMP: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA720', 741, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL DEPENDENCE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA721', 742, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL WITH DELIRIUM: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA722', 743, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL WITH DELIRIUM: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA723', 744, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL WITH SEIZURES: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA724', 745, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL WITH SEIZURES: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA418', 439, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - AGG/AGIT   - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA726', 747, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL HALLUCINOSIS: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA725', 746, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL HALLUCINOSIS: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA254', 274, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HAND - CUTTING WITH SCISSORS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA254', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA254', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA254', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA254', 3, 'Either', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA255', 275, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HAND - USING NEEDLE/TWEEZERS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA255', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA255', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA255', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA255', 3, 'Either', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA256', 276, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - SUBJECTS HANDEDNES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA257', 277, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - MOTHER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA250', 270, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - HAMMERING A NAIL');
add_assessment_code(v_id1, owner_id, owner_id, 'CA250', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA250', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA250', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA250', 3, 'Either', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA251', 271, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - TURNING SCREWDRIVE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA251', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA251', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA251', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA251', 3, 'Either', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA159', 179, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION SINCE FULL SYMDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA158', 178, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PSYCHOTIC DATE OF FULL SYND. ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'CA157', 177, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION SINCE ONSET OF 1ST SX');

add_assessment_score(v_id1, owner_id, owner_id, 'CA156', 176, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PSYCHOTIC DATE OF 1ST SYMPT. ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'CA155', 175, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: WAS THERE A PSYCHOTIC EPISODE?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA154', 174, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING OF ATTENTION');

add_assessment_score(v_id1, owner_id, owner_id, 'CA153', 173, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: INATTENTIVENESS DURING MMSE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA153', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA153', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA153', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA153', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA153', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA153', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA259', 279, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # RIGHT BROTHERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA151', 171, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING OF ANHEDONIA-ASOC');
add_assessment_code(v_id1, owner_id, owner_id, 'CA151', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA151', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA151', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA151', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA151', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA151', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA150', 170, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: RELATIONSHIPS WITH FRIENDS/PEER');
add_assessment_code(v_id1, owner_id, owner_id, 'CA150', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA150', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA150', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA150', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA150', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA150', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA297', 318, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AXIS I DIAGNOSES-2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA909', 930, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO OVERLY OPTIMISTIC: RESIDUA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA410', 431, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - CLOTH/APPEAR - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA614', 635, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD LOSS OF INTEREST: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA615', 636, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD LOSS OF INTEREST: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA616', 637, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD LOSS OF INTEREST: COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA617', 638, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD LOSS OF ENERGY: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA610', 631, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD PSYCHO RETARDATION: COL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA252', 272, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - USING TOOTHBRUSH');
add_assessment_code(v_id1, owner_id, owner_id, 'CA252', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA252', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA252', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA252', 3, 'Either', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA599', 620, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - TERMINAL: COL 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA598', 619, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - TERMINAL: COL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA597', 618, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - TERMINAL: COL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA596', 617, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - MIDDLE: COL 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA595', 616, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - MIDDLE: COL 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA253', 273, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - DEALING CARDS/TOSS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA253', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA253', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA253', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA253', 3, 'Either', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA593', 614, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - MIDDLE: COL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA592', 613, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - INITIAL: COL 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA591', 612, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - INITIAL: COL 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA590', 611, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - INITIAL: COL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA759', 780, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS TOLERANCE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA758', 779, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS TOLERANCE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA755', 776, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS DUR OF IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA754', 775, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS DUR OF IMPAIRMENT: CUR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA757', 778, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS # EPISODES OF ABUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA756', 777, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS CURRENTLY ABUSES?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA751', 772, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS PATHOLOGIC USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA750', 771, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS PATHOLOGIC USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA753', 774, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA752', 773, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS IMPAIRMENT: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA258', 278, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - FATHER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA152', 172, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: SOCIAL INATTENTIVENESS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA152', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA152', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA152', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA152', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA152', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA152', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA926', 947, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS INATTENTION: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA681', 702, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL NONBEVERAGE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA500', 521, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA CRITERIA - MOOD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA501', 522, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA CRITERIA - IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA502', 523, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA CRITERIA - 3 SYMPTOMS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA503', 524, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA COLUMN 1 APPLICABLE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA504', 525, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA COLUMN 2 APPLICABLE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA505', 526, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA COLUMN 3 APPLICABLE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA506', 527, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA MOOD: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA507', 528, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA MOOD: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA508', 529, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA MOOD: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA509', 530, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA MOOD DURATION: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA420', 441, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BIZ - REP/STEREO - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA68', 88, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DELUSIONS-FRAGMENTARY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA68', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA68', 1, 'Some', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA68', 2, 'Definate', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA69', 89, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DELUSIONS-BIZARRE OR FANTASTIC');
add_assessment_code(v_id1, owner_id, owner_id, 'CA69', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA69', 1, 'Some', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA69', 2, 'Definate', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA66', 86, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: SENSORIUM WHILE DELUSIONAL');
add_assessment_code(v_id1, owner_id, owner_id, 'CA66', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA66', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA66', 2, 'Definite Physical', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA66', 3, 'Definite Not Physical', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA67', 87, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: PERSISTENCE OF DELUSIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA67', 0, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA67', 1, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA67', 2, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA64', 84, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: THOUGHT WITHDRAWAL');
add_assessment_code(v_id1, owner_id, owner_id, 'CA64', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA64', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA64', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA64', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA64', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA64', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA65', 85, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING OF DELUSIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA62', 82, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: THOUGHT BROADCASTING');
add_assessment_code(v_id1, owner_id, owner_id, 'CA62', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA62', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA62', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA62', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA62', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA62', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA63', 83, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: THOUGHT INSERTION');
add_assessment_code(v_id1, owner_id, owner_id, 'CA63', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA63', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA63', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA63', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA63', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA63', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA60', 80, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DELUSIONS OF BEING CONTROLLED');
add_assessment_code(v_id1, owner_id, owner_id, 'CA60', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA60', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA60', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA60', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA60', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA60', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA61', 81, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DELUSIONS OF MIND READING');
add_assessment_code(v_id1, owner_id, owner_id, 'CA61', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA61', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA61', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA61', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA61', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA61', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA849', 870, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCHIZOTYPY COLUMN 3 APPLIES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA848', 869, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCHIZOTYPY COLUMN 2 APPLIES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA924', 945, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS PRODUCTIVITY: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA688', 709, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL LOSS OF JOB: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA922', 943, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS FEELING INADEQUATE: PREMORB');

add_assessment_score(v_id1, owner_id, owner_id, 'CA923', 944, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS FEELING INADEQUATE: RESIDUA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA920', 941, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS LOW ENERGY LEVEL: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA921', 942, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS LOW ENERGY LEVEL: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA841', 862, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PAS TOTAL SCORE (AGE 6-12)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA840', 861, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PAS INTERESTS (AGE 6-12)');
add_assessment_code(v_id1, owner_id, owner_id, 'CA840', 0, 'Active', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA840', 1, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA840', 2, 'Few', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA840', 3, 'None', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA843', 864, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PAS PEER RELATIONS (AGE 13-21)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA842', 863, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PAS WITHDRAWAL (AGE 13-21)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA845', 866, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PAS SOC-SEXUAL ADJ (AGE 13-21)');
add_assessment_code(v_id1, owner_id, owner_id, 'CA845', 0, 'Active', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA845', 1, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA845', 2, 'Limited', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA845', 3, 'None', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA844', 865, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PAS INTERESTS (AGE 13-21)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA847', 868, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCHIZOTYPY COLUMN 1 APPLIES?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA846', 867, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: PAS TOTAL SCORE (AGE 13-21)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA377', 398, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: FEMALE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA376', 397, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: MALE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA375', 396, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: SATAN/DEVIL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA374', 395, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: GOD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA80', 100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: GOD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA81', 101, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: SATAN/DEVIL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA371', 392, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - AUD: CONVERSE-FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA370', 391, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - AUD: CONVERSE - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA927', 948, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS INATTENTION: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA88', 108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: COMMANDING');

add_assessment_score(v_id1, owner_id, owner_id, 'CA89', 109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: MULTIPLE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA379', 400, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: UNFAMILIAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA378', 399, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VOICES: FAMILIAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA575', 596, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD APPETITE CHANGE: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA574', 595, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD APPETITE CHANGE: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA577', 598, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD WEIGHT GAIN: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA576', 597, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD APPETITE CHANGE: COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA571', 592, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD ANXIOUS NATURE: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA479', 500, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ANH REC INTERESTS - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA573', 594, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD APPETITE CHANGE: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA572', 593, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD ANXIOUS NATURE: COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA474', 495, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL PHYSICAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA475', 496, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL PHYSICAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA476', 497, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL GLOBAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA477', 498, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL GLOBAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA579', 600, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD WEIGHT GAIN: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA471', 492, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL IMPERSIS - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA472', 493, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL IMPERSIS - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA473', 494, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AVOL PHYSICAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA886', 907, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO ELEVATED MOOD: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'FUPER', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH FOLLOW-UP PERIOD');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 9, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA218', 238, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DISTINCT QUALITY TO MOOD');
add_assessment_code(v_id1, owner_id, owner_id, 'CA218', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA218', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA218', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA219', 239, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: NONREACTIVITY OF MOOD');
add_assessment_code(v_id1, owner_id, owner_id, 'CA219', 0, 'Very', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA219', 1, 'Usual', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA219', 2, 'Often', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA219', 3, 'Slightly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA219', 4, 'Rarely', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA219', 5, 'None', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA210', 230, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DIMINISHED ABILITY TO THINK');

add_assessment_score(v_id1, owner_id, owner_id, 'CA211', 231, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: THOUGHTS OF DEATH/SUICIDE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA212', 232, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: SUICIDE ATTEMPTS?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA213', 233, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: NUMBER OF SUICIDE ATTEMPTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA214', 234, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: SERIOUSNESS OF SUICIDE ATTEMPTS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA214', 0, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA214', 1, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA214', 2, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA215', 235, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DYSPHORIC MOOD RATED 3 OR MORE?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA216', 236, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: # DYSPHORIC SX RATED 3 OR MORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA217', 237, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CRITERIA MET FOR DEP SYNDROME?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA658', 679, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX EVER HAD TEGRETOL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA659', 680, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX MONTHS ON TEGRETOL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA713', 734, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL ANXIETY: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA712', 733, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL HYPERACTIVITY: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA715', 736, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL DEPRESSED MOOD: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA714', 735, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL ANXIETY: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA717', 738, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL HYPOTENSION: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA716', 737, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL DEPRESSED MOOD: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA650', 671, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX MONTHS ON ANTIDEP (MAO)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA651', 672, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX DOSE YRS ANTIDEP (MAO)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA652', 673, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX EVER HAD ANXIOLYTICS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA653', 674, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX MONTHS ON ANXIOLYTICS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA654', 675, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX DOSE YRS ANXIOLYTICS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA655', 676, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX EVER HAD LITHIUM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA656', 677, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX MONTHS ON LITHIUM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA657', 678, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX DOSE YEARS LITHIUM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA104', 124, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MOOD INCONGRUENT HALLUCINATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA105', 125, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HALLUCINATIONS IN DEP SYNDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA106', 126, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MOOD CONGRUENT HALLUCINATIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA106', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA106', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA106', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA107', 127, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MOOD INCONGRUENT HALLUCINATIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA107', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA107', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA107', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA100', 120, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: PERSISTENCE OF HALLUCINATIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA100', 0, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA100', 1, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA100', 2, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA101', 121, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HALLUCINATIONS-FRAGMENTARY');

add_assessment_score(v_id1, owner_id, owner_id, 'CA102', 122, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HALLUCINATIONS IN MANIC SYNDROM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA103', 123, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MOOD CONGRUENT HALLUCINATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA827', 848, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ TOLERANCE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA108', 128, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CLOTHING AND APPEARANCE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA108', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA108', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA108', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA108', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA108', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA108', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA109', 129, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: SOCIAL AND SEXUAL BEHAVIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'CA109', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA109', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA109', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA109', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA109', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA109', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA221', 241, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING OF MAJOR DEPRESS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA611', 632, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD PSYCHO RETARDATION: COL 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA269', 289, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # LEFT DAUGHTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA268', 288, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # RIGHT DAUGHTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA265', 285, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # RIGHT SONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA264', 284, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # MIXED SISTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA267', 287, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # MIXED SONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA266', 286, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # LEFT SONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA261', 281, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # MIXED BROTHERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA260', 280, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # LEFT BROTHERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA263', 283, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # LEFT SISTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA262', 282, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: HANDEDNESS - # RIGHT SISTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA220', 240, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DIURNAL VARIATION');
add_assessment_code(v_id1, owner_id, owner_id, 'CA220', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA220', 1, 'Worse in the Morning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA220', 2, 'Worse in the Evening', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA220', 3, 'No Difference', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA594', 615, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA - MIDDLE: COL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA618', 639, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD LOSS OF ENERGY: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA619', 640, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD LOSS OF ENERGY: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA629', 650, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD THOUGHTS OF DEATH: COL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA628', 649, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INABILITY TO THINK: COL 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA625', 646, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INABILITY TO THINK: COL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA624', 645, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD FEELING WORTHLESS: COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA627', 648, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INABILITY TO THINK: COL 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA626', 647, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INABILITY TO THINK: COL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA621', 642, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD FEELING WORTHLESS: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA620', 641, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD LOSS OF ENERGY: COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA623', 644, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD FEELING WORTHLESS: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA622', 643, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD FEELING WORTHLESS: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA119', 139, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DISTRACTIBLE SPEECH');
add_assessment_code(v_id1, owner_id, owner_id, 'CA119', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA119', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA119', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA119', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA119', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA119', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA788', 809, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH CURRENTLY ABUSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA789', 810, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH # EPISODES OF ABUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA782', 803, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH PATHOLOGICAL USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA783', 804, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH PATHOLOGICAL USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA780', 801, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH SUBSTANCE USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA781', 802, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH SUBSTANCE USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA786', 807, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH DUR OF IMPAIRMENT: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA787', 808, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH DUR OF IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA784', 805, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH IMPAIRMENT USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA785', 806, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AMPH IMPAIRMENT USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA913', 934, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO SX CHRONIC SINCE ONSET?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA968', 989, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AXIS II DIAGNOSES-3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA969', 990, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: NUMBER OF AXIS III DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA962', 983, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AXIS I DIAGNOSES-1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA963', 984, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AXIS I DIAGNOSES-2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA960', 981, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CRITERIA USED FOR DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA961', 982, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: NUMBER OF AXIS I DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA966', 987, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AXIS II DIAGNOSES-1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA911', 932, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO INAPP LAUGHING: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA964', 985, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AXIS I DIAGNOSES-3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA965', 986, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: NUMBER OF AXIS II DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA430', 451, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FTD - PRES SPEECH-MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA431', 452, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FTD - GLOBAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA432', 453, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FTD - GLOBAL - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA433', 454, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FTD - GLOBAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA434', 455, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT - STUPOR - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA435', 456, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT - STUPOR - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA436', 457, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT - STUPOR - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA437', 458, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT - RIGIDITY - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA438', 459, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT - RIGIDITY - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA439', 460, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT - RIGIDITY - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA761', 782, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS WITHDRAWAL: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA539', 560, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA DISTRACTIBILITY: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA538', 559, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA NEED FOR SLEEP: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA762', 783, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS CRITERIA FOR DEPEND: CUR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA531', 552, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA FLIGHT OF IDEAS: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA530', 551, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA FLIGHT OF IDEAS: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA533', 554, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA SELF-ESTEEM: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA532', 553, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA FLIGHT OF IDEAS: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA535', 556, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA SELF-ESTEEM: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA534', 555, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA SELF-ESTEEM: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA537', 558, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA NEED FOR SLEEP: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA536', 557, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MANIA NEED FOR SLEEP: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA35', 55, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH EDUCATIONAL PERFORMANCE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA35', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA35', 1, 'Superb', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA35', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA35', 3, 'Average', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA35', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA35', 5, 'Failing', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA34', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH EDUC ACHIEVEMENT OF SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA37', 57, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SOCIAL CLASS OF SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA36', 56, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH EDUCATIONAL PROBLEMS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA36', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA36', 1, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA36', 2, 'Held Back Once', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA36', 3, 'Special Education', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA36', 4, 'Held 2+ Grades', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA36', 5, 'Not Completed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA31', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH EDUC ACHIEVEMENT OF FATHER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA30', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH OCCUPATION OF PARENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA33', 53, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH SOCIAL CLASS OF PARENTS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA33', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA33', 1, 'Top rank', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA33', 2, 'High rank', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA33', 3, 'White collar', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA33', 4, 'Labor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA33', 5, 'Unskilled', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA32', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH EDUC ACHIEVEMENT OF MOTHER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA39', 59, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LIVES WITH PARENTS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA39', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA39', 1, 'Yes Both', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA39', 2, 'Yes Mom', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA39', 3, 'Yes Dad', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA38', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH LIVING CIRCUMSTANCES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA816', 837, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ SUBSTANCE USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA456', 477, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALOG POV CONTENT - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA814', 835, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HALL CURRENTLY ABUSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA815', 836, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HALL # EPISODES OF ABUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA806', 827, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HALL SUBSTANCE USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA813', 834, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HALL DUR OF IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA810', 831, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HALL IMPAIRMENT: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA457', 478, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALOG POV CONTENT - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA768', 789, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC IMPAIRMENT: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA778', 799, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC CRIT FOR DEPEND: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA818', 839, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MARIJ PATHOLOGICAL USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA769', 790, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: COC IMPAIRMENT: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA928', 949, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS SOCIAL WITHDRAWAL: PREMORBI');

add_assessment_score(v_id1, owner_id, owner_id, 'CA445', 466, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT EXCITE - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA444', 465, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT EXCITE - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA447', 468, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT POST/MANN - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA446', 467, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT POST/MANN - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA328', 349, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - RELIGIOUS - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA440', 461, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT - WAXY - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA443', 464, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT EXCITE - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA442', 463, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT - WAXY - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA324', 345, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - GUILT/SIN - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA325', 346, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - GRANDIOSE - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA326', 347, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - GRANDIOSE - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA327', 348, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - GRANDIOSE - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA449', 470, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT GLOBAL - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA448', 469, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CAT POST/MANN - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA322', 343, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - GUILT/SIN - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA323', 344, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - GUILT/SIN - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA94', 114, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: HEARD ON THE RIGHT SIDE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA889', 910, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO NEED FOR SLEEP: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA888', 909, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO NEED FOR SLEEP: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA885', 906, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO EVIDENCE OF HYPOMANIA?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA93', 113, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: HEARD ON THE LEFT SIDE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA887', 908, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO ELEVATED MOOD: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA868', 889, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH SOCIAL ISOLATION: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA881', 902, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH HYGIENE IMPAIR: PRODROMAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA880', 901, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH HYGIENE IMPAIR: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA883', 904, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: AFF PERS SYN: COL 1 APPLICABLE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA92', 112, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: HEARD OUTSIDE THE HEAD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA950', 971, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: CYCLOTHYMIA PATTERN: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA91', 111, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: HEARD INSIDE THE HEAD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA90', 110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES: ALWAYS THE SAME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA229', 249, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: TREATMENT - NEUROLEPTICS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA148', 168, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: SEXUAL INTEREST AND ACTIVITY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA148', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA148', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA148', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA148', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA148', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA148', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA149', 169, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: ABILITY TO FEEL INTIMACY/CLOSE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA149', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA149', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA149', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA149', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA149', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA149', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA223', 243, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION SINCE DEPRESS SYMPTOM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA222', 242, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH DEPRESS. DATE OF 1ST SYMPT. ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'CA225', 245, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DURATION SINCE FULL SYNDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA357', 378, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - MOOD CONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA227', 247, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: ROLE OF PRECIPITANTS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA227', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA227', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA227', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA226', 246, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: REMAINS IN SYNDROME?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA140', 160, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: LACK OF VOCAL INFLECTION');
add_assessment_code(v_id1, owner_id, owner_id, 'CA140', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA140', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA140', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA140', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA140', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA140', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA141', 161, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING AFFECT FLATTENING');
add_assessment_code(v_id1, owner_id, owner_id, 'CA141', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA141', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA141', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA141', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA141', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA141', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA142', 162, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: INAPPROPRIATE AFFECT');
add_assessment_code(v_id1, owner_id, owner_id, 'CA142', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA142', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA142', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA142', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA142', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA142', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA143', 163, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GROOMING AND HYGIENE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA143', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA143', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA143', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA143', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA143', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA143', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA144', 164, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: IMPERSISTENCE AT WORK OR SCHOOL');
add_assessment_code(v_id1, owner_id, owner_id, 'CA144', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA144', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA144', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA144', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA144', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA144', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA145', 165, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: PHYSICAL ANERGIA');
add_assessment_code(v_id1, owner_id, owner_id, 'CA145', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA145', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA145', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA145', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA145', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA145', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA146', 166, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING OF AVOL-APATHY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA146', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA146', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA146', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA146', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA146', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA146', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA147', 167, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: RECREATIONAL INTERESTS AND ACTS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA147', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA147', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA147', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA147', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA147', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA147', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA956', 977, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: FUNCTION PAST 5 YEARS: DETERIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA228', 248, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: ROLE OF ORGANIC FACTORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA588', 609, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA/HYPERSOMNIA: COL 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA660', 681, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX DOSE YEARS TEGRETOL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA663', 684, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX LEUCOTOMY');

add_assessment_score(v_id1, owner_id, owner_id, 'CA662', 683, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX # ECT TREATMENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA665', 686, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX DOSE YEARS NICOTINE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA664', 685, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MEDHX AVERAGE CAFFEINE INTAKE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA667', 688, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL NEEDS DAILY: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA567', 588, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD DYSPHORIC NATURE: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA580', 601, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD WEIGHT GAIN: COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA581', 602, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD WEIGHT LOSS: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA582', 603, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD WEIGHT LOSS: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA583', 604, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD WEIGHT LOSS: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA584', 605, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD WEIGHT LOSS: COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA585', 606, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA/HYPERSOMNIA: COL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA586', 607, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA/HYPERSOMNIA: COL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA587', 608, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD INSOMNIA/HYPERSOMNIA: COL 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA293', 313, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GAS - AT DISCHARGE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA748', 769, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS SUBSTANCE USE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA749', 770, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: OPIODS SUBSTANCE USE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA746', 767, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB CRITERIA DEPEND: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA295B', 316, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: NUMBER OF AXIS I DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA744', 765, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB WITHDRAWAL: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA745', 766, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB WITHDRAWAL: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA742', 763, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB TOLERANCE: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA743', 764, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB TOLERANCE: PAST');

add_assessment_score(v_id1, owner_id, owner_id, 'CA740', 761, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB CURRENTLY ABUSES?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA741', 762, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: BARB TOTAL # OF ABUSE EPISODES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA139', 159, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AFFECTIVE NONRESPONSIVITY');
add_assessment_code(v_id1, owner_id, owner_id, 'CA139', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA139', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA139', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA139', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA139', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA139', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA138', 158, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: POOR EYE CONTACT');
add_assessment_code(v_id1, owner_id, owner_id, 'CA138', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA138', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA138', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA138', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA138', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA138', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA135', 155, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: UNCHANGING FACIAL EXPRESSION');
add_assessment_code(v_id1, owner_id, owner_id, 'CA135', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA135', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA135', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA135', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA135', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA135', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA134', 154, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING OF ALOGIA');
add_assessment_code(v_id1, owner_id, owner_id, 'CA134', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA134', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA134', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA134', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA134', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA134', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA137', 157, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: PAUCITY OF EXPRESSIVE GESTURES');
add_assessment_code(v_id1, owner_id, owner_id, 'CA137', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA137', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA137', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA137', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA137', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA137', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA136', 156, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DECREASED SPONTANEOUS MOVEMENT');
add_assessment_code(v_id1, owner_id, owner_id, 'CA136', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA136', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA136', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA136', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA136', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA136', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA131', 151, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: BLOCKING');
add_assessment_code(v_id1, owner_id, owner_id, 'CA131', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA131', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA131', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA131', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA131', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA131', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA130', 150, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: POVERTY OF CONTENT OF SPEECH');
add_assessment_code(v_id1, owner_id, owner_id, 'CA130', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA130', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA130', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA130', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA130', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA130', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA133', 153, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: PERSEVERATION');
add_assessment_code(v_id1, owner_id, owner_id, 'CA133', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA133', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA133', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA133', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA133', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA133', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA132', 152, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: INCREASED LATENCY OF RESPONSE');
add_assessment_code(v_id1, owner_id, owner_id, 'CA132', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA132', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA132', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA132', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA132', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA132', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA298', 319, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AXIS I DIAGNOSES-3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA959', 980, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: RELI/COMPLETE OF PART II INFO');
add_assessment_code(v_id1, owner_id, owner_id, 'CA959', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA959', 1, 'Very Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA959', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA959', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA959', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA959', 5, 'Very Poor', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA299', 320, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: NUMBER OF AXIS II DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA958', 979, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: GAS FIVE YEARS AGO');

add_assessment_score(v_id1, owner_id, owner_id, 'CA407', 428, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - MOOD CONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA569', 590, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD ANXIOUS NATURE: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA79', 99, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: WERE ANY VOICES HEARD?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA78', 98, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES CONVERSING');

add_assessment_score(v_id1, owner_id, owner_id, 'CA711', 732, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: ALCOHOL HYPERACTIVITY: CURRENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA120', 140, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: CLANGING');
add_assessment_code(v_id1, owner_id, owner_id, 'CA120', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA120', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA120', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA120', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA120', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA120', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA71', 91, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MOOD CONGRUENT DELUSIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA71', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA71', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA71', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA70', 90, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DELUSIONS IN MANIC SYNDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA73', 93, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: DELUSIONS IN DEPRESSIVE SYNDRO');

add_assessment_score(v_id1, owner_id, owner_id, 'CA72', 92, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MOOD INCONGRUENT DELUSIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA72', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA72', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA72', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA75', 95, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MOOD INCONGRUENT DELUSIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA75', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA75', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA75', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA74', 94, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: MOOD CONGRUENT DELUSIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA74', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA74', 1, 'Ques', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA74', 2, 'Definite', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA77', 97, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: VOICES COMMENTING');
add_assessment_code(v_id1, owner_id, owner_id, 'CA77', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA77', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA77', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA77', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA77', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA77', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA76', 96, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: AUDITORY HALLUCINATIONS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA76', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA76', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA76', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA76', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA76', 4, 'Marked', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA76', 5, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA396', 417, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - VISION - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA912', 933, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO AGE FIRST SYMPTOMS NOTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CA858', 879, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH SUSPICIOUSNESS: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA859', 880, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH WEIRD PERCEPTUAL: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA917', 938, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS DEPRESSIVE PERIOD: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA916', 937, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS DEPRESSIVE PERIOD: PREMORBI');

add_assessment_score(v_id1, owner_id, owner_id, 'CA915', 936, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DYS EVIDENCE OF DYSTHYMIA');

add_assessment_score(v_id1, owner_id, owner_id, 'CA914', 935, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HYPO CLUSTER DURATION');

add_assessment_score(v_id1, owner_id, owner_id, 'CA852', 873, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH MAGICAL THINKING: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA853', 874, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH IDEAS OF REFER: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA850', 871, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH MAGICAL THINKING: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA851', 872, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH MAGICAL THINKING: PRODROMAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA856', 877, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH SUSPICIOUSNESS: PREMORBID');

add_assessment_score(v_id1, owner_id, owner_id, 'CA857', 878, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH SUSPICIOUSNESS: PRODROMAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA854', 875, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH IDEAS OF REFER: PRODROMAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA855', 876, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: SCH IDEAS OF REFER: RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA360', 381, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - OCCUR IN DEPRES SYNDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA361', 382, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - MOOD CONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA362', 383, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - MOOD INCONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA363', 384, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - WITH AFFECTIVE CLEARING');

add_assessment_score(v_id1, owner_id, owner_id, 'CA364', 385, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - AUD: VOICES - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA365', 386, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - AUD: VOICES - FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA366', 387, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - AUD: VOICES - MUCH OF TIM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA367', 388, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - AUD: COMMENTS - EVER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA368', 389, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - AUD: COMMENTS-FIRST 2 YRS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA369', 390, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - AUD: COMMENTS-MUCH OF TIM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA99', 119, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: SENSORIUM WHILE HALLUCINATING');
add_assessment_code(v_id1, owner_id, owner_id, 'CA99', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA99', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA99', 2, 'Definite Physical', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA99', 3, 'Definite Not Physical', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA98', 118, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH CC: GLOBAL RATING OF HALLUCINATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA409', 430, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - AFFECTIVE CLEARING');

add_assessment_score(v_id1, owner_id, owner_id, 'CA408', 429, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - MOOD INCONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA564', 585, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD DURATION OF MOOD: COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA565', 586, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD DYSPHORIC NATURE: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA562', 583, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD DURATION OF MOOD: COLUMN 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CA563', 584, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD DURATION OF MOOD: COLUMN 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CA560', 581, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD MOOD - COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA561', 582, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD DURATION OF MOOD: COLUMN 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CA401', 422, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - SENSORIUM');
add_assessment_code(v_id1, owner_id, owner_id, 'CA401', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA401', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA401', 2, 'Definite Physical', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA401', 3, 'Definite Not Physical', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA400', 421, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - GLOBAL - MUCH OF TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA403', 424, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - MOOD CONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA402', 423, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - OCCUR IN MANIC SYNDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA405', 426, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - AFFECTIVE CLEARING');

add_assessment_score(v_id1, owner_id, owner_id, 'CA404', 425, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - MOOD INCONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA568', 589, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: MDD DYSPHORIC NATURE: COLUMN 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CA406', 427, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: HAL - OCCUR IN DEPRES SYNDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CA349', 370, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH PH: DEL - THGHT WITH - EVER');

commit;
END;
/
