set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9113816';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '4231224',
      2,
      1,
      1,
      1,
      '2144',
      1,
      NULL,
      NULL,
      NULL,
      '10- 4-1980',
      49,
      NULL,
      3,
      2.064737,
      1,
      ' 9-23-2000',
      37,
      0,
      130.179803,
      94,
      2,
      ' 9-20-2001',
      ' 8-21-1986',
      ' 9-25-1980',
      NULL,
      3.813463,
      0,
      0,
      0,
      1.899914,
      1,
      0,
      NULL,
      21,
      2,
      8.401292,
      0,
      16.880368,
      14.979571,
      0,
      NULL,
      NULL,
      NULL,
      4.565143,
      2.896123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.311990,
      3,
      NULL,
      2,
      4,
      4,
      NULL,
      2,
      1,
      1,
      1,
      0,
      2,
      5,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.616779,
      3.247124,
      3,
      0.972497,
      3,
      0.194428,
      3,
      1,
      0,
      0,
      1,
      2,
      2,
      2.385396,
      NULL,
      2,
      3.037795,
      2,
      1,
      NULL,
      5,
      NULL,
      0,
      1.578977,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      5,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.305410,
      NULL,
      0,
      1,
      1,
      5,
      1,
      NULL,
      1,
      3,
      NULL,
      5,
      1,
      3,
      NULL,
      1,
      2,
      3,
      3,
      4,
      0,
      NULL,
      4,
      3,
      NULL,
      1,
      0,
      4,
      5,
      4,
      5,
      5,
      1,
      5,
      1.520583,
      ' 1-11-1982',
      417.223277,
      ' 5-13-1992',
      NULL,
      1.172631,
      NULL,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.905426,
      NULL,
      1,
      0,
      0.177397,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401226,
      1,
      0.832677,
      0,
      NULL,
      0.241912,
      0.068625,
      0,
      256,
      1,
      2,
      NULL,
      NULL,
      42.623324,
      0,
      1.269668,
      NULL,
      NULL,
      2,
      1,
      3,
      2,
      0,
      0,
      3,
      2,
      2,
      NULL,
      NULL,
      1.956358,
      3,
      1,
      0,
      1.362875,
      0.948533,
      0,
      1,
      1,
      NULL,
      0.640758,
      NULL,
      1,
      1,
      1,
      3,
      1,
      NULL,
      9,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      1.882675,
      1,
      3.439045,
      3.204468,
      23.585488,
      3,
      1,
      NULL,
      27,
      24,
      57,
      2,
      1.251307,
      3,
      NULL,
      '',
      '',
      1.747660,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      20.100831,
      121.015000,
      9.479087,
      0,
      3,
      1,
      10,
      1,
      2,
      0.066532,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      2,
      1,
      NULL,
      NULL,
      1.941976,
      NULL,
      NULL,
      NULL,
      3.848830,
      0.936608,
      1.007262,
      3,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.654325,
      0,
      1.316684,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.629532,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.481447,
      1,
      2.992491,
      1,
      0,
      0,
      1.695608,
      3.182730,
      0.849078,
      NULL,
      NULL,
      0.861425,
      NULL,
      2,
      1.672761,
      1.960088,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.565614,
      NULL,
      4,
      0,
      1.468715,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.270573,
      NULL,
      NULL,
      3.724615,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.487573,
      NULL,
      NULL,
      7,
      0.462963,
      4,
      2,
      3.578934,
      2.653050,
      2,
      3,
      1,
      NULL,
      4.171889,
      5,
      NULL,
      NULL,
      NULL,
      0.907564,
      NULL,
      NULL,
      1.557084,
      NULL,
      NULL,
      0.091171,
      NULL,
      NULL,
      2,
      1,
      NULL,
      7.158177,
      NULL,
      1,
      1.644546,
      NULL,
      NULL,
      1,
      3,
      2,
      5,
      5.440474,
      0.118980,
      2,
      0.261319,
      2.511123,
      6.392694,
      NULL,
      NULL,
      1.906065,
      0,
      NULL,
      1.815000,
      3,
      2,
      0.338348,
      NULL,
      NULL,
      6,
      0,
      NULL,
      3.541429,
      NULL,
      2,
      0,
      3.699124,
      1,
      NULL,
      NULL,
      0.879222,
      3,
      2,
      NULL,
      NULL,
      3.661235,
      2.833208,
      6,
      NULL,
      NULL,
      3.697910,
      3,
      NULL,
      0,
      1.581307,
      1.872539,
      NULL,
      1,
      1.480939,
      NULL,
      NULL,
      5.739268,
      NULL,
      NULL,
      1.246865,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.002983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.538598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.757327,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.618011,
      NULL,
      NULL,
      NULL,
      0.931215,
      2,
      NULL,
      NULL,
      NULL,
      1.627938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.257866,
      NULL,
      NULL,
      NULL,
      0.206097,
      NULL,
      NULL,
      NULL,
      0.827336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.492587,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      3,
      3,
      19.017689,
      26.659790,
      0,
      NULL,
      5.536011,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.760642,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1.915048,
      NULL,
      NULL,
      NULL,
      1.350989,
      0,
      NULL,
      0,
      1,
      NULL,
      0.842450,
      1,
      NULL,
      0.999962,
      0.730040,
      0.046888,
      1.523661,
      1.186784,
      NULL,
      1,
      0.336199,
      NULL,
      0.656614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968922,
      0,
      0.560787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819635,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206691,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.535842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.988389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.213685,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308209,
      NULL,
      0,
      NULL,
      0.022376,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      0.960721,
      2,
      1,
      NULL,
      5,
      2,
      3,
      NULL,
      0,
      3.179757,
      NULL,
      0.212093,
      0.308146,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.882590,
      0,
      NULL,
      0,
      0.331262,
      NULL,
      1,
      2.082140,
      NULL,
      0.201799,
      3,
      NULL,
      1,
      2,
      NULL,
      1,
      0.924841,
      NULL,
      0,
      NULL,
      1.852969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2,
      1,
      NULL,
      1.024763,
      3,
      NULL,
      56,
      3,
      0,
      2,
      '03324',
      '',
      '',
      1.448260,
      '',
      '',
      '',
      1,
      '44040',
      '',
      '');
commit;
end;
/


