set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8424170';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      3,
      '2420',
      1.978174,
      NULL,
      NULL,
      NULL,
      '11-10-1985',
      0.782505,
      NULL,
      1,
      3,
      0.073341,
      ' 2-24-1977',
      NULL,
      NULL,
      NULL,
      78.114334,
      2,
      ' 0-27-1994',
      ' 6-10-2003',
      '10-13-1991',
      0,
      NULL,
      0.604347,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      1,
      1,
      23,
      22,
      0,
      25.534498,
      4,
      2,
      9.563423,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.359441,
      0,
      0,
      3,
      4,
      1,
      1,
      1,
      4,
      1,
      3,
      0,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.608516,
      NULL,
      NULL,
      4,
      NULL,
      0,
      2.426326,
      NULL,
      1,
      NULL,
      2.141200,
      2.768065,
      0.481558,
      0.751360,
      1.437998,
      2.355256,
      1.900998,
      1,
      0,
      1.723954,
      1,
      1.236831,
      2,
      0,
      0,
      3.132773,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      4,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      3,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      2,
      1,
      1,
      4,
      3,
      3,
      0,
      2,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      4,
      5,
      2,
      NULL,
      1,
      5,
      5,
      3,
      0,
      NULL,
      0.099307,
      1,
      ' 3-11-2000',
      34.115845,
      NULL,
      7.248601,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.396388,
      1,
      NULL,
      NULL,
      5,
      NULL,
      1.642824,
      0.654375,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304689,
      1,
      0.304922,
      0,
      0,
      0.805902,
      2.035123,
      19,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.465187,
      3,
      3,
      1,
      2,
      NULL,
      2,
      3,
      1,
      3,
      1,
      NULL,
      1.183097,
      1,
      1,
      1.676035,
      1.236997,
      0.754916,
      0.499214,
      NULL,
      1.554042,
      1,
      NULL,
      0.209679,
      0.212171,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      11.298013,
      4.398368,
      7,
      8.152480,
      7,
      4.055907,
      3.066853,
      1,
      2.162322,
      0.413451,
      3.533333,
      63.746958,
      1,
      2.530984,
      NULL,
      NULL,
      9,
      21.353471,
      3,
      1,
      6,
      '02424',
      '30413',
      '00211',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      16.114901,
      88,
      23,
      3.062070,
      39.886017,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.365292,
      2.921384,
      1.537259,
      0.741561,
      3.230035,
      0.436786,
      0.426268,
      3,
      0,
      NULL,
      1.485450,
      NULL,
      NULL,
      3.064999,
      1.990531,
      1,
      1.762215,
      3.130692,
      1,
      NULL,
      NULL,
      NULL,
      3.762961,
      0.538401,
      0.063741,
      1,
      NULL,
      NULL,
      0.067478,
      NULL,
      NULL,
      NULL,
      0.892218,
      1.934464,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.715580,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      0,
      0.482078,
      1,
      0.217844,
      1.004372,
      1.780421,
      1,
      1.746219,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.883405,
      0,
      NULL,
      1.872611,
      NULL,
      0,
      0.515088,
      0.797753,
      NULL,
      NULL,
      0.538169,
      NULL,
      NULL,
      1.683515,
      2,
      1,
      0,
      7.940393,
      1,
      1,
      0.937380,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.764312,
      0.603617,
      1.497699,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.986000,
      1.427867,
      NULL,
      0.531712,
      1.806586,
      3.471318,
      NULL,
      1,
      5,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.846901,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.257419,
      NULL,
      NULL,
      1.274921,
      NULL,
      NULL,
      2.290978,
      NULL,
      NULL,
      1.574231,
      NULL,
      1.786636,
      1,
      NULL,
      NULL,
      0.098719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.680489,
      NULL,
      1,
      3.030182,
      4.476425,
      NULL,
      NULL,
      1,
      0.099733,
      0,
      2,
      1.886481,
      1.675781,
      0.526700,
      0.277730,
      3.074505,
      1.684219,
      3.068817,
      2.148775,
      7,
      2,
      4,
      1,
      NULL,
      NULL,
      3.494347,
      2,
      1,
      NULL,
      0.484135,
      1,
      NULL,
      0,
      0.361791,
      NULL,
      NULL,
      0.283324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.662928,
      NULL,
      NULL,
      1.361898,
      1.488324,
      0,
      1.810615,
      1.893584,
      0,
      0.745086,
      NULL,
      NULL,
      1,
      1.607606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755311,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.486314,
      1.431445,
      NULL,
      NULL,
      1.693082,
      0.483957,
      NULL,
      NULL,
      0.532488,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109225,
      NULL,
      NULL,
      1.541649,
      3.985486,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.138055,
      1,
      NULL,
      NULL,
      3,
      0.408051,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.386661,
      0,
      NULL,
      NULL,
      2.995241,
      0.794496,
      NULL,
      NULL,
      NULL,
      7.201978,
      NULL,
      NULL,
      1.621994,
      0.670048,
      NULL,
      0,
      0.284811,
      42.892825,
      20,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.177351,
      NULL,
      NULL,
      2.352732,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414878,
      NULL,
      0,
      13375.945143,
      NULL,
      NULL,
      0,
      1.689751,
      1.128775,
      1,
      1.187699,
      0,
      1.696381,
      NULL,
      0.730151,
      1.263792,
      0,
      1.794280,
      0.550911,
      1,
      1.971041,
      0,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      51,
      NULL,
      1.145949,
      20,
      42,
      0.028903,
      1.910944,
      NULL,
      NULL,
      1,
      NULL,
      0.220862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113020,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.818107,
      NULL,
      0.801334,
      NULL,
      1,
      NULL,
      0.526521,
      NULL,
      0.346436,
      NULL,
      0.962978,
      NULL,
      0.063597,
      0.662573,
      1,
      1.211506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.103597,
      1.032121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.931333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.195311,
      NULL,
      0,
      NULL,
      4.701909,
      NULL,
      0,
      NULL,
      0.058573,
      NULL,
      0,
      NULL,
      0.629237,
      1,
      1.616451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.663430,
      NULL,
      1.430183,
      NULL,
      1.012114,
      NULL,
      7,
      NULL,
      2.691364,
      1,
      2,
      NULL,
      3,
      NULL,
      3,
      NULL,
      6,
      NULL,
      3.360384,
      NULL,
      2,
      NULL,
      0,
      1.654768,
      NULL,
      23,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      5.551962,
      4,
      4,
      1,
      0,
      17,
      0,
      1,
      NULL,
      1.707854,
      3.111867,
      NULL,
      NULL,
      0.727231,
      0,
      1.596711,
      3,
      NULL,
      0.858520,
      NULL,
      1,
      1.288632,
      1,
      1,
      1.410709,
      1.652010,
      1,
      1.276110,
      0.376736,
      NULL,
      0.274541,
      NULL,
      0,
      1,
      1.571115,
      0.182985,
      2,
      NULL,
      0,
      1,
      0,
      0,
      3.826388,
      NULL,
      0.517008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.275854,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4,
      NULL,
      0.682139,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      1.028040,
      3.871354,
      '20201',
      '44224',
      '32002',
      0.377618,
      '',
      NULL,
      '',
      1.789805,
      '',
      '',
      '');
commit;
end;
/


