set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8424170';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3124413',
      1,
      1.756179,
      5,
      3,
      NULL,
      3,
      NULL,
      1.596592,
      5,
      ' 3-17-1978',
      NULL,
      NULL,
      3,
      2,
      3.381970,
      '11-12-1993',
      34,
      2,
      237,
      NULL,
      NULL,
      NULL,
      ' 6- 2-1977',
      NULL,
      2.290198,
      1,
      1.586921,
      0.912247,
      0.644522,
      0,
      NULL,
      0.800806,
      1,
      45,
      3,
      8.668771,
      5,
      11.333506,
      19.940901,
      2,
      1.444601,
      3,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      0.712975,
      4,
      0,
      5,
      2,
      1,
      0,
      1,
      4,
      5,
      2,
      NULL,
      1,
      11,
      1,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      3.803889,
      1.237237,
      0.398949,
      0,
      0,
      2,
      1.412321,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      5,
      NULL,
      2,
      NULL,
      0.849429,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      4,
      NULL,
      1,
      5,
      4,
      1,
      1,
      1,
      NULL,
      2,
      1,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      4,
      3,
      5,
      1,
      1,
      0,
      2,
      0,
      3,
      3,
      1,
      4,
      2,
      0,
      5,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      2,
      4,
      0,
      6,
      3.856876,
      ' 0-13-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.439200,
      0.299413,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.518116,
      1.774941,
      3,
      1.739315,
      3,
      6,
      1,
      2,
      1,
      9.025535,
      6.157332,
      3.518831,
      NULL,
      0,
      0,
      0.092285,
      5.652502,
      2.048060,
      2,
      1,
      1,
      1,
      ' 3-17-2001',
      4,
      NULL,
      0.577936,
      0.207627,
      1,
      1,
      3.168864,
      NULL,
      NULL,
      1,
      1.860980,
      1.500276,
      0.532557,
      3.505328,
      76.803444,
      0.930108,
      1.508676,
      NULL,
      NULL,
      NULL,
      0,
      1.228104,
      1,
      0,
      0,
      3,
      0,
      0,
      1,
      3,
      0,
      0,
      0,
      0.417255,
      3.072750,
      7.548360,
      0,
      NULL,
      1.853471,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.437483,
      5,
      NULL,
      4.723885,
      5,
      1.397008,
      11.235171,
      10.784858,
      1.517612,
      3,
      0,
      0.643740,
      NULL,
      0,
      2,
      NULL,
      3,
      0.195496,
      NULL,
      NULL,
      63,
      73,
      1,
      0,
      0,
      '20320',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      2.207561,
      131.861954,
      12,
      2.579298,
      30,
      12.258173,
      NULL,
      2,
      1,
      1.290117,
      3,
      1.127262,
      0.614149,
      1,
      0,
      NULL,
      1.986340,
      1,
      NULL,
      NULL,
      2.268685,
      0,
      0.496299,
      1.197739,
      NULL,
      0.895511,
      2.368942,
      0.193787,
      1,
      2.819646,
      3.668862,
      NULL,
      1.750115,
      1.899874,
      NULL,
      2,
      2.766102,
      0,
      0.157874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      11,
      0,
      1,
      0.638069,
      NULL,
      NULL,
      NULL,
      NULL,
      3.138441,
      NULL,
      2.612069,
      NULL,
      NULL,
      1,
      2.787529,
      2.317451,
      0.758651,
      NULL,
      2,
      1,
      0.720155,
      0.936800,
      1,
      1.103659,
      0.121400,
      1.019225,
      0.826362,
      2,
      1.769181,
      2,
      3.880710,
      0,
      3.220197,
      1,
      0,
      1,
      1.576111,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.079548,
      2.195928,
      NULL,
      NULL,
      0.557764,
      NULL,
      NULL,
      NULL,
      3,
      2.274650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.200502,
      0.301645,
      2,
      NULL,
      1,
      1.118457,
      NULL,
      NULL,
      NULL,
      0.625251,
      0,
      2.371147,
      2,
      1.561741,
      0,
      3,
      1,
      NULL,
      4,
      0,
      1,
      NULL,
      NULL,
      0.243434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.605844,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      1.132538,
      0,
      6,
      2.979602,
      1.101009,
      2,
      6,
      3,
      1,
      NULL,
      NULL,
      1.182286,
      NULL,
      NULL,
      0,
      0.052035,
      2.227118,
      1,
      2.581389,
      NULL,
      8.195915,
      9,
      1.093842,
      2,
      1,
      2.970276,
      1.595797,
      0,
      1,
      0,
      0.967215,
      2.279064,
      NULL,
      0,
      2,
      3.641751,
      8.159677,
      1.508204,
      3,
      NULL,
      NULL,
      1.940963,
      NULL,
      0,
      1.465197,
      NULL,
      0,
      0,
      0,
      1.816556,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.541651,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.348264,
      NULL,
      NULL,
      2.508724,
      NULL,
      NULL,
      7.065677,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.233815,
      2,
      NULL,
      1,
      3.527716,
      NULL,
      NULL,
      2.274556,
      0.332451,
      NULL,
      NULL,
      1.591042,
      0.781900,
      NULL,
      NULL,
      0,
      0.695018,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.000372,
      0.810616,
      NULL,
      0.939734,
      0,
      0,
      NULL,
      NULL,
      1.892746,
      0.001417,
      NULL,
      0,
      0.077417,
      0.249195,
      NULL,
      1,
      3,
      3.629107,
      NULL,
      1,
      2.945851,
      2.642954,
      NULL,
      1.102385,
      0.843409,
      0,
      NULL,
      2,
      3.413891,
      0.863533,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.439210,
      3.964483,
      NULL,
      1,
      3.113411,
      NULL,
      NULL,
      10.647717,
      NULL,
      5.151348,
      NULL,
      2.168982,
      1.352009,
      3,
      4,
      3,
      1.348992,
      7,
      1.010424,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.594221,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      17289,
      1665,
      1,
      3,
      1.172322,
      1.749978,
      0.544798,
      1.434989,
      0.795802,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.030603,
      1,
      0.396073,
      0.837177,
      1,
      1.383810,
      NULL,
      3.108618,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      1,
      33.159749,
      NULL,
      0,
      2,
      2,
      NULL,
      0,
      NULL,
      0.418742,
      NULL,
      NULL,
      NULL,
      1.741572,
      NULL,
      1,
      NULL,
      1.154637,
      NULL,
      0,
      NULL,
      1.725588,
      NULL,
      1.000545,
      NULL,
      NULL,
      NULL,
      0.658857,
      NULL,
      NULL,
      NULL,
      1.462145,
      NULL,
      NULL,
      3,
      NULL,
      0.202133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.307610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1.290045,
      NULL,
      NULL,
      NULL,
      1.956325,
      NULL,
      0,
      NULL,
      0.880387,
      NULL,
      0,
      0.572640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.026514,
      NULL,
      1,
      NULL,
      1.692141,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      98.254210,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.511809,
      NULL,
      NULL,
      11.498195,
      1.338668,
      0.663380,
      1,
      1.206494,
      NULL,
      NULL,
      2,
      3,
      2.412574,
      0,
      0.419829,
      2,
      NULL,
      0,
      2.731214,
      0.820973,
      3,
      1,
      3.245473,
      1,
      1,
      1.088585,
      1,
      1.754440,
      NULL,
      1.488907,
      0.368690,
      1,
      NULL,
      3.816594,
      3.900506,
      NULL,
      1,
      0.722297,
      0.221921,
      NULL,
      1,
      0,
      1,
      2,
      0.756685,
      0,
      1,
      3.458056,
      NULL,
      NULL,
      0,
      1.176970,
      0,
      3,
      2.384713,
      0.722107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.446671,
      1,
      1.478630,
      NULL,
      6,
      2,
      0.863453,
      NULL,
      NULL,
      27.277720,
      8.429832,
      NULL,
      1,
      2,
      '33302',
      '31421',
      NULL,
      0.742282,
      NULL,
      NULL,
      '',
      0.568978,
      '',
      NULL,
      '');
commit;
end;
/


