set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8424170';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '2130312',
      3.380182,
      1.999246,
      1,
      3,
      '2440',
      3.179874,
      2.755831,
      2,
      21.991385,
      ' 6-29-1984',
      20,
      NULL,
      NULL,
      0.887181,
      NULL,
      ' 4-29-1982',
      24.276249,
      1.500076,
      NULL,
      65,
      0,
      ' 5- 2-1994',
      ' 5- 2-2001',
      ' 7- 5-1992',
      1.205363,
      0.360899,
      0,
      2,
      1.457234,
      NULL,
      NULL,
      1,
      0,
      43.033571,
      NULL,
      11.918049,
      1,
      17,
      7,
      0,
      5,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      4,
      0,
      3,
      0,
      NULL,
      0,
      5,
      4,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.460284,
      NULL,
      0,
      2,
      2,
      0,
      0.299474,
      1.882153,
      1.892322,
      1,
      3.675416,
      2.145873,
      NULL,
      0,
      0,
      0,
      0.255845,
      0,
      3.940945,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      4,
      1,
      1,
      0,
      NULL,
      1,
      3,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      4,
      NULL,
      5,
      1,
      NULL,
      5,
      2,
      4,
      0,
      4,
      NULL,
      1,
      NULL,
      3,
      5,
      4,
      NULL,
      2,
      1,
      NULL,
      0,
      0,
      7.131822,
      2,
      ' 0- 6-1975',
      313,
      ' 0-10-1997',
      3,
      1.954891,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      2.356082,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.841828,
      8.697814,
      2,
      5.641030,
      8.504983,
      9.266872,
      0,
      0.994315,
      1,
      1.184522,
      1.749125,
      1.192745,
      NULL,
      2,
      2,
      4,
      ' 7-16-1977',
      5.539960,
      ' 4- 9-1977',
      4.517985,
      1,
      0,
      1.250769,
      2,
      0.248737,
      1,
      0,
      1.746404,
      1,
      NULL,
      3,
      73.492673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      1,
      NULL,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.323603,
      0,
      0,
      0,
      1.816120,
      NULL,
      0,
      0,
      0,
      NULL,
      0.895157,
      1.043915,
      NULL,
      1,
      0,
      0,
      0.892674,
      3.547702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.543012,
      NULL,
      NULL,
      76,
      NULL,
      NULL,
      0,
      2.602510,
      '33324',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      8.277563,
      39.432568,
      NULL,
      1,
      NULL,
      NULL,
      10.650916,
      4,
      1.825983,
      0,
      3,
      1,
      0,
      0,
      1.260846,
      0.937363,
      0.617743,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      0.741280,
      1,
      1.762238,
      1,
      1.764352,
      1,
      0.264814,
      NULL,
      NULL,
      0.381309,
      1.327570,
      0.500907,
      3,
      1,
      0.555853,
      0.752534,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      8,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599839,
      NULL,
      NULL,
      NULL,
      0.015508,
      NULL,
      NULL,
      NULL,
      0.598401,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1.547160,
      0.488132,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.541668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1.640742,
      NULL,
      NULL,
      NULL,
      1.989929,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.436255,
      0.025442,
      0.251541,
      3.039762,
      1,
      NULL,
      NULL,
      NULL,
      9,
      2,
      1,
      NULL,
      3.519937,
      NULL,
      1.697505,
      0.592185,
      1,
      7.153701,
      NULL,
      1.966846,
      1.572680,
      NULL,
      NULL,
      1.680905,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      2.081698,
      1.588122,
      1,
      NULL,
      5,
      1.308778,
      0,
      4.594487,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      1.192394,
      2.337191,
      1.258353,
      0.186371,
      NULL,
      9.794148,
      NULL,
      NULL,
      1.083387,
      2,
      4.241696,
      NULL,
      NULL,
      0,
      NULL,
      3.883478,
      0.025304,
      NULL,
      1.998135,
      3,
      7.598797,
      4.210391,
      5,
      9,
      2,
      0,
      1,
      2,
      0,
      0.017865,
      0,
      0.684868,
      1,
      0,
      NULL,
      NULL,
      1.443672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.263352,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.004259,
      NULL,
      0,
      NULL,
      0,
      2.093894,
      3,
      NULL,
      NULL,
      6.061739,
      0.180373,
      NULL,
      NULL,
      0.314631,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.186000,
      NULL,
      NULL,
      NULL,
      1.913279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.668614,
      NULL,
      NULL,
      0.384806,
      0.772942,
      NULL,
      NULL,
      NULL,
      0.393691,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.072825,
      2.988463,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      0.265155,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.058645,
      0.618031,
      NULL,
      NULL,
      3.885059,
      2.513189,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10.538224,
      5.778206,
      NULL,
      NULL,
      2.886548,
      NULL,
      7,
      0,
      NULL,
      7.381418,
      NULL,
      1.048485,
      NULL,
      NULL,
      0.745329,
      NULL,
      NULL,
      1.316485,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.437405,
      NULL,
      NULL,
      1,
      NULL,
      0.147519,
      13723,
      944.905327,
      1.035722,
      0.961780,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1.908504,
      NULL,
      NULL,
      0.217644,
      NULL,
      0,
      1,
      NULL,
      0,
      1.993807,
      NULL,
      2,
      NULL,
      0.758800,
      NULL,
      0.400920,
      NULL,
      1.409879,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.192474,
      10,
      33,
      NULL,
      NULL,
      3.871414,
      NULL,
      1.079477,
      NULL,
      0.970985,
      NULL,
      0.152597,
      NULL,
      0,
      NULL,
      1.966393,
      NULL,
      0.804569,
      NULL,
      1.274620,
      NULL,
      1,
      NULL,
      0.421905,
      NULL,
      NULL,
      NULL,
      0.430155,
      NULL,
      1.893420,
      NULL,
      1,
      NULL,
      1.349322,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812339,
      1.458607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272990,
      NULL,
      NULL,
      2.860742,
      NULL,
      2.270417,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.924806,
      NULL,
      0,
      1.185970,
      2.145695,
      26,
      42.025125,
      1,
      0.213638,
      3.140688,
      1,
      1,
      3,
      NULL,
      3,
      3,
      3.418364,
      NULL,
      1,
      3.707525,
      0.650332,
      0.116715,
      0,
      2.803480,
      1.560351,
      0,
      0.740500,
      1,
      1.820326,
      1,
      NULL,
      NULL,
      0.593886,
      NULL,
      1.891798,
      1,
      1.600686,
      1,
      0,
      1.943152,
      0.367870,
      0.649713,
      1,
      0,
      1.667960,
      1.299052,
      1.604811,
      1.666562,
      NULL,
      1,
      NULL,
      2,
      0.934459,
      1,
      0,
      NULL,
      2.723635,
      1,
      1.489803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884679,
      0.527479,
      1.324387,
      1,
      1.873808,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      100.052255,
      8.310428,
      3,
      0.179203,
      3,
      '44002',
      '21202',
      '34241',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


