set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9738659';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.904237,
      2.652562,
      0,
      3.553524,
      2.700997,
      2.013183,
      NULL,
      NULL,
      NULL,
      '40',
      46,
      42.588488,
      '1241212',
      0,
      0.759384,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 9-14-1984',
      15,
      NULL,
      NULL,
      1,
      3.319593,
      ' 8- 4-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 2-18-1986',
      1,
      1.613578,
      NULL,
      1.971491,
      0,
      1,
      0,
      2.656577,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1.326338,
      NULL,
      1,
      1.318032,
      0.604821,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.870007,
      4,
      NULL,
      1,
      1,
      0,
      5,
      0,
      1,
      1,
      NULL,
      2,
      1,
      5.030080,
      0,
      0,
      1,
      NULL,
      0.584583,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      4,
      NULL,
      0.433161,
      NULL,
      2.963278,
      1.884557,
      2,
      NULL,
      NULL,
      0.721350,
      1,
      NULL,
      0.835041,
      2.374081,
      3.306212,
      2,
      2.566727,
      2,
      0,
      NULL,
      8,
      1,
      1,
      2,
      1.138005,
      NULL,
      NULL,
      1.556264,
      NULL,
      NULL,
      0,
      3,
      5,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0.063135,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      4,
      0,
      1,
      4,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      2,
      1,
      2,
      0,
      NULL,
      1,
      0.612214,
      NULL,
      ' 8-10-1981',
      92,
      NULL,
      6,
      2.583109,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      1,
      1,
      1,
      0.049554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.539218,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446675,
      0.437681,
      0.311555,
      0,
      0,
      1,
      0.463829,
      1.652586,
      NULL,
      2.821718,
      1.913851,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      4,
      0.728422,
      NULL,
      2.095046,
      0.821318,
      1.300452,
      0,
      0,
      0,
      1.888602,
      0.716635,
      NULL,
      NULL,
      1,
      0.910428,
      1,
      6.728369,
      1.815759,
      NULL,
      NULL,
      8.480312,
      3,
      NULL,
      1,
      4,
      2.871292,
      3.041674,
      3,
      NULL,
      NULL,
      1.200106,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591465,
      1,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      3,
      NULL,
      8.684697,
      1,
      11.651650,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1.543317,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.485636,
      0,
      0,
      NULL,
      1.473892,
      1.669581,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.201631,
      NULL,
      NULL,
      NULL,
      2.778667,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.577067,
      NULL,
      0,
      2,
      1.155634,
      0,
      1.767236,
      0.305305,
      0.636174,
      0,
      0,
      NULL,
      NULL,
      1.203648,
      0,
      3,
      0.259994,
      0,
      NULL,
      0.880271,
      2,
      0.640418,
      NULL,
      2.171736,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.919803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.180616,
      1.678027,
      NULL,
      0,
      1.885739,
      NULL,
      NULL,
      7,
      NULL,
      4,
      1.656331,
      1.467868,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0.497134,
      NULL,
      NULL,
      0.337306,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.879265,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.815855,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0.287747,
      7,
      5,
      4,
      3.227792,
      0,
      1,
      3.773310,
      NULL,
      NULL,
      1.717036,
      NULL,
      NULL,
      1.023480,
      1,
      0,
      0.682821,
      2,
      1,
      NULL,
      0,
      5.161635,
      3.369329,
      3,
      0.571977,
      3,
      NULL,
      0.902716,
      NULL,
      NULL,
      0,
      1.285431,
      2.741129,
      0,
      1.344032,
      2,
      1,
      0.033042,
      5,
      0.155481,
      2,
      0,
      4,
      1.266335,
      0.320358,
      1,
      0,
      0.224526,
      0.583451,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.325668,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.638407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097530,
      NULL,
      NULL,
      1.510381,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.132113,
      0.378179,
      0,
      2,
      1.343596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.847257,
      NULL,
      NULL,
      NULL,
      0.714907,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.245432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0.119049,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      1,
      NULL,
      NULL,
      1.429665,
      NULL,
      NULL,
      0.921533,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      43.257914,
      NULL,
      0,
      1.964308,
      1,
      NULL,
      NULL,
      NULL,
      0.976354,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0.696598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      13.624171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.334984,
      1,
      0.627328,
      0,
      0.396636,
      NULL,
      1.694930,
      1.995084,
      NULL,
      0,
      1.532162,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.562721,
      NULL,
      0.808340,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.897309,
      1,
      NULL,
      NULL,
      1.265883,
      NULL,
      0.433182,
      2.137475,
      NULL,
      0.031199,
      0,
      NULL,
      2.789087,
      0.085543,
      0.921993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      101,
      NULL,
      NULL,
      2.985979,
      '43404',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      1.568360,
      NULL,
      '',
      '');
commit;
end;
/


