set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7125247';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '4331134',
      2.265765,
      1,
      NULL,
      0,
      '4142',
      NULL,
      1.701183,
      NULL,
      NULL,
      '10-27-1976',
      NULL,
      NULL,
      4,
      0.216687,
      NULL,
      ' 2- 0-1992',
      NULL,
      3.273677,
      168.940524,
      16.246782,
      NULL,
      ' 4-26-1979',
      NULL,
      ' 6-18-1974',
      0,
      1.452049,
      NULL,
      NULL,
      NULL,
      0.901317,
      2,
      1,
      0.673294,
      39.668570,
      2,
      NULL,
      1,
      19,
      NULL,
      1,
      29,
      5,
      0,
      8.051005,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      NULL,
      4,
      1,
      1,
      3,
      4,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      9,
      0,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.824889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      4,
      0,
      0,
      3.762126,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      1,
      0,
      0,
      5,
      3,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1208,
      ' 7- 1-1978',
      4.875778,
      1.513107,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.395004,
      0,
      0.588925,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.210428,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.272828,
      NULL,
      0.691146,
      0.719403,
      1.193053,
      1.019075,
      1,
      NULL,
      NULL,
      2.733783,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057264,
      NULL,
      2,
      0,
      2,
      2,
      0,
      3,
      2,
      1,
      3,
      2,
      1.371525,
      17,
      18.497938,
      115,
      38,
      129.068266,
      75.043419,
      145.699592,
      57,
      116.959483,
      16.794579,
      8,
      83.573237,
      NULL,
      65,
      NULL,
      3.564827,
      0.232572,
      0.365791,
      6,
      NULL,
      NULL,
      6,
      9.325046,
      1,
      4.262767,
      2.465659,
      NULL,
      1,
      3.233284,
      2.842512,
      35,
      1,
      NULL,
      NULL,
      37,
      33,
      21.671191,
      NULL,
      1,
      NULL,
      '02011',
      '',
      '',
      0.493432,
      '',
      '',
      '',
      1.994778,
      '',
      '',
      '',
      2.556789,
      33,
      157,
      41,
      2.623550,
      43,
      1,
      1.142793,
      0,
      3,
      NULL,
      NULL,
      2,
      1.867405,
      1.940526,
      1.225790,
      NULL,
      NULL,
      3,
      1,
      0,
      3.189518,
      NULL,
      NULL,
      2.721451,
      NULL,
      3.319894,
      1.401297,
      0.275877,
      2,
      NULL,
      NULL,
      NULL,
      0.747848,
      NULL,
      NULL,
      0.527466,
      NULL,
      NULL,
      1.780321,
      NULL,
      NULL,
      1.540601,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      1,
      3,
      2,
      2,
      1.841385,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857386,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.148467,
      0,
      1,
      1.041450,
      0,
      NULL,
      0,
      0.339649,
      1,
      1.639697,
      0.093911,
      0,
      0.565177,
      NULL,
      NULL,
      1.571633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.334662,
      0.052084,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.332312,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.087802,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.222409,
      0.900326,
      1.900824,
      NULL,
      0.759873,
      NULL,
      2.229574,
      1,
      1,
      1.714726,
      0,
      0,
      0.767283,
      NULL,
      NULL,
      0.483805,
      NULL,
      NULL,
      0.535199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.938332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.304415,
      1,
      NULL,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.086925,
      NULL,
      NULL,
      1.183515,
      NULL,
      NULL,
      NULL,
      0,
      1.274554,
      0,
      NULL,
      NULL,
      2.763425,
      1,
      2.196251,
      0.389777,
      0.654382,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      2.460879,
      7,
      0.208725,
      5.174960,
      3,
      NULL,
      NULL,
      0.124464,
      NULL,
      4,
      3.007957,
      2,
      3,
      0.877550,
      2.403523,
      NULL,
      NULL,
      0.806909,
      NULL,
      NULL,
      58.302237,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.617939,
      1,
      NULL,
      0.031289,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.603543,
      NULL,
      1,
      1,
      NULL,
      0,
      1.869887,
      NULL,
      2,
      5.070573,
      NULL,
      5,
      0.344397,
      NULL,
      0.853431,
      1.854933,
      0,
      NULL,
      0.249989,
      NULL,
      NULL,
      1.936690,
      0,
      NULL,
      NULL,
      11,
      22,
      NULL,
      NULL,
      1.047972,
      1,
      NULL,
      NULL,
      NULL,
      0.341378,
      NULL,
      NULL,
      1,
      1.720492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.342484,
      NULL,
      NULL,
      NULL,
      0.159854,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.499751,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.398828,
      0.349657,
      NULL,
      NULL,
      0.987829,
      0.611991,
      NULL,
      NULL,
      1.305219,
      0.652958,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0.036232,
      NULL,
      NULL,
      1.232443,
      NULL,
      NULL,
      NULL,
      0.152228,
      0.700297,
      NULL,
      NULL,
      2.802000,
      0,
      NULL,
      NULL,
      0.843471,
      NULL,
      NULL,
      NULL,
      0.985842,
      131.006883,
      23,
      NULL,
      NULL,
      1130.631350,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      21,
      5,
      0,
      109.894848,
      14.790676,
      NULL,
      NULL,
      1,
      19764,
      0.419673,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0.360899,
      0.268001,
      0,
      0.797799,
      0.883436,
      0,
      1,
      0,
      0.440335,
      0.977465,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      2.022939,
      1,
      2,
      NULL,
      2,
      2,
      1,
      1,
      0.843580,
      1.919301,
      0.263765,
      NULL,
      0.066444,
      NULL,
      NULL,
      0,
      0.161204,
      0.785077,
      1,
      0.633247,
      0.883894,
      0.630942,
      1.082701,
      0.260587,
      NULL,
      0.353702,
      1,
      0.050314,
      NULL,
      1.112767,
      1.914727,
      1.170284,
      1,
      1,
      1,
      2,
      0,
      1,
      1.175609,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811426,
      0.919562,
      NULL,
      0,
      0,
      1.217756,
      2,
      NULL,
      3,
      2.285008,
      1.904214,
      1.491499,
      13,
      61,
      2,
      0.221310,
      3.424961,
      '13320',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


