set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8918230';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '3324224',
      2,
      0.916238,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-25-1987',
      8,
      NULL,
      5,
      0,
      0,
      ' 4-14-1983',
      52,
      0.280104,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1992',
      ' 9-24-1989',
      ' 6- 3-1982',
      1,
      NULL,
      3,
      0.487279,
      NULL,
      2.328155,
      0,
      1,
      NULL,
      37,
      5,
      17.601616,
      NULL,
      12.388013,
      15,
      5,
      17.585340,
      3,
      3,
      7,
      3.460488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.502792,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      0,
      4,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.004105,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.814883,
      3,
      1,
      NULL,
      NULL,
      1.889520,
      0,
      NULL,
      1,
      3,
      3.768276,
      3,
      2,
      NULL,
      1,
      0,
      NULL,
      2,
      0,
      NULL,
      1.986298,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      2,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.924530,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      4,
      0,
      NULL,
      2,
      3,
      NULL,
      2,
      3,
      0,
      0,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      5,
      5,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      '11-21-1984',
      NULL,
      3.349616,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0.173774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      2,
      0,
      1,
      0.755792,
      0,
      0,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4.114483,
      0.627684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.636025,
      0,
      1.552626,
      1,
      0,
      0,
      1.534707,
      3.468205,
      NULL,
      2.656005,
      1.076964,
      NULL,
      NULL,
      NULL,
      1,
      1.727056,
      0,
      3,
      3,
      0,
      3,
      2,
      1,
      1,
      0,
      3,
      0,
      1,
      2.772549,
      1,
      1.887985,
      3,
      0,
      NULL,
      1.684931,
      NULL,
      1.272300,
      1,
      0.831669,
      NULL,
      NULL,
      1.918963,
      0,
      0.340427,
      2,
      1.648994,
      NULL,
      6.663534,
      NULL,
      NULL,
      2.495946,
      0,
      1.617991,
      0,
      NULL,
      NULL,
      0,
      0.886652,
      46,
      0,
      NULL,
      NULL,
      54,
      10,
      84.821684,
      0,
      NULL,
      NULL,
      '21231',
      NULL,
      '',
      0.615426,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      NULL,
      30.156216,
      49.678410,
      38.823039,
      2,
      16.869592,
      5,
      2.818564,
      0,
      3.572781,
      NULL,
      0.468040,
      1,
      NULL,
      NULL,
      0.614646,
      2.576979,
      0.379962,
      3.068498,
      2,
      2,
      0,
      0,
      3.004753,
      0.387724,
      NULL,
      NULL,
      3.998944,
      3.260012,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.796304,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      0.519457,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.218247,
      1,
      0.965501,
      1.027941,
      NULL,
      NULL,
      0.229555,
      NULL,
      NULL,
      1.122788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531071,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      0.393929,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.099637,
      NULL,
      NULL,
      1.957679,
      NULL,
      0.122321,
      2,
      0.656833,
      NULL,
      0.693172,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.015577,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.428767,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0.859614,
      0,
      4,
      NULL,
      NULL,
      0.591469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.228817,
      NULL,
      0.322763,
      3.230736,
      1,
      NULL,
      1.477687,
      0.851122,
      0,
      1,
      0.583572,
      NULL,
      2,
      0,
      NULL,
      0,
      3,
      NULL,
      8,
      NULL,
      5.638395,
      NULL,
      NULL,
      NULL,
      3.425723,
      1,
      3,
      1.883900,
      0.919952,
      3,
      1,
      1,
      0.951869,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.584872,
      NULL,
      NULL,
      3.249022,
      NULL,
      NULL,
      1.453371,
      NULL,
      NULL,
      1.511261,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      2.808580,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.388396,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.772524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.665566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676566,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.084925,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      2,
      3.157632,
      49.889382,
      NULL,
      NULL,
      12,
      0.045143,
      0,
      NULL,
      NULL,
      0.718679,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      737,
      14.592262,
      0,
      2.404130,
      0,
      0.632505,
      0,
      0.848129,
      NULL,
      0,
      NULL,
      1.838418,
      1,
      0.601476,
      NULL,
      2.811009,
      1.050696,
      1,
      0.556386,
      2,
      NULL,
      NULL,
      NULL,
      0.238877,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      24.643200,
      NULL,
      NULL,
      19.848767,
      NULL,
      1.565235,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.372175,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.231998,
      NULL,
      0.734341,
      NULL,
      1,
      NULL,
      0.257487,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.173276,
      NULL,
      0.968217,
      NULL,
      3,
      NULL,
      NULL,
      1.957767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      210.505206,
      NULL,
      2,
      NULL,
      2.404736,
      NULL,
      3.483569,
      NULL,
      0.537244,
      0.968528,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.044138,
      0.292083,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.645521,
      NULL,
      1,
      1,
      2.394184,
      NULL,
      1.898437,
      NULL,
      3,
      NULL,
      301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816931,
      2.779896,
      0,
      11,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      3.629113,
      3.759682,
      0,
      5.053584,
      2,
      0,
      3.616174,
      NULL,
      0.750292,
      1,
      1,
      NULL,
      1,
      1.510284,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.345534,
      3,
      NULL,
      1,
      0.697845,
      NULL,
      0.390927,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.484457,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      0.979357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.680626,
      NULL,
      1.182832,
      NULL,
      0,
      4,
      7,
      3.477445,
      0.414580,
      0,
      3.009027,
      NULL,
      NULL,
      0.286869,
      NULL,
      '34423',
      '10412',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


