set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7223768';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      '22',
      12.686129,
      10,
      '1021042',
      1,
      0.170784,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-15-1983',
      10,
      6.457643,
      NULL,
      0,
      1.303918,
      ' 8-25-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 7-17-2003',
      '11- 2-1990',
      0.876383,
      0,
      0,
      0,
      0,
      3,
      NULL,
      0.988059,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      4,
      1,
      5,
      4,
      0,
      NULL,
      1,
      1,
      4.831160,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      4,
      9.451571,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      0.140142,
      NULL,
      NULL,
      1,
      1,
      2,
      3,
      3,
      1,
      NULL,
      0,
      NULL,
      4,
      2,
      0,
      NULL,
      5,
      0,
      1,
      NULL,
      1,
      0.134727,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      3,
      NULL,
      5,
      2,
      3,
      0,
      0,
      4,
      0,
      NULL,
      4,
      NULL,
      2,
      2.718768,
      NULL,
      111,
      ' 7-24-1999',
      NULL,
      1.113099,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      5,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.026041,
      1.869750,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.967089,
      3.548928,
      2.229893,
      2.150347,
      1.782353,
      NULL,
      2,
      1.396956,
      NULL,
      NULL,
      NULL,
      2.581424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      0.671178,
      NULL,
      NULL,
      31,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.499750,
      2.478788,
      3,
      2,
      1,
      3,
      NULL,
      3,
      NULL,
      0,
      2,
      2,
      3.206981,
      0.419205,
      0.493719,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1.330247,
      NULL,
      NULL,
      0.006568,
      1.496890,
      NULL,
      3.039720,
      5,
      0,
      1,
      4,
      3.576270,
      11.178082,
      1,
      3.232226,
      1,
      NULL,
      3,
      NULL,
      NULL,
      3,
      34,
      2,
      NULL,
      29,
      NULL,
      NULL,
      29,
      1,
      1,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      2.565368,
      41,
      30,
      NULL,
      0.541029,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275543,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.338425,
      NULL,
      NULL,
      3.583887,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.834047,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3.766759,
      3.682906,
      1.095238,
      3.934971,
      0.522913,
      1,
      1,
      NULL,
      NULL,
      1.710515,
      NULL,
      NULL,
      0.220146,
      6.646200,
      6.232248,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966069,
      NULL,
      NULL,
      0.444493,
      NULL,
      NULL,
      0.920439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.318977,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.169800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.588019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501267,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935271,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.163948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.757363,
      1,
      1.230642,
      1,
      1.333069,
      NULL,
      NULL,
      0.558002,
      1.394780,
      0,
      NULL,
      2.178369,
      1.169566,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.719440,
      0.137564,
      1,
      0.348264,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      4,
      0,
      0.603285,
      NULL,
      1.057519,
      1,
      NULL,
      NULL,
      NULL,
      1.358857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.832099,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.088481,
      NULL,
      NULL,
      0.070478,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.807522,
      1.226502,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1.348025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.760917,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.890284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770885,
      NULL,
      NULL,
      NULL,
      0.500647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986252,
      NULL,
      NULL,
      NULL,
      0.289139,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465197,
      225.422701,
      1.602650,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.789227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.672511,
      1,
      2099,
      1,
      1,
      0.775449,
      0,
      0.437613,
      1.905164,
      1,
      1.992012,
      1.738676,
      1,
      1.518433,
      1,
      0.038263,
      0,
      0.839456,
      NULL,
      0,
      1.548971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.132183,
      NULL,
      1.442944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107191,
      2.277260,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.715993,
      NULL,
      0.796568,
      1,
      1.719503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.193889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.648713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937921,
      2.001478,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516359,
      NULL,
      0,
      NULL,
      0.498356,
      1,
      1.678558,
      20.034554,
      23,
      1.051815,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      2,
      NULL,
      1,
      4.248073,
      2.932372,
      NULL,
      0.644685,
      0,
      0.631787,
      NULL,
      NULL,
      1.141753,
      NULL,
      NULL,
      3.274595,
      NULL,
      1,
      1.915515,
      NULL,
      1.548802,
      1.603217,
      NULL,
      1,
      1,
      NULL,
      0.787787,
      1.993182,
      NULL,
      0,
      0,
      NULL,
      0.828766,
      0.650969,
      NULL,
      0,
      1.944244,
      NULL,
      1.389486,
      3.936484,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093641,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      0.415601,
      NULL,
      NULL,
      36,
      26,
      5,
      NULL,
      1,
      '42201',
      '14104',
      '',
      0.670712,
      '',
      NULL,
      NULL,
      0,
      '10343',
      '',
      '');
commit;
end;
/


