set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8720748';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '0013431',
      2,
      1,
      1,
      2,
      NULL,
      3,
      1.267633,
      NULL,
      NULL,
      ' 7- 0-1983',
      12.115810,
      NULL,
      2,
      2.814958,
      1,
      ' 4- 5-1984',
      NULL,
      5.118785,
      318.551067,
      158.159081,
      NULL,
      NULL,
      ' 3- 5-1981',
      ' 1- 4-1994',
      1,
      NULL,
      1.739605,
      1,
      1,
      3,
      3,
      1.196412,
      0,
      115.015497,
      0,
      4.510763,
      0,
      186,
      NULL,
      NULL,
      10,
      4,
      2,
      11.648166,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1.259651,
      1,
      1.069596,
      1.274751,
      128,
      5,
      0,
      4,
      3.104155,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      3,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0.128144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      3.179560,
      3,
      NULL,
      0.186766,
      2,
      2,
      1.430358,
      NULL,
      0,
      1.849122,
      1.051969,
      2.082220,
      1.223134,
      1,
      1.138040,
      0.858899,
      3.043535,
      2,
      1,
      0,
      2.167436,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      5,
      1,
      1,
      0,
      2,
      1,
      2,
      4,
      0,
      NULL,
      1,
      6.574290,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1,
      2,
      NULL,
      5,
      0,
      1,
      1,
      5,
      3,
      1,
      5,
      0,
      2,
      5,
      0,
      0,
      5,
      3,
      NULL,
      5,
      5,
      4,
      0,
      NULL,
      5,
      NULL,
      9,
      0,
      ' 9- 0-2002',
      NULL,
      NULL,
      1612,
      NULL,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.124307,
      2.130470,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.957933,
      1.655968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1.559112,
      0,
      3.975201,
      590.147708,
      0,
      2,
      168.315062,
      1166.554935,
      NULL,
      1,
      1.362026,
      0,
      2,
      2,
      3,
      1,
      2,
      0,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      16.467962,
      49,
      65.989764,
      95,
      167,
      145,
      NULL,
      1,
      0,
      1.408193,
      66.528302,
      21,
      NULL,
      1,
      15.595234,
      6.531039,
      1.412522,
      NULL,
      NULL,
      NULL,
      4,
      8,
      5,
      0,
      0.040736,
      0.876645,
      0.286520,
      3,
      NULL,
      4,
      3,
      0.326835,
      NULL,
      57,
      NULL,
      NULL,
      1,
      0.306021,
      2.534459,
      '00331',
      '',
      '',
      0.638175,
      '',
      '',
      '',
      NULL,
      '01330',
      '',
      '',
      NULL,
      22,
      NULL,
      44,
      0,
      20.087379,
      NULL,
      32.179673,
      0,
      2,
      0.274801,
      3,
      1.112368,
      NULL,
      NULL,
      1.639505,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.062763,
      0,
      NULL,
      2,
      1.221780,
      3,
      1,
      0,
      1,
      0.624641,
      NULL,
      NULL,
      1.117033,
      NULL,
      NULL,
      0.312494,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.940552,
      NULL,
      NULL,
      1,
      0.284587,
      NULL,
      NULL,
      NULL,
      0.710443,
      NULL,
      NULL,
      NULL,
      3,
      1.325511,
      2,
      13,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1.645508,
      0.620868,
      NULL,
      1.957054,
      1,
      0.336607,
      1,
      1,
      0,
      0,
      0,
      3.168062,
      0.972856,
      2,
      3,
      3,
      NULL,
      0.054089,
      NULL,
      NULL,
      NULL,
      2,
      1.253606,
      0,
      9.412690,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.324187,
      NULL,
      NULL,
      NULL,
      0.798160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.031414,
      1,
      0,
      0,
      NULL,
      NULL,
      1.979249,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1.582725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516064,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.330815,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      0.546707,
      NULL,
      NULL,
      NULL,
      1.842733,
      1.219707,
      3,
      1,
      NULL,
      NULL,
      0.323759,
      0.003642,
      1,
      0,
      1.330410,
      0,
      1,
      NULL,
      1.703644,
      0.133184,
      3.958133,
      3.201205,
      1,
      3.661363,
      8,
      0,
      7,
      7.535119,
      0,
      3.157955,
      2,
      NULL,
      4,
      0.496716,
      0.111076,
      0,
      0,
      1.143215,
      NULL,
      NULL,
      NULL,
      1.210384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662809,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.358116,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0.420947,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.583999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.645849,
      1.103705,
      NULL,
      NULL,
      1.893194,
      NULL,
      NULL,
      NULL,
      1.464309,
      0.623707,
      NULL,
      NULL,
      0,
      0.632816,
      NULL,
      NULL,
      1.805642,
      0.962111,
      NULL,
      NULL,
      0.765866,
      0.880408,
      NULL,
      NULL,
      0,
      0.984847,
      NULL,
      NULL,
      0.997844,
      1.646361,
      NULL,
      NULL,
      1.414092,
      NULL,
      NULL,
      NULL,
      0.193859,
      69,
      893,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4.828762,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      156.242300,
      1,
      1,
      0.025130,
      0.116878,
      0.012103,
      0.366879,
      1.258375,
      0.396021,
      1,
      0.867152,
      0.261238,
      NULL,
      1.845507,
      1.988743,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.759316,
      0.580304,
      NULL,
      1.253067,
      1,
      NULL,
      NULL,
      1.237469,
      0,
      0.964751,
      0,
      2.400673,
      1.166690,
      NULL,
      0.969873,
      1.182655,
      0,
      2,
      1.786558,
      1,
      0.620706,
      1,
      0,
      0,
      1,
      1.260451,
      2,
      0.430187,
      1.810429,
      0.993363,
      1.723458,
      1,
      3,
      1,
      0,
      NULL,
      1,
      3.269113,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782105,
      1,
      0.726715,
      NULL,
      0,
      1,
      2,
      2,
      NULL,
      NULL,
      0.877797,
      NULL,
      47,
      NULL,
      1,
      NULL,
      1.514725,
      '03421',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2.279074,
      '32101',
      '',
      '');
commit;
end;
/


