set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9405403';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '0441010',
      1,
      NULL,
      5,
      3,
      '1302',
      0,
      0.277219,
      NULL,
      NULL,
      '10- 5-1997',
      36,
      NULL,
      0,
      1.047027,
      2.633748,
      ' 3-28-2001',
      12.900094,
      3.265335,
      294,
      NULL,
      0,
      NULL,
      NULL,
      ' 2- 7-1975',
      3,
      1,
      2.835306,
      0,
      1.095725,
      1.400320,
      3,
      0.017464,
      NULL,
      NULL,
      NULL,
      7,
      7.715923,
      2,
      20.756826,
      NULL,
      8.941595,
      2,
      3,
      1.282532,
      1.571455,
      3,
      0,
      1.576694,
      0.495689,
      0,
      0,
      0.543113,
      1.292317,
      0.455760,
      0,
      NULL,
      5,
      4,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      NULL,
      0,
      0.216462,
      NULL,
      2.987181,
      0.139390,
      NULL,
      2.595107,
      1,
      1.709275,
      NULL,
      1.226054,
      0,
      1,
      0.267698,
      0,
      0,
      0,
      0,
      9,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.257880,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1.915400,
      1,
      0,
      0,
      0,
      0.584511,
      NULL,
      1.717250,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      2,
      0,
      NULL,
      57.989116,
      ' 3- 4-1994',
      99.395958,
      0.498536,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6,
      3.370621,
      1.254443,
      2,
      1.963144,
      NULL,
      1.872669,
      1,
      1.555065,
      5,
      0,
      3,
      3.659427,
      1,
      3,
      0.298742,
      NULL,
      1.373927,
      0,
      4.851442,
      NULL,
      NULL,
      2.101190,
      NULL,
      1,
      0,
      NULL,
      0.514811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      24,
      0.408226,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.846642,
      2,
      NULL,
      1,
      3,
      NULL,
      2,
      2,
      NULL,
      1,
      2,
      3.407434,
      3.714680,
      3,
      2.798429,
      1,
      0,
      1,
      0.776110,
      1,
      0.127210,
      0.456343,
      NULL,
      1.353999,
      0.500557,
      NULL,
      1,
      3,
      2,
      1.408919,
      7.041608,
      6.290148,
      4,
      NULL,
      7,
      4.119353,
      NULL,
      3,
      1.529699,
      3,
      NULL,
      1.355375,
      32.425446,
      1,
      3.416136,
      NULL,
      1,
      34,
      10.877422,
      2,
      1.612843,
      3.168788,
      '10130',
      '',
      '',
      0.588462,
      '',
      '',
      '',
      3.769662,
      NULL,
      NULL,
      '',
      0,
      26,
      32,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065254,
      NULL,
      NULL,
      1.879596,
      NULL,
      NULL,
      0.443579,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.446428,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.247594,
      NULL,
      NULL,
      0.348029,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.366197,
      0.892653,
      NULL,
      NULL,
      1.968404,
      NULL,
      NULL,
      3.442287,
      0.212422,
      0.761063,
      0.959830,
      3,
      NULL,
      0,
      0,
      0,
      3.264650,
      1.943246,
      0,
      0.707906,
      0.682914,
      1.363347,
      0,
      1,
      NULL,
      NULL,
      1.882689,
      3.726035,
      2,
      1.898746,
      NULL,
      NULL,
      3.318066,
      5.184426,
      1,
      1,
      1.851280,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.457694,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.209508,
      NULL,
      NULL,
      1.472332,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228509,
      NULL,
      NULL,
      1.883485,
      NULL,
      NULL,
      1.283164,
      NULL,
      NULL,
      0.918784,
      NULL,
      NULL,
      0.013705,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.928372,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.456248,
      NULL,
      NULL,
      0.760509,
      NULL,
      NULL,
      2.305266,
      1,
      NULL,
      0.172522,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0.179684,
      1,
      0,
      0,
      NULL,
      NULL,
      1.160613,
      NULL,
      NULL,
      3.881208,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      2.959394,
      NULL,
      NULL,
      0.561993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817812,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.272734,
      NULL,
      NULL,
      1.631107,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.109347,
      3.318791,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.805563,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.964107,
      NULL,
      NULL,
      1,
      1.249012,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.134368,
      0.670210,
      NULL,
      NULL,
      1.815956,
      0,
      NULL,
      NULL,
      2.578487,
      1.350503,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.986726,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.305992,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.918715,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      144.074072,
      0,
      1.072758,
      0,
      NULL,
      1.916079,
      NULL,
      1,
      0,
      1,
      0,
      0.355743,
      0,
      NULL,
      0.524042,
      0.347136,
      0,
      0.305744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.682714,
      NULL,
      1.125151,
      0,
      3,
      2,
      0.809949,
      3,
      1.815887,
      1.426812,
      NULL,
      NULL,
      1.391110,
      1.625968,
      1,
      0,
      NULL,
      NULL,
      1.881330,
      1,
      0,
      0,
      0,
      1,
      1.353582,
      1,
      0.068421,
      0.857083,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1.584992,
      NULL,
      0.519015,
      1.213942,
      NULL,
      0,
      0,
      0,
      1.454876,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.554286,
      0,
      0,
      NULL,
      0,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      71,
      134,
      5,
      0,
      1.207951,
      '32004',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      2.367780,
      '3401',
      '',
      NULL);
commit;
end;
/


