set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7322448';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '1341431',
      NULL,
      1.957476,
      2,
      0,
      '3141',
      0,
      2.891270,
      1,
      2.236880,
      ' 7- 5-1993',
      14.973213,
      NULL,
      2,
      1,
      NULL,
      ' 0-11-2000',
      44,
      3.994842,
      148,
      199.353850,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256554,
      1.682744,
      3.971844,
      NULL,
      1,
      NULL,
      6,
      NULL,
      1,
      64,
      7,
      11,
      2,
      15.543426,
      6.516374,
      1,
      20,
      2,
      3,
      10.926388,
      1,
      0,
      0,
      1.289615,
      1.853061,
      1,
      0,
      3.160989,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      0,
      2,
      2,
      5,
      1,
      0,
      0,
      2,
      0,
      NULL,
      4.233898,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0.086284,
      NULL,
      0,
      0,
      4,
      1,
      4,
      NULL,
      NULL,
      5,
      2,
      0,
      NULL,
      4,
      1,
      NULL,
      0,
      2,
      5,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      1.386297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.409727,
      1.898984,
      NULL,
      NULL,
      NULL,
      4.397701,
      1,
      1,
      1.986997,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.790570,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.188615,
      1.850704,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.471367,
      0.447742,
      2,
      3,
      0,
      1,
      2,
      NULL,
      1,
      2,
      1,
      2,
      NULL,
      2,
      5.372137,
      NULL,
      0.733974,
      1.277289,
      2.077874,
      1.022102,
      NULL,
      1.018481,
      NULL,
      NULL,
      1.928649,
      0.967784,
      0,
      1,
      1.453165,
      2.536619,
      0.689564,
      9.959881,
      4.103038,
      4,
      8,
      7,
      4,
      2.569909,
      0.079010,
      6.632985,
      1.878812,
      0.793854,
      1.346617,
      NULL,
      1,
      1.872331,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      '14342',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.325812,
      8,
      188.125954,
      27.646904,
      3,
      13,
      4,
      2.888467,
      5,
      0,
      1,
      2,
      1.728243,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1.261899,
      0,
      3,
      1,
      18.199494,
      2.839297,
      NULL,
      NULL,
      0,
      2,
      NULL,
      12,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      2.479471,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.165638,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.087450,
      13.218013,
      10,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3,
      1.052758,
      NULL,
      0,
      0.730506,
      1,
      0.736791,
      1.773041,
      1.100050,
      1,
      1.996027,
      1,
      0.762214,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331855,
      NULL,
      NULL,
      18.280758,
      NULL,
      NULL,
      NULL,
      4.119373,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      2,
      3.500046,
      0,
      0.546577,
      2.957810,
      2,
      0.859072,
      NULL,
      NULL,
      3,
      0,
      0,
      0.996337,
      NULL,
      3.177658,
      3,
      2,
      1,
      0,
      1.659954,
      NULL,
      NULL,
      1.617929,
      NULL,
      NULL,
      1.726166,
      NULL,
      NULL,
      0.309697,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.390997,
      NULL,
      1,
      NULL,
      4.069503,
      1.754491,
      NULL,
      8.188974,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.553000,
      2,
      1,
      3.245479,
      1.975620,
      1,
      3.457701,
      6,
      0.297095,
      6,
      NULL,
      0,
      2.726366,
      NULL,
      0,
      1,
      3,
      2.478785,
      NULL,
      0,
      3.853225,
      3.073886,
      7,
      1.427478,
      2,
      NULL,
      8,
      1,
      1,
      NULL,
      2,
      0.093296,
      0.639620,
      NULL,
      1,
      1.742338,
      3.684093,
      NULL,
      NULL,
      1.290272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.704706,
      0.456460,
      0,
      0,
      0.958922,
      0,
      3,
      NULL,
      NULL,
      2,
      0.734621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882290,
      3.469045,
      NULL,
      NULL,
      0.333700,
      1.453418,
      NULL,
      NULL,
      2.706428,
      0,
      NULL,
      NULL,
      1.775346,
      1,
      NULL,
      NULL,
      1,
      2.362357,
      NULL,
      NULL,
      0.625735,
      0.439323,
      NULL,
      NULL,
      NULL,
      2.578112,
      NULL,
      NULL,
      3.943931,
      0.605247,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.418977,
      1.080659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.359342,
      NULL,
      NULL,
      2.465423,
      5.671117,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.154132,
      24.734407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      40,
      3.705811,
      0.757073,
      260,
      134.805761,
      1,
      19.384469,
      NULL,
      1,
      8,
      0.549040,
      10234.692475,
      NULL,
      0,
      3,
      1.142904,
      1,
      0.751415,
      1.435837,
      0.115240,
      3.804766,
      1,
      1,
      0.146525,
      1,
      1,
      NULL,
      1.435807,
      0,
      NULL,
      3.312571,
      NULL,
      1,
      NULL,
      1.150988,
      NULL,
      1.930874,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      236.833581,
      NULL,
      0.474212,
      NULL,
      43.929871,
      2,
      0.089884,
      2,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.602940,
      NULL,
      NULL,
      NULL,
      0.071873,
      NULL,
      1.417873,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.893006,
      NULL,
      2.009967,
      NULL,
      0.041197,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0.214011,
      0.023584,
      3.188716,
      NULL,
      NULL,
      0.744493,
      1,
      0,
      NULL,
      1.129753,
      1.862429,
      0,
      3,
      3.899452,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0.836789,
      1,
      3.387317,
      1.060662,
      0,
      3.352441,
      NULL,
      0.078147,
      4.404697,
      1,
      1,
      NULL,
      1,
      0,
      0,
      2.954316,
      1.000729,
      1.896155,
      0,
      3,
      NULL,
      0.499896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.263392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      64.034209,
      NULL,
      4,
      NULL,
      4,
      '43031',
      '44122',
      '',
      1.865762,
      '',
      '',
      '',
      5,
      '0403',
      '1311',
      NULL);
commit;
end;
/


